/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.network.packet;

import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.HudDataProvider;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.IServerPayloadData;
import fi.dy.masa.servux.network.PacketSplitter;
import fi.dy.masa.servux.network.packet.ServuxHudPacket;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8710;

@Environment(value=EnvType.SERVER)
public abstract class ServuxHudHandler<T extends class_8710>
implements IPluginServerPlayHandler<T> {
    private static final ServuxHudHandler<ServuxHudPacket.Payload> INSTANCE = new ServuxHudHandler<ServuxHudPacket.Payload>(){

        public void receive(ServuxHudPacket.Payload payload, ServerPlayNetworking.Context context) {
            INSTANCE.receivePlayPayload(payload, context);
        }
    };
    public static final class_2960 CHANNEL_ID = class_2960.method_60655((String)"servux", (String)"hud_metadata");
    private boolean payloadRegistered = false;
    private final Map<UUID, Integer> failures = new HashMap<UUID, Integer>();
    private static final int MAX_FAILURES = 4;
    private final Map<UUID, Long> readingSessionKeys = new HashMap<UUID, Long>();

    public static ServuxHudHandler<ServuxHudPacket.Payload> getInstance() {
        return INSTANCE;
    }

    @Override
    public class_2960 getPayloadChannel() {
        return CHANNEL_ID;
    }

    @Override
    public boolean isPlayRegistered(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            return this.payloadRegistered;
        }
        return false;
    }

    @Override
    public void setPlayRegistered(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.payloadRegistered = true;
        }
    }

    @Override
    public <P extends IServerPayloadData> void decodeServerData(class_2960 channel, class_3222 player, P data) {
        ServuxHudPacket packet = (ServuxHudPacket)data;
        if (!channel.equals((Object)CHANNEL_ID)) {
            return;
        }
        switch (packet.getType()) {
            case PACKET_C2S_METADATA_REQUEST: {
                HudDataProvider.INSTANCE.sendMetadata(player);
                break;
            }
            case PACKET_C2S_SPAWN_DATA_REQUEST: {
                HudDataProvider.INSTANCE.refreshSpawnMetadata(player, packet.getCompound());
                break;
            }
            case PACKET_C2S_RECIPE_MANAGER_REQUEST: {
                break;
            }
            default: {
                Servux.logger.warn("ServuxHudHandler#decodeServerData(): Invalid packetType '{}' from player: {}, of size in bytes: {}.", (Object)packet.getPacketType(), (Object)player.method_5477().method_54160(), (Object)packet.getTotalSize());
            }
        }
    }

    @Override
    public void reset(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.failures.clear();
        }
    }

    public void resetFailures(class_2960 channel, class_3222 player) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.failures.remove(player.method_5667());
        }
    }

    @Override
    public void receivePlayPayload(T payload, ServerPlayNetworking.Context ctx) {
        if (payload.method_56479().comp_2242().equals((Object)CHANNEL_ID)) {
            class_3222 player = ctx.player();
            INSTANCE.decodeServerData(CHANNEL_ID, player, ((ServuxHudPacket.Payload)payload).data());
        }
    }

    @Override
    public void encodeWithSplitter(class_3222 player, class_2540 buffer, class_3244 networkHandler) {
        INSTANCE.sendPlayPayload(player, new ServuxHudPacket.Payload(ServuxHudPacket.ResponseS2CData(buffer)));
    }

    @Override
    public <P extends IServerPayloadData> void encodeServerData(class_3222 player, P data) {
        ServuxHudPacket packet = (ServuxHudPacket)data;
        if (packet.getType().equals((Object)ServuxHudPacket.Type.PACKET_S2C_NBT_RESPONSE_START)) {
            class_2540 buffer = new class_2540(Unpooled.buffer());
            buffer.method_10794((class_2520)packet.getCompound());
            PacketSplitter.send(this, buffer, player, player.field_13987);
        } else if (!INSTANCE.sendPlayPayload(player, new ServuxHudPacket.Payload(packet))) {
            UUID id = player.method_5667();
            if (!this.failures.containsKey(id)) {
                this.failures.put(id, 1);
            } else if (this.failures.get(id) > 4) {
                HudDataProvider.INSTANCE.onPacketFailure(player);
            } else {
                int count = this.failures.get(id) + 1;
                this.failures.put(id, count);
            }
        }
    }
}

