/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.client;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.ClientConfig;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1291;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_6880;
import org.ladysnake.satin.api.event.ShaderEffectRenderCallback;
import org.ladysnake.satin.api.managed.ManagedShaderEffect;

@Environment(value=EnvType.CLIENT)
public final class ShaderStatusEffectManager
implements ShaderEffectRenderCallback,
ClientPlayConnectionEvents.Disconnect {
    private final ManagedShaderEffect managedShaderEffect;
    private final class_6880<class_1291> potionEffect;
    private final Predicate<ClientConfig> enabledPredicate;
    private boolean enabled = false;

    public ShaderStatusEffectManager(ManagedShaderEffect managedShaderEffect, class_6880<class_1291> potionEffect, Predicate<ClientConfig> enabledPredicate) {
        this.managedShaderEffect = managedShaderEffect;
        this.potionEffect = potionEffect;
        this.enabledPredicate = enabledPredicate;
    }

    public void onEffectAdded(class_6880<class_1291> addedEffect) {
        if (addedEffect == this.potionEffect && this.enabledPredicate.test(Scorchful.getConfig().clientConfig)) {
            this.enabled = true;
        }
    }

    public void onEffectRemoved(class_6880<class_1291> removedEffect) {
        if (removedEffect == this.potionEffect) {
            this.enabled = false;
        }
    }

    public void onPlayerRespawn() {
        this.enabled = false;
    }

    public void onPlayDisconnect(class_634 handler, class_310 client) {
        this.enabled = false;
    }

    public void renderShaderEffects(float tickDelta) {
        if (this.enabled) {
            this.managedShaderEffect.render(tickDelta);
        }
    }
}

