/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.fabric.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;

@Config(name="lootr")
public class ConfigManager
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    private static final List<class_2960> PROBLEMATIC_CHESTS = Arrays.asList(class_2960.method_60655((String)"atum", (String)"chests/pharaoh"), class_2960.method_60655((String)"twilightforest", (String)"structures/stronghold_boss"));
    @ConfigEntry.Gui.Excluded
    private static Set<String> DECAY_MODS = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_5321<class_52>> DECAY_TABLES = null;
    @ConfigEntry.Gui.Excluded
    private static Set<String> REFRESH_MODS = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_5321<class_52>> REFRESH_TABLES = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_5321<class_1937>> DIM_WHITELIST = null;
    @ConfigEntry.Gui.Excluded
    private static Set<String> MODID_DIM_WHITELIST = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_5321<class_1937>> DIM_BLACKLIST = null;
    @ConfigEntry.Gui.Excluded
    private static Set<String> MODID_DIM_BLACKLIST = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_5321<class_1937>> DECAY_DIMS = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_5321<class_1937>> REFRESH_DIMS = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_5321<class_52>> LOOT_BLACKLIST = null;
    @ConfigEntry.Gui.Excluded
    private static Map<class_2248, class_2248> replacements = null;
    @ConfigEntry.Gui.Excluded
    private static Set<String> LOOT_MODIDS = null;
    @ConfigEntry.Gui.CollapsibleObject
    public Debug debug = new Debug();
    @ConfigEntry.Gui.CollapsibleObject
    public Seed seed = new Seed();
    @ConfigEntry.Gui.CollapsibleObject
    public Conversion conversion = new Conversion();
    @ConfigEntry.Gui.CollapsibleObject
    public Breaking breaking = new Breaking();
    @ConfigEntry.Gui.CollapsibleObject
    public Lists lists = new Lists();
    @ConfigEntry.Gui.CollapsibleObject
    public Decay decay = new Decay();
    @ConfigEntry.Gui.CollapsibleObject
    public Refresh refresh = new Refresh();
    @ConfigEntry.Gui.CollapsibleObject
    public Notifications notifications = new Notifications();
    @ConfigEntry.Gui.CollapsibleObject
    public Client client = new Client();

    public static void reset() {
        replacements = null;
        MODID_DIM_WHITELIST = null;
        MODID_DIM_BLACKLIST = null;
        DIM_WHITELIST = null;
        DIM_BLACKLIST = null;
        LOOT_BLACKLIST = null;
        DECAY_MODS = null;
        DECAY_TABLES = null;
        DECAY_DIMS = null;
        LOOT_MODIDS = null;
        REFRESH_DIMS = null;
        REFRESH_MODS = null;
        REFRESH_TABLES = null;
    }

    private static Set<String> validateStringList(List<String> incomingList, String listKey) {
        HashSet<String> validatedList = new HashSet<String>();
        for (String entry : incomingList) {
            if (entry == null || entry.isEmpty()) {
                LootrAPI.LOG.error("Error found when validating a configuration list for '" + listKey + "'. One of the entries is null or empty and cannot be converted to a String.");
                continue;
            }
            validatedList.add(entry);
        }
        return validatedList;
    }

    private static Set<class_5321<class_1937>> validateDimensions(List<String> incomingList, String listKey) {
        HashSet<class_5321<class_1937>> validatedList = new HashSet<class_5321<class_1937>>();
        for (String entry : incomingList) {
            if (entry == null || entry.isEmpty()) {
                throw new RuntimeException("Error found when validating a configuration list for '" + listKey + "'. One of the entries is null or empty and cannot be converted to a dimension identifier.");
            }
            try {
                validatedList.add((class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60656((String)entry)));
            }
            catch (Exception e) {
                throw new RuntimeException("Error found when validating a configuration list for '" + listKey + "'. The value found in the list, '" + entry + "', is not a valid dimension identifier.", e);
            }
        }
        return validatedList;
    }

    private static Set<class_2960> validateResourceLocationList(List<String> incomingList, String listKey) {
        HashSet<class_2960> validatedList = new HashSet<class_2960>();
        for (String entry : incomingList) {
            if (entry == null || entry.isEmpty()) {
                throw new RuntimeException("Error found when validating a configuration list for '" + listKey + "'. One of the entries is null or empty and cannot be converted to a ResourceLocation.");
            }
            try {
                validatedList.add(class_2960.method_60656((String)entry));
            }
            catch (Exception e) {
                throw new RuntimeException("Error found when validating a configuration list for '" + listKey + "'. The value found in the list, '" + entry + "', is not a valid ResourceLocation.", e);
            }
        }
        return validatedList;
    }

    public static ConfigManager get() {
        return (ConfigManager)AutoConfig.getConfigHolder(ConfigManager.class).getConfig();
    }

    public static Set<class_5321<class_1937>> getDimensionWhitelist() {
        if (DIM_WHITELIST == null) {
            DIM_WHITELIST = ConfigManager.get().lists.dimension_whitelist.stream().map(o -> class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)o))).collect(Collectors.toSet());
        }
        return DIM_WHITELIST;
    }

    public static Set<String> getDimensionModidWhitelist() {
        if (MODID_DIM_WHITELIST == null) {
            MODID_DIM_WHITELIST = ConfigManager.get().lists.modid_dimension_whitelist.stream().map(o -> o.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        }
        return MODID_DIM_WHITELIST;
    }

    public static Set<class_5321<class_1937>> getDimensionBlacklist() {
        if (DIM_BLACKLIST == null) {
            DIM_BLACKLIST = ConfigManager.get().lists.dimension_blacklist.stream().map(o -> class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)o))).collect(Collectors.toSet());
        }
        return DIM_BLACKLIST;
    }

    public static Set<String> getDimensionModidBlacklist() {
        if (MODID_DIM_BLACKLIST == null) {
            MODID_DIM_BLACKLIST = ConfigManager.get().lists.modid_dimension_blacklist.stream().map(o -> o.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        }
        return MODID_DIM_BLACKLIST;
    }

    public static Set<class_5321<class_1937>> getDecayDimensions() {
        if (DECAY_DIMS == null) {
            DECAY_DIMS = ConfigManager.get().decay.decay_dimensions.stream().map(o -> class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)o))).collect(Collectors.toSet());
        }
        return DECAY_DIMS;
    }

    public static Set<class_5321<class_1937>> getRefreshDimensions() {
        if (REFRESH_DIMS == null) {
            REFRESH_DIMS = ConfigManager.get().refresh.refresh_dimensions.stream().map(o -> class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)o))).collect(Collectors.toSet());
        }
        return REFRESH_DIMS;
    }

    public static Set<class_5321<class_52>> getLootBlacklist() {
        if (LOOT_BLACKLIST == null) {
            LOOT_BLACKLIST = ConfigManager.get().lists.loot_table_blacklist.stream().map(o -> class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60654((String)o))).collect(Collectors.toSet());
            PROBLEMATIC_CHESTS.forEach(o -> LOOT_BLACKLIST.add((class_5321<class_52>)class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)o)));
        }
        return LOOT_BLACKLIST;
    }

    public static Set<String> getLootModidsBlacklist() {
        if (LOOT_MODIDS == null) {
            LOOT_MODIDS = ConfigManager.get().lists.loot_modid_blacklist.stream().map(o -> o.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        }
        return LOOT_MODIDS;
    }

    public static boolean isBlacklisted(class_5321<class_52> table) {
        if (ConfigManager.getLootBlacklist().contains(table)) {
            return true;
        }
        return ConfigManager.getLootModidsBlacklist().contains(table.method_29177().method_12836());
    }

    public static Set<class_5321<class_52>> getDecayingTables() {
        if (DECAY_TABLES == null) {
            DECAY_TABLES = ConfigManager.get().decay.decay_loot_tables.stream().map(o -> class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60654((String)o))).collect(Collectors.toSet());
        }
        return DECAY_TABLES;
    }

    public static Set<String> getDecayMods() {
        if (DECAY_MODS == null) {
            DECAY_MODS = ConfigManager.get().decay.decay_modids.stream().map(o -> o.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        }
        return DECAY_MODS;
    }

    public static Set<class_5321<class_52>> getRefreshingTables() {
        if (REFRESH_TABLES == null) {
            REFRESH_TABLES = ConfigManager.get().refresh.refresh_loot_tables.stream().map(o -> class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60654((String)o))).collect(Collectors.toSet());
        }
        return REFRESH_TABLES;
    }

    public static Set<String> getRefreshMods() {
        if (REFRESH_MODS == null) {
            REFRESH_MODS = ConfigManager.get().refresh.refresh_modids.stream().map(o -> o.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        }
        return REFRESH_MODS;
    }

    public static boolean isDimensionBlocked(class_5321<class_1937> key) {
        if (!ConfigManager.getDimensionModidWhitelist().isEmpty() && !ConfigManager.getDimensionModidWhitelist().contains(key.method_29177().method_12836()) || ConfigManager.getDimensionModidBlacklist().contains(key.method_29177().method_12836())) {
            return true;
        }
        return !ConfigManager.getDimensionWhitelist().isEmpty() && !ConfigManager.getDimensionWhitelist().contains(key) || ConfigManager.getDimensionBlacklist().contains(key);
    }

    public static boolean isDimensionDecaying(class_5321<class_1937> key) {
        return ConfigManager.getDecayDimensions().contains(key);
    }

    public static boolean isDimensionRefreshing(class_5321<class_1937> key) {
        return ConfigManager.getRefreshDimensions().contains(key);
    }

    public static boolean isDecaying(ILootrInfoProvider tile) {
        if (ConfigManager.get().decay.decay_all) {
            return true;
        }
        if (tile.getInfoLootTable() != null) {
            if (ConfigManager.getDecayingTables().contains(tile.getInfoLootTable())) {
                return true;
            }
            if (ConfigManager.getDecayMods().contains(tile.getInfoLootTable().method_29177().method_12836())) {
                return true;
            }
        }
        if (LootrAPI.isTaggedStructurePresent((class_3218)tile.getInfoLevel(), new class_1923(tile.getInfoPos()), LootrTags.Structure.DECAY_STRUCTURES, tile.getInfoPos())) {
            return true;
        }
        return ConfigManager.isDimensionDecaying(tile.getInfoDimension());
    }

    public static boolean isRefreshing(ILootrInfoProvider tile) {
        if (ConfigManager.get().refresh.refresh_all) {
            return true;
        }
        if (tile.getInfoLootTable() != null) {
            if (ConfigManager.getRefreshingTables().contains(tile.getInfoLootTable())) {
                return true;
            }
            if (ConfigManager.getRefreshMods().contains(tile.getInfoLootTable().method_29177().method_12836())) {
                return true;
            }
        }
        if (LootrAPI.isTaggedStructurePresent((class_3218)tile.getInfoLevel(), new class_1923(tile.getInfoPos()), LootrTags.Structure.REFRESH_STRUCTURES, tile.getInfoPos())) {
            return true;
        }
        return ConfigManager.isDimensionRefreshing(tile.getInfoDimension());
    }

    public static boolean shouldNotify(int remaining) {
        int delay = ConfigManager.get().notifications.notification_delay;
        return !ConfigManager.get().notifications.disable_notifications && (delay == -1 || remaining <= delay);
    }

    public static boolean shouldPerformPiecewiseCheck() {
        return ConfigManager.get().conversion.perform_piecewise_check;
    }

    public static boolean isVanillaTextures() {
        return ConfigManager.get().client.vanilla_textures;
    }

    public static boolean isNewTextures() {
        return ConfigManager.get().client.new_textures;
    }

    public static class_2680 replacement(class_2680 original) {
        class_2248 replacement;
        if (replacements == null) {
            replacements = new HashMap<class_2248, class_2248>();
        }
        if ((replacement = replacements.get(original.method_26204())) == null && original.method_26164(LootrTags.Blocks.CONVERT_BLOCK)) {
            class_2343 entityBlock;
            class_2586 be;
            class_2248 class_22482 = original.method_26204();
            if (class_22482 instanceof class_2343 && (be = (entityBlock = (class_2343)class_22482).method_10123(class_2338.field_10980, original)) instanceof class_2621) {
                if (original.method_26164(LootrTags.Blocks.CONVERT_TRAPPED_CHESTS)) {
                    replacements.put(original.method_26204(), LootrRegistry.getTrappedChestBlock());
                } else if (original.method_26164(LootrTags.Blocks.CONVERT_BARRELS)) {
                    replacements.put(original.method_26204(), LootrRegistry.getBarrelBlock());
                } else if (original.method_26164(LootrTags.Blocks.CONVERT_CHESTS)) {
                    replacements.put(original.method_26204(), LootrRegistry.getChestBlock());
                } else if (original.method_26164(LootrTags.Blocks.CONVERT_SHULKERS)) {
                    replacements.put(original.method_26204(), LootrRegistry.getShulkerBlock());
                }
            }
            replacement = replacements.get(original.method_26204());
        }
        if (replacement != null) {
            return ConfigManager.copyProperties(replacement.method_9564(), original);
        }
        return null;
    }

    private static class_2680 copyProperties(class_2680 state, class_2680 original) {
        for (class_2769 prop : original.method_28501()) {
            if (!state.method_28498(prop)) continue;
            state = ConfigManager.safeReplace(state, original, prop);
        }
        return state;
    }

    private static <V extends Comparable<V>> class_2680 safeReplace(class_2680 state, class_2680 original, class_2769<V> property) {
        if (property == class_2281.field_10770 && state.method_28498(property)) {
            return (class_2680)state.method_11657((class_2769)class_2281.field_10770, (Comparable)class_2745.field_12569);
        }
        if (original.method_28498(property) && state.method_28498(property)) {
            return (class_2680)state.method_11657(property, original.method_11654(property));
        }
        return state;
    }

    public static class Debug {
        public boolean report_unresolved_tables = true;
    }

    public static class Seed {
        public boolean randomize_seed = true;
    }

    public static class Conversion {
        public int max_entry_age = 18000;
        public boolean disable = false;
        public boolean convert_elytras = true;
        public boolean convert_mineshafts = true;
        public boolean world_border = false;
        public boolean perform_piecewise_check = true;
    }

    public static class Breaking {
        public boolean disable_break = false;
        public boolean enable_break = false;
        public boolean enable_fake_player_break = false;
        public boolean power_comparators = true;
        public boolean blast_resistant = false;
        public boolean blast_immune = false;
        public boolean trapped_custom = false;
        public boolean should_drop_player_loot = false;
    }

    public static class Lists {
        public List<String> dimension_whitelist = List.of();
        public List<String> dimension_blacklist = List.of();
        public List<String> loot_table_blacklist = List.of();
        public List<String> loot_modid_blacklist = List.of();
        public List<String> modid_dimension_whitelist = List.of();
        public List<String> modid_dimension_blacklist = List.of();
    }

    public static class Decay {
        public int decay_value = 6000;
        public boolean decay_all = false;
        @ConfigEntry.Gui.RequiresRestart
        public boolean perform_tick_decay = true;
        @ConfigEntry.Gui.RequiresRestart
        public boolean start_tick_decay = false;
        public List<String> decay_modids = List.of();
        public List<String> decay_loot_tables = List.of();
        public List<String> decay_dimensions = List.of();
    }

    public static class Refresh {
        public int refresh_value = 24000;
        public boolean refresh_all = false;
        @ConfigEntry.Gui.RequiresRestart
        public boolean perform_tick_refresh = true;
        @ConfigEntry.Gui.RequiresRestart
        public boolean start_tick_refresh = true;
        public List<String> refresh_modids = List.of();
        public List<String> refresh_loot_tables = List.of();
        public List<String> refresh_dimensions = List.of();
    }

    public static class Notifications {
        public int notification_delay = 600;
        public boolean disable_notifications = false;
        public boolean disable_message_styles = false;
    }

    public static class Client {
        public boolean vanilla_textures = false;
        public boolean new_textures = true;
    }
}

