/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;

public enum LightLevelRenderCondition implements IConfigOptionListEntry
{
    ALWAYS("always", "minihud.label.light_level_render_condition.always", (b, d, s) -> true),
    NEVER("never", "minihud.label.light_level_render_condition.never", (b, d, s) -> false),
    SAFE("safe", "minihud.label.light_level_render_condition.safe", (b, d, s) -> b >= s && (d <= s || b > d)),
    DIM("dim", "minihud.label.light_level_render_condition.dim", (b, d, s) -> b <= d && d > s),
    SPAWNABLE("spawnable", "minihud.label.light_level_render_condition.spawnable", (b, d, s) -> b < s);

    private static final ImmutableList<LightLevelRenderCondition> VALUES;
    private final String configString;
    private final String translationKey;
    private final Condition condition;

    private LightLevelRenderCondition(String configString, String translationKey, Condition condition) {
        this.configString = configString;
        this.translationKey = translationKey;
        this.condition = condition;
    }

    public boolean shouldRender(int blockLightLevel, int dimThreshold, int safeThreshold) {
        return this.condition.shouldRender(blockLightLevel, dimThreshold, safeThreshold);
    }

    public String getStringValue() {
        return this.configString;
    }

    public String getDisplayName() {
        return StringUtils.translate((String)this.translationKey, (Object[])new Object[0]);
    }

    public IConfigOptionListEntry cycle(boolean forward) {
        int id = this.ordinal();
        if (forward) {
            if (++id >= LightLevelRenderCondition.values().length) {
                id = 0;
            }
        } else if (--id < 0) {
            id = LightLevelRenderCondition.values().length - 1;
        }
        return LightLevelRenderCondition.values()[id % LightLevelRenderCondition.values().length];
    }

    public LightLevelRenderCondition fromString(String name) {
        return LightLevelRenderCondition.fromStringStatic(name);
    }

    public static LightLevelRenderCondition fromStringStatic(String name) {
        for (LightLevelRenderCondition val : VALUES) {
            if (!val.configString.equalsIgnoreCase(name)) continue;
            return val;
        }
        return ALWAYS;
    }

    static {
        VALUES = ImmutableList.copyOf((Object[])LightLevelRenderCondition.values());
    }

    private static interface Condition {
        public boolean shouldRender(int var1, int var2, int var3);
    }
}

