/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.charsets;

import io.ktor.utils.io.bits.Memory;
import io.ktor.utils.io.charsets.MalformedInputException;
import io.ktor.utils.io.core.Buffer;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.internal.ChunkBuffer;
import io.ktor.utils.io.core.internal.UTF8Kt;
import io.ktor.utils.io.core.internal.UnsafeKt;
import io.ktor.utils.io.internal.jvm.ErrorsKt;
import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a1\u0010\t\u001a\u00020\u0007*\u00060\u0000j\u0002`\u00012\u0006\u0010\u0003\u001a\u00020\u00022\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\n\u001a=\u0010\u000f\u001a\u00020\u0007*\u00060\u0000j\u0002`\u00012\u0006\u0010\u0003\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a%\u0010\u0013\u001a\u00020\u0012*\u00060\u0000j\u0002`\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a'\u0010\u0015\u001a\u00020\u0012*\u00060\u0000j\u0002`\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014\u001a'\u0010\u0016\u001a\u00020\u0012*\u00060\u0000j\u0002`\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0014\u001a\u001f\u0010\u0019\u001a\u00020\r*\u00060\u0017j\u0002`\u00182\u0006\u0010\u0006\u001a\u00020\u000bH\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a7\u0010\u001e\u001a\u00020\u0007*\u00060\u0017j\u0002`\u00182\u0006\u0010\u0003\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u000bH\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001a1\u0010!\u001a\u00020 *\u00060\u0017j\u0002`\u00182\u0006\u0010\u0003\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u00072\b\b\u0002\u0010\u001d\u001a\u00020\u0007\u00a2\u0006\u0004\b!\u0010\"\u001a/\u0010#\u001a\u00020 *\u00060\u0017j\u0002`\u00182\u0006\u0010\u0003\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b#\u0010\"\u001a%\u0010'\u001a\u00020&*\u00060\u0017j\u0002`\u00182\u0006\u0010\u0003\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020%\u00a2\u0006\u0004\b'\u0010(\u001a\u0013\u0010*\u001a\u00020&*\u00020)H\u0002\u00a2\u0006\u0004\b*\u0010+\"\u0014\u0010,\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b,\u0010-\"\u0014\u0010/\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100\"\u001c\u00103\u001a\n 2*\u0004\u0018\u000101018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104\"\u001d\u00109\u001a\u000605j\u0002`6*\u00060\u0000j\u0002`\u00018F\u00a2\u0006\u0006\u001a\u0004\b7\u00108\"\u001d\u00109\u001a\u000605j\u0002`6*\u00060\u0017j\u0002`\u00188F\u00a2\u0006\u0006\u001a\u0004\b7\u0010:\"\u0019\u0010=\u001a\u00020\u0012*\u000605j\u0002`68F\u00a2\u0006\u0006\u001a\u0004\b;\u0010<*\n\u0010>\"\u0002052\u000205*\n\u0010?\"\u00020\u00002\u00020\u0000*\n\u0010@\"\u00020\u00172\u00020\u0017*\n\u0010B\"\u00020A2\u00020A\u00a8\u0006C"}, d2={"Ljava/nio/charset/CharsetDecoder;", "Lio/ktor/utils/io/charsets/CharsetDecoder;", "Lio/ktor/utils/io/core/Input;", "input", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "dst", "", "max", "decode", "(Ljava/nio/charset/CharsetDecoder;Lio/ktor/utils/io/core/Input;Ljava/lang/Appendable;I)I", "Lio/ktor/utils/io/core/Buffer;", "out", "", "lastBuffer", "decodeBuffer", "(Ljava/nio/charset/CharsetDecoder;Lio/ktor/utils/io/core/Buffer;Ljava/lang/Appendable;ZI)I", "inputLength", "", "decodeExactBytes", "(Ljava/nio/charset/CharsetDecoder;Lio/ktor/utils/io/core/Input;I)Ljava/lang/String;", "decodeImplByteBuffer", "decodeImplSlow", "Ljava/nio/charset/CharsetEncoder;", "Lio/ktor/utils/io/charsets/CharsetEncoder;", "encodeComplete", "(Ljava/nio/charset/CharsetEncoder;Lio/ktor/utils/io/core/Buffer;)Z", "", "fromIndex", "toIndex", "encodeImpl", "(Ljava/nio/charset/CharsetEncoder;Ljava/lang/CharSequence;IILio/ktor/utils/io/core/Buffer;)I", "", "encodeToByteArray", "(Ljava/nio/charset/CharsetEncoder;Ljava/lang/CharSequence;II)[B", "encodeToByteArraySlow", "Lio/ktor/utils/io/core/ByteReadPacket;", "Lio/ktor/utils/io/core/Output;", "", "encodeUTF8", "(Ljava/nio/charset/CharsetEncoder;Lio/ktor/utils/io/core/ByteReadPacket;Lio/ktor/utils/io/core/Output;)V", "Ljava/nio/charset/CoderResult;", "throwExceptionWrapped", "(Ljava/nio/charset/CoderResult;)V", "DECODE_CHAR_BUFFER_SIZE", "I", "Ljava/nio/ByteBuffer;", "EmptyByteBuffer", "Ljava/nio/ByteBuffer;", "Ljava/nio/CharBuffer;", "kotlin.jvm.PlatformType", "EmptyCharBuffer", "Ljava/nio/CharBuffer;", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "getCharset", "(Ljava/nio/charset/CharsetDecoder;)Ljava/nio/charset/Charset;", "charset", "(Ljava/nio/charset/CharsetEncoder;)Ljava/nio/charset/Charset;", "getName", "(Ljava/nio/charset/Charset;)Ljava/lang/String;", "name", "Charset", "CharsetDecoder", "CharsetEncoder", "Lkotlin/text/Charsets;", "Charsets", "ktor-io"})
public final class CharsetJVMKt {
    private static final int DECODE_CHAR_BUFFER_SIZE = 8192;
    private static final CharBuffer EmptyCharBuffer = CharBuffer.allocate(0);
    @NotNull
    private static final ByteBuffer EmptyByteBuffer;

    @NotNull
    public static final String getName(@NotNull Charset $this$name) {
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"<this>");
        String string = $this$name.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name()");
        return string;
    }

    @NotNull
    public static final Charset getCharset(@NotNull CharsetEncoder $this$charset) {
        Intrinsics.checkNotNullParameter((Object)$this$charset, (String)"<this>");
        Charset charset = $this$charset.charset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"charset()");
        return charset;
    }

    @NotNull
    public static final byte[] encodeToByteArray(@NotNull CharsetEncoder $this$encodeToByteArray, @NotNull CharSequence input2, int fromIndex, int toIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeToByteArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
        if (input2 instanceof String) {
            if (fromIndex == 0 && toIndex == input2.length()) {
                byte[] byArray = ((String)input2).getBytes($this$encodeToByteArray.charset());
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"input as java.lang.String).getBytes(charset())");
                return byArray;
            }
            String string = ((String)input2).substring(fromIndex, toIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            byte[] byArray = string.getBytes($this$encodeToByteArray.charset());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"input.substring(fromInde\u2026ring).getBytes(charset())");
            return byArray;
        }
        return CharsetJVMKt.encodeToByteArraySlow($this$encodeToByteArray, input2, fromIndex, toIndex);
    }

    public static /* synthetic */ byte[] encodeToByteArray$default(CharsetEncoder charsetEncoder, CharSequence charSequence, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        return CharsetJVMKt.encodeToByteArray(charsetEncoder, charSequence, n, n2);
    }

    private static final byte[] encodeToByteArraySlow(CharsetEncoder $this$encodeToByteArraySlow, CharSequence input2, int fromIndex, int toIndex) {
        byte[] existingArray;
        Object object;
        byte[] it;
        byte[] byArray;
        ByteBuffer result2 = $this$encodeToByteArraySlow.encode(CharBuffer.wrap(input2, fromIndex, toIndex));
        if (result2.hasArray() && result2.arrayOffset() == 0) {
            it = byArray = result2.array();
            boolean bl = false;
            object = it.length == result2.remaining() ? byArray : null;
        } else {
            object = null;
        }
        byte[] byArray2 = existingArray = object;
        if (existingArray == null) {
            it = byArray = new byte[result2.remaining()];
            boolean bl = false;
            result2.get(it);
            byArray2 = byArray;
        }
        return byArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static final int encodeImpl(@NotNull CharsetEncoder $this$encodeImpl, @NotNull CharSequence input2, int fromIndex, int toIndex, @NotNull Buffer dst) {
        void endExclusive$iv;
        void start$iv;
        ByteBuffer nioBuffer$iv;
        void $this$writeDirect$iv;
        Intrinsics.checkNotNullParameter((Object)$this$encodeImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        CharBuffer cb = CharBuffer.wrap(input2, fromIndex, toIndex);
        int before = cb.remaining();
        Buffer buffer = dst;
        boolean size$iv = false;
        boolean $i$f$writeDirect = false;
        void $this$write$iv$iv = $this$writeDirect$iv;
        boolean $i$f$write = false;
        int n = $this$write$iv$iv.getLimit();
        int n2 = $this$write$iv$iv.getWritePosition();
        ByteBuffer memory$iv = $this$write$iv$iv.getMemory-SK3TCg8();
        boolean bl = false;
        ByteBuffer bb = nioBuffer$iv = Memory.slice-87lwejk(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
        boolean bl2 = false;
        CoderResult result2 = $this$encodeImpl.encode(cb, bb, false);
        if (result2.isMalformed() || result2.isUnmappable()) {
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result");
            CharsetJVMKt.throwExceptionWrapped(result2);
        }
        if (!(nioBuffer$iv.limit() == endExclusive$iv - start$iv)) {
            boolean bl3 = false;
            String string = "Buffer's limit change is not allowed";
            throw new IllegalStateException(string.toString());
        }
        int rc$iv$iv = nioBuffer$iv.position();
        $this$write$iv$iv.commitWritten(rc$iv$iv);
        return before - cb.remaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void encodeUTF8(@NotNull CharsetEncoder $this$encodeUTF8, @NotNull ByteReadPacket input2, @NotNull Output dst) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeUTF8, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (CharsetJVMKt.getCharset($this$encodeUTF8) == Charsets.UTF_8) {
            dst.writePacket(input2);
            return;
        }
        ChunkBuffer tmp = ChunkBuffer.Companion.getPool().borrow();
        int readSize = 0;
        readSize = 1;
        try {
            void $this$writeDirect$iv;
            ChunkBuffer chunkBuffer = tmp;
            int size$iv = 0;
            boolean $i$f$writeDirect = false;
            Buffer this_$iv$iv = (Buffer)$this$writeDirect$iv;
            boolean $i$f$getWriteRemaining = false;
            int rem$iv = this_$iv$iv.getLimit() - this_$iv$iv.getWritePosition();
            if (!(size$iv <= rem$iv)) {
                boolean $i$a$-require-BufferUtilsJvmKt$writeDirect$1$iv22 = false;
                String $i$a$-require-BufferUtilsJvmKt$writeDirect$1$iv22 = "size " + size$iv + " is greater than buffer's remaining capacity " + rem$iv;
                throw new IllegalArgumentException($i$a$-require-BufferUtilsJvmKt$writeDirect$1$iv22.toString());
            }
            ByteBuffer byteBuffer = $this$writeDirect$iv.getMemory-SK3TCg8().duplicate();
            Intrinsics.checkNotNull((Object)byteBuffer);
            ByteBuffer buffer$iv = byteBuffer;
            int writePosition$iv = $this$writeDirect$iv.getWritePosition();
            int limit$iv = $this$writeDirect$iv.getLimit();
            buffer$iv.limit(limit$iv);
            buffer$iv.position(writePosition$iv);
            ByteBuffer tmpBb = buffer$iv;
            boolean bl = false;
            CharBuffer cb = tmpBb.asCharBuffer();
            while (input2.getRemaining() > 0L) {
                int i$iv;
                int n;
                int n2;
                ChunkBuffer chunk;
                block41: {
                    void start$iv2;
                    void endExclusive$iv;
                    cb.clear();
                    chunk = input2.prepareReadHead$ktor_io(readSize);
                    if (chunk == null) {
                        break;
                    }
                    Buffer $this$decodeUTF8$iv = chunk;
                    boolean $i$f$decodeUTF8 = false;
                    int byteCount$iv = 0;
                    int value$iv = 0;
                    int lastByteCount$iv = 0;
                    Buffer $this$read$iv$iv = $this$decodeUTF8$iv;
                    boolean $i$f$read = false;
                    int n3 = $this$read$iv$iv.getWritePosition();
                    int n4 = $this$read$iv$iv.getReadPosition();
                    ByteBuffer memory$iv = $this$read$iv$iv.getMemory-SK3TCg8();
                    boolean bl2 = false;
                    for (void index$iv = start$iv2; index$iv < endExclusive$iv; ++index$iv) {
                        block46: {
                            block47: {
                                boolean bl3;
                                boolean bl4;
                                boolean bl5;
                                char ch;
                                block45: {
                                    boolean bl6;
                                    ByteBuffer $this$get_u2deY85DW0$iv$iv = memory$iv;
                                    boolean bl7 = false;
                                    n2 = 0;
                                    int v$iv = $this$get_u2deY85DW0$iv$iv.get((int)index$iv) & 0xFF;
                                    if ((v$iv & 0x80) == 0) {
                                        boolean bl8;
                                        if (byteCount$iv != 0) {
                                            UTF8Kt.malformedByteCount(byteCount$iv);
                                            throw new KotlinNothingValueException();
                                        }
                                        ch = (char)v$iv;
                                        bl5 = false;
                                        if (cb.hasRemaining()) {
                                            cb.put(ch);
                                            bl8 = true;
                                        } else {
                                            bl8 = false;
                                        }
                                        if (bl8) continue;
                                        $this$decodeUTF8$iv.discardExact((int)(index$iv - start$iv2));
                                        n = -1;
                                        break block41;
                                    }
                                    if (byteCount$iv == 0) {
                                        int mask$iv = 128;
                                        value$iv = v$iv;
                                        for (i$iv = 1; i$iv < 7 && (value$iv & mask$iv) != 0; ++i$iv) {
                                            value$iv &= ~mask$iv;
                                            mask$iv >>= 1;
                                            ++byteCount$iv;
                                        }
                                        lastByteCount$iv = byteCount$iv;
                                        byteCount$iv += -1;
                                        if (lastByteCount$iv <= endExclusive$iv - index$iv) continue;
                                        $this$decodeUTF8$iv.discardExact((int)(index$iv - start$iv2));
                                        n = lastByteCount$iv;
                                        break block41;
                                    }
                                    value$iv = value$iv << 6 | v$iv & 0x7F;
                                    if ((byteCount$iv += -1) != 0) continue;
                                    if (!UTF8Kt.isBmpCodePoint(value$iv)) break block45;
                                    ch = (char)value$iv;
                                    bl5 = false;
                                    if (cb.hasRemaining()) {
                                        cb.put(ch);
                                        bl6 = true;
                                    } else {
                                        bl6 = false;
                                    }
                                    if (!bl6) {
                                        $this$decodeUTF8$iv.discardExact((int)(index$iv - start$iv2 - lastByteCount$iv + true));
                                        n = -1;
                                        break block41;
                                    }
                                    break block46;
                                }
                                if (!UTF8Kt.isValidCodePoint(value$iv)) {
                                    UTF8Kt.malformedCodePoint(value$iv);
                                    throw new KotlinNothingValueException();
                                }
                                ch = (char)UTF8Kt.highSurrogate(value$iv);
                                bl5 = false;
                                if (cb.hasRemaining()) {
                                    cb.put(ch);
                                    bl4 = true;
                                } else {
                                    bl4 = false;
                                }
                                if (!bl4) break block47;
                                ch = (char)UTF8Kt.lowSurrogate(value$iv);
                                bl5 = false;
                                if (cb.hasRemaining()) {
                                    cb.put(ch);
                                    bl3 = true;
                                } else {
                                    bl3 = false;
                                }
                                if (bl3) break block46;
                            }
                            $this$decodeUTF8$iv.discardExact((int)(index$iv - start$iv2 - lastByteCount$iv + true));
                            n = -1;
                            break block41;
                        }
                        value$iv = 0;
                    }
                    void rc$iv$iv = endExclusive$iv - start$iv2;
                    $this$read$iv$iv.discardExact((int)rc$iv$iv);
                    n = 0;
                }
                int rc2 = n;
                input2.setHeadPosition(chunk.getReadPosition());
                cb.flip();
                int writeSize = 0;
                writeSize = 1;
                if (cb.hasRemaining()) {
                    Output $this$writeWhileSize_u24default$iv = dst;
                    int initialSize$iv = 1;
                    boolean $i$f$writeWhileSize = false;
                    ChunkBuffer tail$iv = UnsafeKt.prepareWriteHead($this$writeWhileSize_u24default$iv, initialSize$iv, null);
                    try {
                        int size$iv2 = 0;
                        while (true) {
                            void endExclusive$iv;
                            void start$iv;
                            ByteBuffer nioBuffer$iv;
                            void $this$writeDirect$iv2;
                            Buffer view = tail$iv;
                            boolean bl9 = false;
                            Buffer start$iv2 = view;
                            int size$iv3 = writeSize;
                            boolean $i$f$writeDirect2 = false;
                            void $this$write$iv$iv2 = $this$writeDirect$iv2;
                            boolean $i$f$write2 = false;
                            i$iv = $this$write$iv$iv2.getLimit();
                            n2 = $this$write$iv$iv2.getWritePosition();
                            ByteBuffer memory$iv = $this$write$iv$iv2.getMemory-SK3TCg8();
                            boolean bl10 = false;
                            ByteBuffer to = nioBuffer$iv = Memory.slice-87lwejk(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
                            boolean bl11 = false;
                            CoderResult cr = $this$encodeUTF8.encode(cb, to, false);
                            if (cr.isUnmappable() || cr.isMalformed()) {
                                Intrinsics.checkNotNullExpressionValue((Object)cr, (String)"cr");
                                CharsetJVMKt.throwExceptionWrapped(cr);
                            }
                            writeSize = cr.isOverflow() && to.hasRemaining() ? ++writeSize : 1;
                            if (!(nioBuffer$iv.limit() == endExclusive$iv - start$iv)) {
                                boolean bl12 = false;
                                String string = "Buffer's limit change is not allowed";
                                throw new IllegalStateException(string.toString());
                            }
                            int rc$iv$iv = nioBuffer$iv.position();
                            $this$write$iv$iv2.commitWritten(rc$iv$iv);
                            int n5 = size$iv2 = cb.hasRemaining() ? writeSize : 0;
                            if (size$iv2 > 0) {
                                tail$iv = UnsafeKt.prepareWriteHead($this$writeWhileSize_u24default$iv, size$iv2, tail$iv);
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        $this$writeWhileSize_u24default$iv.afterHeadWrite();
                    }
                }
                if (rc2 <= 0) continue;
                readSize = rc2;
                break;
            }
            cb.clear();
            cb.flip();
            int completeSize = 0;
            completeSize = 1;
            Output $this$writeWhileSize_u24default$iv = dst;
            int initialSize$iv = 1;
            boolean $i$f$writeWhileSize = false;
            ChunkBuffer tail$iv = UnsafeKt.prepareWriteHead($this$writeWhileSize_u24default$iv, initialSize$iv, null);
            try {
                int size$iv4 = 0;
                while (true) {
                    void endExclusive$iv;
                    void start$iv;
                    ByteBuffer nioBuffer$iv;
                    void $this$writeDirect$iv3;
                    Buffer chunk = tail$iv;
                    boolean bl13 = false;
                    Buffer view = chunk;
                    int size$iv5 = completeSize;
                    boolean $i$f$writeDirect3 = false;
                    void $this$write$iv$iv = $this$writeDirect$iv3;
                    boolean $i$f$write = false;
                    int $this$write$iv$iv2 = $this$write$iv$iv.getLimit();
                    int $i$f$write2 = $this$write$iv$iv.getWritePosition();
                    ByteBuffer memory$iv = $this$write$iv$iv.getMemory-SK3TCg8();
                    boolean bl14 = false;
                    ByteBuffer to = nioBuffer$iv = Memory.slice-87lwejk(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
                    boolean bl15 = false;
                    CoderResult cr = $this$encodeUTF8.encode(cb, to, true);
                    if (cr.isMalformed() || cr.isUnmappable()) {
                        Intrinsics.checkNotNullExpressionValue((Object)cr, (String)"cr");
                        CharsetJVMKt.throwExceptionWrapped(cr);
                    }
                    completeSize = cr.isOverflow() ? ++completeSize : 0;
                    if (!(nioBuffer$iv.limit() == endExclusive$iv - start$iv)) {
                        boolean bl16 = false;
                        String string = "Buffer's limit change is not allowed";
                        throw new IllegalStateException(string.toString());
                    }
                    int rc$iv$iv = nioBuffer$iv.position();
                    $this$write$iv$iv.commitWritten(rc$iv$iv);
                    size$iv4 = completeSize;
                    if (size$iv4 > 0) {
                        tail$iv = UnsafeKt.prepareWriteHead($this$writeWhileSize_u24default$iv, size$iv4, tail$iv);
                        continue;
                    }
                    break;
                }
            }
            finally {
                $this$writeWhileSize_u24default$iv.afterHeadWrite();
            }
            int delta$iv = buffer$iv.position() - writePosition$iv;
            if (delta$iv < 0 || delta$iv > rem$iv) {
                ErrorsKt.wrongBufferPositionChangeError(delta$iv, size$iv);
                throw new KotlinNothingValueException();
            }
            $this$writeDirect$iv.commitWritten(delta$iv);
        }
        finally {
            tmp.release(ChunkBuffer.Companion.getPool());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean encodeComplete(@NotNull CharsetEncoder $this$encodeComplete, @NotNull Buffer dst) {
        void endExclusive$iv;
        void start$iv;
        ByteBuffer nioBuffer$iv;
        void $this$writeDirect$iv;
        Intrinsics.checkNotNullParameter((Object)$this$encodeComplete, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        boolean completed = false;
        Buffer buffer = dst;
        boolean size$iv = false;
        boolean $i$f$writeDirect = false;
        void $this$write$iv$iv = $this$writeDirect$iv;
        boolean $i$f$write = false;
        int n = $this$write$iv$iv.getLimit();
        int n2 = $this$write$iv$iv.getWritePosition();
        ByteBuffer memory$iv = $this$write$iv$iv.getMemory-SK3TCg8();
        boolean bl = false;
        ByteBuffer bb = nioBuffer$iv = Memory.slice-87lwejk(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
        boolean bl2 = false;
        CoderResult result2 = $this$encodeComplete.encode(EmptyCharBuffer, bb, true);
        if (result2.isMalformed() || result2.isUnmappable()) {
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result");
            CharsetJVMKt.throwExceptionWrapped(result2);
        }
        if (result2.isUnderflow()) {
            completed = true;
        }
        if (!(nioBuffer$iv.limit() == endExclusive$iv - start$iv)) {
            boolean bl3 = false;
            String string = "Buffer's limit change is not allowed";
            throw new IllegalStateException(string.toString());
        }
        int rc$iv$iv = nioBuffer$iv.position();
        $this$write$iv$iv.commitWritten(rc$iv$iv);
        return completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final int decodeBuffer(@NotNull CharsetDecoder $this$decodeBuffer, @NotNull Buffer input2, @NotNull Appendable out2, boolean lastBuffer, int max) {
        int charactersCopied;
        void endExclusive$iv;
        void start$iv;
        ByteBuffer nioBuffer$iv;
        Intrinsics.checkNotNullParameter((Object)$this$decodeBuffer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
        Intrinsics.checkNotNullParameter((Object)out2, (String)"out");
        Buffer $this$readDirect$iv = input2;
        boolean $i$f$readDirect = false;
        Buffer $this$read$iv$iv = $this$readDirect$iv;
        boolean $i$f$read = false;
        int n = $this$read$iv$iv.getWritePosition();
        int n2 = $this$read$iv$iv.getReadPosition();
        ByteBuffer memory$iv = $this$read$iv$iv.getMemory-SK3TCg8();
        boolean bl = false;
        ByteBuffer bb = nioBuffer$iv = Memory.slice-87lwejk(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
        boolean bl2 = false;
        ChunkBuffer tmpBuffer = ChunkBuffer.Companion.getPool().borrow();
        CharBuffer cb = tmpBuffer.getMemory-SK3TCg8().asCharBuffer();
        try {
            int partSize;
            for (charactersCopied = 0; bb.hasRemaining() && charactersCopied < max; charactersCopied += partSize) {
                partSize = Math.min(cb.capacity(), max - charactersCopied);
                cb.clear();
                cb.limit(partSize);
                CoderResult result2 = $this$decodeBuffer.decode(bb, cb, lastBuffer);
                if (!result2.isMalformed() && !result2.isUnmappable()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result");
                CharsetJVMKt.throwExceptionWrapped(result2);
            }
        }
        finally {
            tmpBuffer.release(ChunkBuffer.Companion.getPool());
        }
        if (!(nioBuffer$iv.limit() == endExclusive$iv - start$iv)) {
            boolean bl3 = false;
            String string = "Buffer's limit change is not allowed";
            throw new IllegalStateException(string.toString());
        }
        int rc$iv$iv = nioBuffer$iv.position();
        $this$read$iv$iv.discardExact(rc$iv$iv);
        return charactersCopied;
    }

    public static /* synthetic */ int decodeBuffer$default(CharsetDecoder charsetDecoder, Buffer buffer, Appendable appendable, boolean bl, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = Integer.MAX_VALUE;
        }
        return CharsetJVMKt.decodeBuffer(charsetDecoder, buffer, appendable, bl, n);
    }

    @NotNull
    public static final Charset getCharset(@NotNull CharsetDecoder $this$charset) {
        Intrinsics.checkNotNullParameter((Object)$this$charset, (String)"<this>");
        Charset charset = $this$charset.charset();
        Intrinsics.checkNotNull((Object)charset);
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static final int decode(@NotNull CharsetDecoder $this$decode, @NotNull Input input, @NotNull Appendable dst, int max) {
        block20: {
            Intrinsics.checkNotNullParameter((Object)$this$decode, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            copied = 0;
            cb = CharBuffer.allocate(8192);
            readSize = 0;
            readSize = 1;
            $this$takeWhileSize_u24default$iv = input;
            initialSize$iv = 1;
            $i$f$takeWhileSize = false;
            release$iv = true;
            v0 = UnsafeKt.prepareReadFirstHead($this$takeWhileSize_u24default$iv, initialSize$iv);
            if (v0 == null) break block20;
            current$iv = v0;
            size$iv = initialSize$iv;
            try {
                do {
                    block23: {
                        block22: {
                            this_$iv$iv = current$iv;
                            $i$f$getReadRemaining = false;
                            before$iv = this_$iv$iv.getWritePosition() - this_$iv$iv.getReadPosition();
                            after$iv = 0;
                            if (before$iv >= size$iv) {
                                try {
                                    buffer = current$iv;
                                    $i$a$-takeWhileSize$default-CharsetJVMKt$decode$1 = false;
                                    rem = max - copied;
                                    if (rem == 0) {
                                        v1 = 0;
                                    } else {
                                        $this$readDirect$iv = buffer;
                                        $i$f$readDirect = false;
                                        $this$read$iv$iv = $this$readDirect$iv;
                                        $i$f$read = false;
                                        var23_30 = $this$read$iv$iv.getWritePosition();
                                        var24_31 = $this$read$iv$iv.getReadPosition();
                                        memory$iv = $this$read$iv$iv.getMemory-SK3TCg8();
                                        $i$a$-read-BufferUtilsJvmKt$readDirect$2$iv = false;
                                        bb = nioBuffer$iv = Memory.slice-87lwejk(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
                                        $i$a$-readDirect-CharsetJVMKt$decode$1$1 = false;
                                        cb.clear();
                                        if (rem < 8192) {
                                            cb.limit(rem);
                                        }
                                        rc = $this$decode.decode(bb, cb, false);
                                        cb.flip();
                                        copied += cb.remaining();
                                        dst.append(cb);
                                        if (rc.isMalformed() || rc.isUnmappable()) {
                                            Intrinsics.checkNotNullExpressionValue((Object)rc, (String)"rc");
                                            CharsetJVMKt.throwExceptionWrapped(rc);
                                        }
                                        readSize = rc.isUnderflow() && bb.hasRemaining() ? ++readSize : 1;
                                        if (!(nioBuffer$iv.limit() == endExclusive$iv - start$iv)) {
                                            $i$a$-check-BufferUtilsJvmKt$readDirect$2$1$iv = false;
                                            var31_45 = "Buffer's limit change is not allowed";
                                            throw new IllegalStateException(var31_45.toString());
                                        }
                                        rc$iv$iv = nioBuffer$iv.position();
                                        $this$read$iv$iv.discardExact(rc$iv$iv);
                                        v1 = readSize;
                                    }
                                    size$iv = v1;
                                }
                                finally {
                                    this_$iv$iv = current$iv;
                                    $i$f$getReadRemaining = false;
                                    after$iv = this_$iv$iv.getWritePosition() - this_$iv$iv.getReadPosition();
                                }
                            } else {
                                after$iv = before$iv;
                            }
                            release$iv = false;
                            if (after$iv != 0) break block22;
                            v2 = UnsafeKt.prepareReadNextHead($this$takeWhileSize_u24default$iv, current$iv);
                            break block23;
                        }
                        if (after$iv < size$iv) ** GOTO lbl-1000
                        this_$iv$iv = current$iv;
                        $i$f$getEndGap = false;
                        if (this_$iv$iv.getCapacity() - this_$iv$iv.getLimit() < 8) lbl-1000:
                        // 2 sources

                        {
                            UnsafeKt.completeReadHead($this$takeWhileSize_u24default$iv, current$iv);
                            v2 = UnsafeKt.prepareReadFirstHead($this$takeWhileSize_u24default$iv, size$iv);
                        } else {
                            v2 = current$iv;
                        }
                    }
                    if (v2 == null) {
                        break;
                    }
                    current$iv = next$iv = v2;
                    release$iv = true;
                } while (size$iv > 0);
            }
            finally {
                if (release$iv) {
                    UnsafeKt.completeReadHead($this$takeWhileSize_u24default$iv, current$iv);
                }
            }
        }
        do {
            cb.clear();
            rem = max - copied;
            if (rem == 0) break;
            if (rem < 8192) {
                cb.limit(rem);
            }
            cr = $this$decode.decode(CharsetJVMKt.EmptyByteBuffer, cb, true);
            cb.flip();
            copied += cb.remaining();
            dst.append(cb);
            if (!cr.isUnmappable() && !cr.isMalformed()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)cr, (String)"cr");
            CharsetJVMKt.throwExceptionWrapped(cr);
        } while (cr.isOverflow());
        return copied;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String decodeExactBytes(@NotNull CharsetDecoder $this$decodeExactBytes, @NotNull Input input2, int inputLength) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeExactBytes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
        if (inputLength == 0) {
            return "";
        }
        Input this_$iv = input2;
        boolean $i$f$getHeadRemaining = false;
        if (this_$iv.getHeadEndExclusive() - this_$iv.getHeadPosition() >= inputLength) {
            if (input2.getHeadMemory-SK3TCg8().hasArray()) {
                void charset$iv;
                void offset$iv;
                void bytes$iv;
                ByteBuffer bb = input2.getHeadMemory-SK3TCg8();
                byte[] byArray = bb.array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bb.array()");
                byte[] byArray2 = byArray;
                int n = bb.arrayOffset() + bb.position() + input2.getHead().getReadPosition();
                Charset charset = $this$decodeExactBytes.charset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"charset()");
                Charset charset2 = charset;
                boolean $i$f$String = false;
                String text = new String((byte[])bytes$iv, (int)offset$iv, inputLength, (Charset)charset$iv);
                input2.discardExact(inputLength);
                return text;
            }
            return CharsetJVMKt.decodeImplByteBuffer($this$decodeExactBytes, input2, inputLength);
        }
        return CharsetJVMKt.decodeImplSlow($this$decodeExactBytes, input2, inputLength);
    }

    private static final String decodeImplByteBuffer(CharsetDecoder $this$decodeImplByteBuffer, Input input2, int inputLength) {
        CharBuffer cb = CharBuffer.allocate(inputLength);
        ByteBuffer bb = Memory.slice-87lwejk(input2.getHeadMemory-SK3TCg8(), input2.getHead().getReadPosition(), inputLength);
        CoderResult rc2 = $this$decodeImplByteBuffer.decode(bb, cb, true);
        if (rc2.isMalformed() || rc2.isUnmappable()) {
            Intrinsics.checkNotNullExpressionValue((Object)rc2, (String)"rc");
            CharsetJVMKt.throwExceptionWrapped(rc2);
        }
        cb.flip();
        input2.discardExact(bb.position());
        String string = cb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cb.toString()");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static final String decodeImplSlow(CharsetDecoder $this$decodeImplSlow, Input input, int inputLength) {
        block21: {
            cb = CharBuffer.allocate(inputLength);
            remainingInputBytes = 0;
            remainingInputBytes = inputLength;
            lastChunk = false;
            readSize = 0;
            readSize = 1;
            $this$takeWhileSize_u24default$iv = input;
            initialSize$iv = 1;
            $i$f$takeWhileSize = false;
            release$iv = true;
            v0 = UnsafeKt.prepareReadFirstHead($this$takeWhileSize_u24default$iv, initialSize$iv);
            if (v0 == null) break block21;
            current$iv = v0;
            size$iv = initialSize$iv;
            try {
                do {
                    block23: {
                        block22: {
                            this_$iv$iv = current$iv;
                            $i$f$getReadRemaining = false;
                            before$iv = this_$iv$iv.getWritePosition() - this_$iv$iv.getReadPosition();
                            after$iv = 0;
                            if (before$iv >= size$iv) {
                                try {
                                    buffer = current$iv;
                                    $i$a$-takeWhileSize$default-CharsetJVMKt$decodeImplSlow$1 = false;
                                    if (!cb.hasRemaining() || remainingInputBytes == 0) {
                                        v1 = 0;
                                    } else {
                                        $this$readDirect$iv = buffer;
                                        $i$f$readDirect = false;
                                        $this$read$iv$iv = $this$readDirect$iv;
                                        $i$f$read = false;
                                        var22_27 = $this$read$iv$iv.getWritePosition();
                                        var23_28 = $this$read$iv$iv.getReadPosition();
                                        memory$iv = $this$read$iv$iv.getMemory-SK3TCg8();
                                        $i$a$-read-BufferUtilsJvmKt$readDirect$2$iv = false;
                                        bb = nioBuffer$iv = Memory.slice-87lwejk(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
                                        $i$a$-readDirect-CharsetJVMKt$decodeImplSlow$1$1 = false;
                                        limitBefore = bb.limit();
                                        v2 = lastChunk = limitBefore - (positionBefore = bb.position()) >= remainingInputBytes;
                                        if (lastChunk) {
                                            bb.limit(positionBefore + remainingInputBytes);
                                        }
                                        if ((rc = $this$decodeImplSlow.decode(bb, cb, lastChunk)).isMalformed() || rc.isUnmappable()) {
                                            Intrinsics.checkNotNullExpressionValue((Object)rc, (String)"rc");
                                            CharsetJVMKt.throwExceptionWrapped(rc);
                                        }
                                        readSize = rc.isUnderflow() && bb.hasRemaining() ? ++readSize : 1;
                                        bb.limit(limitBefore);
                                        remainingInputBytes -= bb.position() - positionBefore;
                                        if (!(nioBuffer$iv.limit() == endExclusive$iv - start$iv)) {
                                            $i$a$-check-BufferUtilsJvmKt$readDirect$2$1$iv = false;
                                            var32_44 = "Buffer's limit change is not allowed";
                                            throw new IllegalStateException(var32_44.toString());
                                        }
                                        rc$iv$iv = nioBuffer$iv.position();
                                        $this$read$iv$iv.discardExact(rc$iv$iv);
                                        v1 = readSize;
                                    }
                                    size$iv = v1;
                                }
                                finally {
                                    this_$iv$iv = current$iv;
                                    $i$f$getReadRemaining = false;
                                    after$iv = this_$iv$iv.getWritePosition() - this_$iv$iv.getReadPosition();
                                }
                            } else {
                                after$iv = before$iv;
                            }
                            release$iv = false;
                            if (after$iv != 0) break block22;
                            v3 = UnsafeKt.prepareReadNextHead($this$takeWhileSize_u24default$iv, current$iv);
                            break block23;
                        }
                        if (after$iv < size$iv) ** GOTO lbl-1000
                        this_$iv$iv = current$iv;
                        $i$f$getEndGap = false;
                        if (this_$iv$iv.getCapacity() - this_$iv$iv.getLimit() < 8) lbl-1000:
                        // 2 sources

                        {
                            UnsafeKt.completeReadHead($this$takeWhileSize_u24default$iv, current$iv);
                            v3 = UnsafeKt.prepareReadFirstHead($this$takeWhileSize_u24default$iv, size$iv);
                        } else {
                            v3 = current$iv;
                        }
                    }
                    if (v3 == null) {
                        break;
                    }
                    current$iv = next$iv = v3;
                    release$iv = true;
                } while (size$iv > 0);
            }
            finally {
                if (release$iv) {
                    UnsafeKt.completeReadHead($this$takeWhileSize_u24default$iv, current$iv);
                }
            }
        }
        if (cb.hasRemaining() && !lastChunk && ((rc = $this$decodeImplSlow.decode(CharsetJVMKt.EmptyByteBuffer, cb, true)).isMalformed() || rc.isUnmappable())) {
            Intrinsics.checkNotNullExpressionValue((Object)rc, (String)"rc");
            CharsetJVMKt.throwExceptionWrapped(rc);
        }
        if (remainingInputBytes > 0) {
            throw new EOFException("Not enough bytes available: had only " + (inputLength - remainingInputBytes) + " instead of " + inputLength);
        }
        if (remainingInputBytes < 0) {
            throw new AssertionError((Object)"remainingInputBytes < 0");
        }
        cb.flip();
        v4 = cb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"cb.toString()");
        return v4;
    }

    private static final void throwExceptionWrapped(CoderResult $this$throwExceptionWrapped) {
        try {
            $this$throwExceptionWrapped.throwException();
        }
        catch (java.nio.charset.MalformedInputException original) {
            String string = original.getMessage();
            if (string == null) {
                string = "Failed to decode bytes";
            }
            throw new MalformedInputException(string);
        }
    }

    public static /* synthetic */ void Charset$annotations() {
    }

    static {
        ByteBuffer byteBuffer = ByteBuffer.allocate(0);
        Intrinsics.checkNotNull((Object)byteBuffer);
        EmptyByteBuffer = byteBuffer;
    }
}

