/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.craftify.services.update;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import gg.essential.universal.UChat;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.craftify.services.update.UpdateMessage;
import tech.thatgravyboat.craftify.services.update.UpdateVersion;
import tech.thatgravyboat.craftify.services.update.UpdateVersionSerializer;
import tech.thatgravyboat.craftify.utils.Utils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\u0003R\u001c\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0016\u0010\f\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0019\u00a8\u0006\u001a"}, d2={"Ltech/thatgravyboat/craftify/services/update/Updater;", "", "<init>", "()V", "", "check", "Ltech/thatgravyboat/craftify/services/update/UpdateMessage;", "getLatestMessage", "()Ltech/thatgravyboat/craftify/services/update/UpdateMessage;", "", "hasUpdate", "()Z", "showMessage", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "GSON", "Lcom/google/gson/Gson;", "", "JSON_URL", "Ljava/lang/String;", "Ltech/thatgravyboat/craftify/services/update/UpdateVersion;", "VERSION", "Ltech/thatgravyboat/craftify/services/update/UpdateVersion;", "latestMessage", "Ltech/thatgravyboat/craftify/services/update/UpdateMessage;", "Z", "Craftify"})
@SourceDebugExtension(value={"SMAP\nUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Updater.kt\ntech/thatgravyboat/craftify/services/update/Updater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1855#2,2:54\n*S KotlinDebug\n*F\n+ 1 Updater.kt\ntech/thatgravyboat/craftify/services/update/Updater\n*L\n49#1:54,2\n*E\n"})
public final class Updater {
    @NotNull
    public static final Updater INSTANCE = new Updater();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)UpdateVersion.class), (Object)UpdateVersionSerializer.INSTANCE).create();
    @NotNull
    private static final String JSON_URL = "https://raw.githubusercontent.com/Craftify-Mod/Data/main/messages.json";
    @NotNull
    private static final UpdateVersion VERSION = new UpdateVersion("1.16.0");
    @Nullable
    private static UpdateMessage latestMessage;
    private static boolean showMessage;

    private Updater() {
    }

    public final void check() {
        try {
            UpdateMessage[] fromJson = (UpdateMessage[])GSON.fromJson(Utils.INSTANCE.fetchString(JSON_URL), UpdateMessage[].class);
            Intrinsics.checkNotNullExpressionValue((Object)fromJson, (String)"fromJson");
            for (UpdateMessage message2 : fromJson) {
                if (latestMessage != null) {
                    UpdateVersion updateVersion = message2.getVersion();
                    UpdateMessage updateMessage = latestMessage;
                    Intrinsics.checkNotNull((Object)updateMessage);
                    if (updateVersion.compareTo(updateMessage.getVersion()) <= 0) continue;
                }
                latestMessage = message2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public final UpdateMessage getLatestMessage() {
        return latestMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasUpdate() {
        if (latestMessage == null) return false;
        UpdateMessage updateMessage = latestMessage;
        Intrinsics.checkNotNull((Object)updateMessage);
        if (updateMessage.getVersion().compareTo(VERSION) <= 0) return false;
        return true;
    }

    public final void showMessage() {
        if (!showMessage) {
            return;
        }
        showMessage = false;
        UChat.chat((Object)"");
        UChat.chat((Object)"\u00a77----------[\u00a7aCraftify\u00a77]----------");
        UChat.chat((Object)"\u00a76There is a new update available!");
        UChat.chat((Object)("\u00a76Current version: \u00a7a" + VERSION.getValue()));
        UpdateMessage updateMessage = latestMessage;
        Intrinsics.checkNotNull((Object)updateMessage);
        UChat.chat((Object)("\u00a76Latest version: \u00a7a" + updateMessage.getVersion().getValue()));
        UChat.chat((Object)"\u00a76Message:");
        UpdateMessage updateMessage2 = latestMessage;
        Intrinsics.checkNotNull((Object)updateMessage2);
        Iterable $this$forEach$iv = StringsKt.lines((CharSequence)updateMessage2.getMessage());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            UChat.chat((Object)(" \u00a7a" + it));
        }
        UChat.chat((Object)"\u00a77-----------------------------");
        UChat.chat((Object)"");
    }

    static {
        showMessage = true;
    }
}

