/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.craftify.ssl;

import java.util.function.BiConsumer;
import java.util.function.Function;

public class LambdaExceptionUtils {
    public static <T, U, E extends Exception> BiConsumer<T, U> rethrowBiConsumer(BiConsumer_WithExceptions<T, U, E> biConsumer) {
        return (t, u) -> {
            try {
                biConsumer.accept(t, u);
            }
            catch (Exception exception) {
                LambdaExceptionUtils.throwAsUnchecked(exception);
            }
        };
    }

    public static <T, R, E extends Exception> Function<T, R> rethrowFunction(Function_WithExceptions<T, R, E> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception exception) {
                LambdaExceptionUtils.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    private static <E extends Throwable> void throwAsUnchecked(Exception exception) throws E {
        throw exception;
    }

    public static interface BiConsumer_WithExceptions<T, U, E extends Exception> {
        public void accept(T var1, U var2) throws E;
    }

    @FunctionalInterface
    public static interface Function_WithExceptions<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }
}

