/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.craftify.ui;

import gg.essential.elementa.ElementaVersion;
import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.XConstraint;
import gg.essential.elementa.constraints.YConstraint;
import gg.essential.elementa.dsl.ComponentsKt;
import gg.essential.universal.UChat;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMouse;
import gg.essential.universal.UScreen;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.craftify.Initializer;
import tech.thatgravyboat.craftify.config.Config;
import tech.thatgravyboat.craftify.services.ads.AdManager;
import tech.thatgravyboat.craftify.themes.library.ScreenshotScreen;
import tech.thatgravyboat.craftify.ui.PositionEditorScreen;
import tech.thatgravyboat.craftify.ui.UIPlayer;
import tech.thatgravyboat.craftify.ui.enums.Anchor;
import tech.thatgravyboat.craftify.ui.enums.DisplayMode;
import tech.thatgravyboat.craftify.ui.enums.RenderType;
import tech.thatgravyboat.craftify.utils.EssentialUtils;
import tech.thatgravyboat.craftify.utils.Utils;
import tech.thatgravyboat.jukebox.api.service.Service;
import tech.thatgravyboat.jukebox.api.state.State;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0003J\r\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0006J\u0015\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\t\u00a2\u0006\u0004\b\u001a\u0010\u0003J\r\u0010\u001b\u001a\u00020\t\u00a2\u0006\u0004\b\u001b\u0010\u0003J\u0015\u0010\u001c\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u001c\u0010\u000fJ\r\u0010\u001d\u001a\u00020\t\u00a2\u0006\u0004\b\u001d\u0010\u0003R\u0016\u0010\u0011\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u001eR\u0018\u0010 \u001a\u0004\u0018\u00010\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010\u001eR\u0014\u0010$\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Ltech/thatgravyboat/craftify/ui/Player;", "", "<init>", "()V", "", "canRender", "()Z", "Ltech/thatgravyboat/craftify/ui/enums/Anchor;", "position", "", "changePosition", "(Ltech/thatgravyboat/craftify/ui/enums/Anchor;)V", "Ltech/thatgravyboat/jukebox/api/state/State;", "state", "changeSong", "(Ltech/thatgravyboat/jukebox/api/state/State;)V", "checkAndInitPlayer", "isPlaying", "", "button", "onMouseClicked", "(I)Z", "Lgg/essential/universal/UMatrixStack;", "matrix", "onRender", "(Lgg/essential/universal/UMatrixStack;)V", "stopClient", "toggleHiding", "updatePlayer", "updateTheme", "Z", "Ltech/thatgravyboat/craftify/ui/UIPlayer;", "player", "Ltech/thatgravyboat/craftify/ui/UIPlayer;", "tempHide", "Lgg/essential/elementa/components/Window;", "window", "Lgg/essential/elementa/components/Window;", "Craftify"})
@SourceDebugExtension(value={"SMAP\nPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Player.kt\ntech/thatgravyboat/craftify/ui/Player\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class Player {
    @NotNull
    public static final Player INSTANCE = new Player();
    @NotNull
    private static final Window window = new Window(ElementaVersion.V2, 0, 2, null);
    @Nullable
    private static UIPlayer player;
    private static boolean isPlaying;
    private static boolean tempHide;

    private Player() {
    }

    private final void checkAndInitPlayer() {
        block2: {
            if (player != null) break block2;
            player = (UIPlayer)ComponentsKt.childOf((UIComponent)((UIComponent)new UIPlayer()), (UIComponent)((UIComponent)window));
            this.changePosition(Anchor.values()[Config.INSTANCE.getAnchorPoint()]);
            this.updateTheme();
            Object object = Initializer.INSTANCE.getAPI();
            if (object != null && (object = object.getState()) != null) {
                Object it = object;
                boolean bl = false;
                UIPlayer uIPlayer = player;
                if (uIPlayer != null) {
                    uIPlayer.updateState((State)it);
                }
            }
        }
    }

    public final boolean isPlaying() {
        return isPlaying;
    }

    public final void toggleHiding() {
        tempHide = !tempHide;
    }

    public final void updateTheme() {
        block0: {
            UIPlayer uIPlayer = player;
            if (uIPlayer == null) break block0;
            uIPlayer.updateTheme();
        }
    }

    public final void stopClient() {
        block0: {
            UIPlayer uIPlayer = player;
            if (uIPlayer == null) break block0;
            uIPlayer.clientStop();
        }
    }

    public final void changeSong(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        AdManager.INSTANCE.changeAd();
        if (Config.INSTANCE.getAnnounceNewSong() == 1) {
            String string;
            String string2 = StringsKt.replace$default((String)StringsKt.replace$default((String)Config.INSTANCE.getAnnouncementMessage(), (String)"${song}", (String)state.getSong().getTitle(), (boolean)false, (int)4, null), (String)"${artists}", (String)CollectionsKt.joinToString$default((Iterable)state.getSong().getArtists(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), (boolean)false, (int)4, null);
            String string3 = "${artist}";
            int n = 0;
            List<String> list = state.getSong().getArtists();
            if (n <= CollectionsKt.getLastIndex(list)) {
                string = list.get(n);
            } else {
                int n2 = n;
                String string4 = string3;
                String string5 = string2;
                boolean bl = false;
                String string6 = "";
                string2 = string5;
                string3 = string4;
                string = string6;
            }
            UChat.chat((Object)StringsKt.replace$default((String)string2, (String)string3, (String)string, (boolean)false, (int)4, null));
        }
        if (Config.INSTANCE.getAnnounceNewSong() == 2 && Utils.INSTANCE.isEssentialInstalled()) {
            EssentialUtils.INSTANCE.sendNotification("Craftify", "Now Playing: \n" + state.getSong().getTitle(), Config.INSTANCE.getAnnouncementRendering() != 0 ? state.getSong().getCover() : null, Config.INSTANCE.getAnnouncementRendering() == 1);
        }
    }

    public final void updatePlayer(@NotNull State state) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state.getSong().getType().isAd()) {
            UIPlayer uIPlayer = player;
            if (uIPlayer != null) {
                uIPlayer.updateState(AdManager.INSTANCE.getAdState(state));
            }
            bl = false;
        } else {
            UIPlayer uIPlayer = player;
            if (uIPlayer != null) {
                uIPlayer.updateState(state);
            }
            bl = state.isPlaying();
        }
        isPlaying = bl;
    }

    public final void changePosition(@NotNull Anchor position) {
        block0: {
            UIPlayer uIPlayer;
            Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
            UIPlayer uIPlayer2 = player;
            if (uIPlayer2 == null) break block0;
            UIPlayer $this$changePosition_u24lambda_u242 = uIPlayer = uIPlayer2;
            boolean bl = false;
            $this$changePosition_u24lambda_u242.setX((XConstraint)position.getX((UIComponent)$this$changePosition_u24lambda_u242));
            $this$changePosition_u24lambda_u242.setY((YConstraint)position.getY((UIComponent)$this$changePosition_u24lambda_u242));
        }
    }

    public final void onRender(@NotNull UMatrixStack matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        if (tempHide) {
            return;
        }
        if (this.canRender() && !Intrinsics.areEqual((Object)Config.INSTANCE.getService(), (Object)"disabled")) {
            this.checkAndInitPlayer();
            window.draw(matrix);
        }
    }

    private final boolean canRender() {
        if (UScreen.Companion.getCurrentScreen() instanceof PositionEditorScreen) {
            return false;
        }
        boolean renderType = RenderType.values()[Config.INSTANCE.getRenderType()].canRender(UScreen.Companion.getCurrentScreen());
        Service service = Initializer.INSTANCE.getAPI();
        boolean displayMode = DisplayMode.values()[Config.INSTANCE.getDisplayMode()].canDisplay(service != null ? service.getState() : null);
        return (UScreen.Companion.getCurrentScreen() instanceof ScreenshotScreen || renderType && displayMode) && !Intrinsics.areEqual((Object)Config.INSTANCE.getService(), (Object)"disabled");
    }

    public final boolean onMouseClicked(int button2) {
        if (Intrinsics.areEqual((Object)Config.INSTANCE.getService(), (Object)"disabled")) {
            return false;
        }
        if (tempHide) {
            return false;
        }
        if (this.canRender()) {
            UIPlayer uIPlayer = player;
            boolean bl = uIPlayer != null ? uIPlayer.isHovered() : false;
            if (bl) {
                UIPlayer uIPlayer2 = player;
                if (uIPlayer2 != null) {
                    uIPlayer2.mouseClick(UMouse.Scaled.getX(), UMouse.Scaled.getY(), button2);
                }
                return true;
            }
        }
        return false;
    }
}

