/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.rascal;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.RascalEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.RascalBrain;
import com.faboslav.friendsandfoes.common.entity.pose.RascalEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesCriterias;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.util.MovementUtil;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;
import net.minecraft.class_5138;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7045;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_9276;
import net.minecraft.class_9334;

public final class RascalWaitForPlayerTask
extends class_4097<RascalEntity> {
    private static final int NOD_DURATION = 90;
    public static final float NOD_RANGE = 5.0f;
    private int nodTicks;
    private class_1309 nearestTarget;

    public RascalWaitForPlayerTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22354, (Object)class_4141.field_18458, (Object)class_4140.field_18447, (Object)class_4141.field_18456, FriendsAndFoesMemoryModuleTypes.RASCAL_NOD_COOLDOWN.get(), (Object)class_4141.field_18457), 90);
    }

    protected boolean shouldRun(class_3218 world, RascalEntity rascal) {
        if (rascal.method_16914()) {
            return false;
        }
        class_1309 nearestTarget = rascal.method_18868().method_18904(class_4140.field_22354).orElse(null);
        if (nearestTarget == null) {
            nearestTarget = rascal.method_18868().method_18904(class_4140.field_18447).orElse(null);
        }
        if (nearestTarget == null || rascal.method_5739((class_1297)nearestTarget) > 5.0f || !nearestTarget.method_5805() || nearestTarget instanceof class_1657 && (nearestTarget.method_7325() || ((class_1657)nearestTarget).method_7337())) {
            return false;
        }
        this.nearestTarget = nearestTarget;
        return true;
    }

    protected void run(class_3218 world, RascalEntity rascal, long time) {
        MovementUtil.stopMovement((class_1308)rascal);
        class_4215.method_19554((class_1309)rascal, (class_1309)this.nearestTarget);
        rascal.method_5988().method_35111((class_1297)this.nearestTarget);
        rascal.method_5988().method_6231();
        this.nodTicks = 0;
        rascal.addToCaughtCount();
        rascal.disableAmbientSounds();
    }

    protected boolean shouldKeepRunning(class_3218 world, RascalEntity rascal, long time) {
        return this.nodTicks <= 90;
    }

    protected void keepRunning(class_3218 world, RascalEntity rascal, long time) {
        if (this.nodTicks == 20) {
            rascal.startNodAnimation();
            rascal.method_5988().method_35111((class_1297)this.nearestTarget);
        }
        if (this.nodTicks == 40 && rascal.shouldGiveReward()) {
            rascal.startGiveRewardAnimation();
        }
        if (this.nodTicks == 62 && rascal.shouldGiveReward()) {
            class_243 targetPos = this.nearestTarget.method_19538().method_1031(0.0, 1.0, 0.0);
            class_52 rascalGoodItemsLootTable = world.method_8503().method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)FriendsAndFoes.makeID("rewards/rascal_good_reward")));
            class_8567 lootContextParameterSet = new class_8567.class_8568(world).method_51874(class_181.field_24424, (Object)targetPos).method_51874(class_181.field_1226, (Object)this.nearestTarget).method_51875(class_173.field_16235);
            ObjectArrayList rascalGoodRewards = rascalGoodItemsLootTable.method_51878(lootContextParameterSet);
            for (class_1799 rascalReward : rascalGoodRewards) {
                class_1799 bundleItemStack = class_1802.field_27023.method_7854();
                class_9276 bundleContentsComponent = (class_9276)bundleItemStack.method_57824(class_9334.field_49650);
                if (bundleContentsComponent == null) break;
                class_9276.class_9277 builder = new class_9276.class_9277(bundleContentsComponent);
                builder.method_57432(rascalReward);
                bundleItemStack.method_57379(class_9334.field_49650, (Object)builder.method_57435());
                class_4215.method_19949((class_1309)rascal, (class_1799)bundleItemStack, (class_243)this.nearestTarget.method_19538().method_1031(0.0, 1.0, 0.0));
                FriendsAndFoesCriterias.COMPLETE_HIDE_AND_SEEK_GAME.get().trigger((class_3222)this.nearestTarget, rascal, bundleItemStack);
            }
        }
        ++this.nodTicks;
    }

    protected void finishRunning(class_3218 world, RascalEntity rascal, long time) {
        if (rascal.method_16914()) {
            RascalBrain.setNodCooldown(rascal);
            return;
        }
        rascal.spawnCloudParticles();
        rascal.playDisappearSound();
        if (rascal.shouldGiveReward()) {
            rascal.method_31472();
            return;
        }
        rascal.setPose(RascalEntityPose.IDLE);
        rascal.method_6092(new class_1293(class_1294.field_5905, 200));
        this.tryToTeleport(world, rascal);
        RascalBrain.setNodCooldown(rascal);
        rascal.enableAmbientSounds();
    }

    private void tryToTeleport(class_3218 world, RascalEntity rascal) {
        class_5138 structureAccessor = world.method_27056();
        for (int i = 0; i < 64; ++i) {
            boolean teleportResult;
            double z;
            double y;
            double x = rascal.method_23317() + (rascal.method_59922().method_43058() - 0.5) * 16.0;
            if (!structureAccessor.method_57560(new class_2338((int)x, (int)(y = class_3532.method_15350((double)(rascal.method_23318() + (double)(rascal.method_59922().method_43048(8) - 4)), (double)world.method_31607(), (double)(world.method_31607() + world.method_32819() - 1))), (int)(z = rascal.method_23321() + (rascal.method_59922().method_43058() - 0.5) * 16.0)), class_7045.field_37046).method_16657()) continue;
            if (rascal.method_5765()) {
                rascal.method_5848();
            }
            if (!(teleportResult = rascal.method_6082(x, y, z, false)) || !((double)rascal.method_5739((class_1297)this.nearestTarget) > 10.0)) continue;
            return;
        }
    }
}

