/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.compat;

import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.compat.WrappingTrinketsUtils;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.util.MapCarrier;
import io.wispforest.owo.serialization.RegistriesAttribute;
import io.wispforest.tclayer.OuterGroupMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3545;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import org.slf4j.Logger;

public abstract class WrappedTrinketComponent
implements TrinketComponent {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final class_1309 entity;

    public WrappedTrinketComponent(class_1309 entity) {
        this.entity = entity;
    }

    @Override
    public class_1309 getEntity() {
        return this.entity;
    }

    public AccessoriesCapability capability() {
        return this.entity.accessoriesCapability();
    }

    @Override
    public Map<String, SlotGroup> getGroups() {
        return TrinketsApi.getEntitySlots(this.getEntity().method_37908(), this.getEntity().method_5864());
    }

    @Override
    public Map<String, Map<String, TrinketInventory>> getInventory() {
        class_1309 entity = this.getEntity();
        return new OuterGroupMap(WrappingTrinketsUtils.getGroupedSlots(entity.method_37908().method_8608(), entity.method_5864()), this, this.capability(), additionalMsg -> {
            LOGGER.warn("Unable to get some value leading to an error, here comes the dumping data!");
            LOGGER.warn("Entity: {}", (Object)this.getEntity());
            LOGGER.warn("Entity Slots: {}", (Object)EntitySlotLoader.getEntitySlots((class_1309)this.getEntity()));
            LOGGER.warn("Current Containers: {}", (Object)this.getEntity().accessoriesCapability().getContainers());
            LOGGER.warn("More Info: ({})", additionalMsg);
        });
    }

    @Override
    public void update() {
    }

    @Override
    public void addTemporaryModifiers(Multimap<String, class_1322> modifiers) {
        this.capability().addTransientSlotModifiers(modifiers);
    }

    @Override
    public void addPersistentModifiers(Multimap<String, class_1322> modifiers) {
        this.capability().addPersistentSlotModifiers(modifiers);
    }

    @Override
    public void removeModifiers(Multimap<String, class_1322> modifiers) {
        this.capability().removeSlotModifiers(modifiers);
    }

    @Override
    public void clearModifiers() {
        this.capability().clearSlotModifiers();
    }

    @Override
    public Multimap<String, class_1322> getModifiers() {
        return this.capability().getSlotModifiers();
    }

    @Override
    public boolean isEquipped(Predicate<class_1799> predicate) {
        return this.capability().isEquipped(predicate);
    }

    @Override
    public List<class_3545<dev.emi.trinkets.api.SlotReference, class_1799>> getEquipped(Predicate<class_1799> predicate) {
        List equipped = this.capability().getEquipped(predicate);
        return equipped.stream().map(slotResult -> {
            Optional<dev.emi.trinkets.api.SlotReference> reference = WrappingTrinketsUtils.createTrinketsReference(slotResult.reference());
            return reference.map(slotReference -> new class_3545(slotReference, (Object)slotResult.stack())).orElse(null);
        }).filter(Objects::nonNull).toList();
    }

    @Override
    public List<class_3545<dev.emi.trinkets.api.SlotReference, class_1799>> getAllEquipped() {
        return this.capability().getAllEquipped().stream().map(slotResult -> {
            Optional<dev.emi.trinkets.api.SlotReference> reference = WrappingTrinketsUtils.createTrinketsReference(slotResult.reference());
            return reference.map(slotReference -> new class_3545(slotReference, (Object)slotResult.stack())).orElse(null);
        }).filter(Objects::nonNull).toList();
    }

    @Override
    public void forEach(BiConsumer<dev.emi.trinkets.api.SlotReference, class_1799> consumer) {
        for (class_3545<dev.emi.trinkets.api.SlotReference, class_1799> tuple : this.getAllEquipped()) {
            consumer.accept((dev.emi.trinkets.api.SlotReference)tuple.method_15442(), (class_1799)tuple.method_15441());
        }
    }

    @Override
    public Set<TrinketInventory> getTrackingUpdates() {
        return null;
    }

    @Override
    public void clearCachedModifiers() {
        this.capability().clearCachedSlotModifiers();
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        AccessoriesHolder holder = this.capability().getHolder();
        if (tag.method_10577("is_accessories_data")) {
            ((AccessoriesHolderImpl)holder).read((MapCarrier)new NbtMapCarrier(tag.method_10562("main_data")), SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((class_5455)((class_5455)registryLookup))}));
            return;
        }
        ArrayList<class_1799> dropped = new ArrayList<class_1799>();
        for (String groupKey : tag.method_10541()) {
            class_2487 groupTag = tag.method_10562(groupKey);
            for (String slotKey : groupTag.method_10541()) {
                class_2487 slotTag = groupTag.method_10562(slotKey);
                String slotName = WrappingTrinketsUtils.trinketsToAccessories_Slot(Optional.of(groupKey), slotKey);
                SlotType slotType = SlotTypeLoader.getSlotType((class_1937)this.getEntity().method_37908(), (String)slotName);
                List<class_1799> list = slotTag.method_10554("Items", 10).stream().map(tagEntry -> {
                    class_2487 compoundTag;
                    return class_1799.method_57359((class_7225.class_7874)registryLookup, (class_2487)(tagEntry instanceof class_2487 ? (compoundTag = (class_2487)tagEntry) : new class_2487()));
                }).toList();
                if (slotType == null) {
                    dropped.addAll(list);
                    continue;
                }
                AccessoriesContainer container = this.capability().getContainer(slotType);
                if (container == null) {
                    dropped.addAll(list);
                    System.out.println("Unable to handle the given slotType as a container did not exist");
                    continue;
                }
                ExpandedSimpleContainer accessories = container.getAccessories();
                for (class_1799 stack : list) {
                    boolean consumedStack = false;
                    for (int i = 0; i < accessories.method_5439() && !consumedStack; ++i) {
                        class_1799 currentStack = accessories.method_5438(i);
                        if (!currentStack.method_7960()) continue;
                        accessories.method_5447(i, stack.method_7972());
                        consumedStack = true;
                    }
                    if (consumedStack) continue;
                    dropped.add(stack.method_7972());
                }
            }
        }
        ((AccessoriesHolderImpl)holder).invalidStacks.addAll(dropped);
        List invalidStacks = ((AccessoriesHolderImpl)holder).invalidStacks;
        for (SlotEntryReference entryRef : this.capability().getAllEquipped()) {
            SlotReference reference = entryRef.reference();
            SlotType slotType = reference.type();
            if (AccessoriesAPI.getPredicateResults((Set)slotType.validators(), (class_1937)reference.entity().method_37908(), (class_1309)reference.entity(), (SlotType)slotType, (int)0, (class_1799)entryRef.stack())) continue;
            invalidStacks.add(entryRef.stack().method_7972());
            entryRef.reference().setStack(class_1799.field_8037);
        }
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        NbtMapCarrier innerCarrier = NbtMapCarrier.of();
        ((AccessoriesHolderImpl)this.capability().getHolder()).write((MapCarrier)innerCarrier, SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((class_5455)((class_5455)registryLookup))}));
        tag.method_10566("main_data", (class_2520)innerCarrier.compoundTag());
        tag.method_10556("is_accessories_data", true);
    }
}

