/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.entity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3231;
import net.minecraft.class_3417;
import net.minecraft.class_8710;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import xerca.xercapaint.CanvasType;
import xerca.xercapaint.Mod;
import xerca.xercapaint.entity.Entities;
import xerca.xercapaint.item.Items;
import xerca.xercapaint.packets.PictureRequestPacket;

public class EntityCanvas
extends class_1530 {
    private String canvasTitle;
    private String canvasAuthor;
    private int canvasGeneration = 0;
    private boolean canvasSigned;
    private int tickCounter1 = 0;
    private static final class_2940<String> CANVAS_ID = class_2945.method_12791(EntityCanvas.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Integer> CANVAS_VERSION = class_2945.method_12791(EntityCanvas.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Byte> CANVAS_TYPE_KEY = class_2945.method_12791(EntityCanvas.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Byte> CANVAS_ROTATION = class_2945.method_12791(EntityCanvas.class, (class_2941)class_2943.field_13319);
    public static final Map<String, Picture> PICTURES = Maps.newHashMap();
    public static final Set<String> PICTURE_REQUESTS = Sets.newHashSet();

    public EntityCanvas(class_1937 world, class_1799 stack, class_2338 pos, class_2350 facing, CanvasType canvasType, int rotation) {
        super(Entities.CANVAS, world, pos);
        String id = (String)stack.method_57824(Items.CANVAS_ID);
        int version = (Integer)stack.method_57825(Items.CANVAS_VERSION, (Object)0);
        String title = (String)stack.method_57824(Items.CANVAS_TITLE);
        String author = (String)stack.method_57824(Items.CANVAS_AUTHOR);
        this.setCanvasID(id);
        this.setVersion(version);
        if (title != null && author != null) {
            this.canvasSigned = true;
            this.canvasTitle = title;
            this.canvasAuthor = author;
            this.canvasGeneration = (Integer)stack.method_57825(Items.CANVAS_GENERATION, (Object)0);
        } else {
            this.canvasSigned = false;
        }
        this.setCanvasType(canvasType);
        this.setRotation(rotation);
        this.method_6892(facing);
        Picture picture = PICTURES.get(id);
        if (picture == null || picture.version < version) {
            int[] pixels = null;
            List pixelList = (List)stack.method_57824(Items.CANVAS_PIXELS);
            if (pixelList != null) {
                pixels = pixelList.stream().mapToInt(i -> i).toArray();
            }
            PICTURES.put(id, new Picture(version, pixels));
        }
    }

    public EntityCanvas(class_1299<? extends class_1530> entityCanvasEntityType, class_1937 level) {
        super(entityCanvasEntityType, level);
        this.clientPictureInit(level);
    }

    private void clientPictureInit(class_1937 level) {
        Picture picture;
        if (!level.field_9236) {
            return;
        }
        String canvasID = this.getCanvasID();
        int version = this.getVersion();
        if (!(canvasID.isEmpty() || version <= 0 || (picture = PICTURES.get(this.getCanvasID())) != null && picture.version >= this.getVersion() || PICTURE_REQUESTS.contains(canvasID))) {
            PICTURE_REQUESTS.add(canvasID);
            ClientPlayNetworking.send((class_8710)new PictureRequestPacket(canvasID));
        }
    }

    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 builder) {
        builder.method_56912(CANVAS_ID, (Object)"");
        builder.method_56912(CANVAS_VERSION, (Object)0);
        builder.method_56912(CANVAS_TYPE_KEY, (Object)0);
        builder.method_56912(CANVAS_ROTATION, (Object)0);
    }

    public void method_5674(@NotNull class_2940<?> key) {
        if (CANVAS_TYPE_KEY.equals(key)) {
            this.method_6895();
        } else if (CANVAS_ID.equals(key) || CANVAS_VERSION.equals(key)) {
            this.clientPictureInit(this.method_37908());
        }
    }

    public int getWidth() {
        return CanvasType.getWidth(this.getCanvasType());
    }

    public int getHeight() {
        return CanvasType.getHeight(this.getCanvasType());
    }

    public void method_6889(@Nullable class_1297 brokenEntity) {
        if (this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
            Picture picture;
            class_1799 canvasItem;
            CanvasType canvasType;
            this.method_5783(class_3417.field_14809, 1.0f, 1.0f);
            if (brokenEntity instanceof class_1657) {
                class_1657 playerentity = (class_1657)brokenEntity;
                if (playerentity.method_31549().field_7477) {
                    return;
                }
            }
            if ((canvasType = this.getCanvasType()) == CanvasType.SMALL) {
                canvasItem = new class_1799((class_1935)Items.ITEM_CANVAS);
            } else if (canvasType == CanvasType.LARGE) {
                canvasItem = new class_1799((class_1935)Items.ITEM_CANVAS_LARGE);
            } else if (canvasType == CanvasType.LONG) {
                canvasItem = new class_1799((class_1935)Items.ITEM_CANVAS_LONG);
            } else if (canvasType == CanvasType.TALL) {
                canvasItem = new class_1799((class_1935)Items.ITEM_CANVAS_TALL);
            } else {
                Mod.LOGGER.error("Invalid canvas type");
                return;
            }
            canvasItem.method_57379(Items.CANVAS_ID, (Object)this.getCanvasID());
            canvasItem.method_57379(Items.CANVAS_VERSION, (Object)this.getVersion());
            if (this.canvasSigned) {
                canvasItem.method_57379(Items.CANVAS_AUTHOR, (Object)this.canvasAuthor);
                canvasItem.method_57379(Items.CANVAS_TITLE, (Object)this.canvasTitle);
                canvasItem.method_57379(Items.CANVAS_GENERATION, (Object)this.canvasGeneration);
            }
            if ((picture = PICTURES.get(this.getCanvasID())) != null) {
                canvasItem.method_57379(Items.CANVAS_PIXELS, Arrays.stream(picture.pixels).boxed().toList());
            }
            this.method_5775(canvasItem);
        }
    }

    public void method_5773() {
        this.field_6014 = this.method_23317();
        this.field_6036 = this.method_23318();
        this.field_5969 = this.method_23321();
        if (this.tickCounter1++ == 50 && !this.method_37908().field_9236) {
            this.tickCounter1 = 0;
            if (this.method_5805() && !this.method_6888()) {
                this.method_5650(class_1297.class_5529.field_26999);
                this.method_6889(null);
            }
        }
    }

    public void method_6894() {
        this.method_5783(class_3417.field_14875, 1.0f, 1.0f);
    }

    protected void method_6892(@NotNull class_2350 facingDirectionIn) {
        Validate.notNull((Object)facingDirectionIn);
        this.field_7099 = facingDirectionIn;
        if (facingDirectionIn.method_10166().method_10179()) {
            this.method_36457(0.0f);
            this.method_36456(this.field_7099.method_10161() * 90);
        } else {
            this.method_36457(-90 * facingDirectionIn.method_10171().method_10181());
            this.method_36456(0.0f);
        }
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
        this.method_6895();
    }

    private double offs(int l) {
        return l % 32 == 0 ? 0.5 : 0.0;
    }

    public void method_5808(double x, double y, double z, float yRot, float xRot) {
        this.method_5814(x, y, z);
    }

    public void method_5759(double x, double y, double z, float yRot, float xRot, int steps) {
        this.method_5814(x, y, z);
    }

    @NotNull
    protected class_238 method_59943(@NotNull class_2338 pos, @NotNull class_2350 direction) {
        double d1 = (double)pos.method_10263() + 0.5 - (double)direction.method_10148() * 0.46875;
        double d2 = (double)pos.method_10264() + 0.5 - (double)direction.method_10164() * 0.46875;
        double d3 = (double)pos.method_10260() + 0.5 - (double)direction.method_10165() * 0.46875;
        if (direction.method_10166().method_10179()) {
            double d4 = this.offs(this.getWidth());
            double d5 = this.offs(this.getHeight());
            d2 += d5;
            class_2350 ccwDirection = direction.method_10160();
            d1 += d4 * (double)ccwDirection.method_10148();
            d3 += d4 * (double)ccwDirection.method_10165();
        }
        double d6 = this.getWidth();
        double d7 = this.getHeight();
        double d8 = this.getWidth();
        class_2350.class_2351 direction$axis = direction.method_10166();
        switch (direction$axis) {
            case field_11048: {
                d6 = 1.0;
                break;
            }
            case field_11052: {
                d7 = 1.0;
                break;
            }
            case field_11051: {
                d8 = 1.0;
            }
        }
        return new class_238(d1 - (d6 /= 32.0), d2 - (d7 /= 32.0), d3 - (d8 /= 32.0), d1 + d6, d2 + d7, d3 + d8);
    }

    public boolean method_6888() {
        if (this.field_7099.method_10166().method_10179()) {
            return super.method_6888();
        }
        if (!this.method_37908().method_17892((class_1297)this)) {
            return false;
        }
        class_2680 blockstate = this.method_37908().method_8320(this.field_51589.method_10093(this.field_7099.method_10153()));
        return (blockstate.method_51367() || this.field_7099.method_10166().method_10179() && class_2312.method_9999((class_2680)blockstate)) && this.method_37908().method_8333((class_1297)this, this.method_5829(), field_7098).isEmpty();
    }

    public int getRotation() {
        return ((Byte)this.method_5841().method_12789(CANVAS_ROTATION)).byteValue();
    }

    private void setRotation(int rotation) {
        this.method_5841().method_12778(CANVAS_ROTATION, (Object)((byte)(rotation % 4)));
    }

    public String getCanvasID() {
        return (String)this.method_5841().method_12789(CANVAS_ID);
    }

    private void setCanvasID(String canvasID) {
        this.method_5841().method_12778(CANVAS_ID, (Object)canvasID);
    }

    public int getVersion() {
        return (Integer)this.method_5841().method_12789(CANVAS_VERSION);
    }

    private void setVersion(int version) {
        this.method_5841().method_12778(CANVAS_VERSION, (Object)version);
    }

    public CanvasType getCanvasType() {
        return CanvasType.fromByte((Byte)this.method_5841().method_12789(CANVAS_TYPE_KEY));
    }

    public byte getCanvasTypeKey() {
        return (Byte)this.method_5841().method_12789(CANVAS_TYPE_KEY);
    }

    private void setCanvasType(CanvasType canvasType) {
        this.method_5841().method_12778(CANVAS_TYPE_KEY, (Object)((byte)canvasType.ordinal()));
    }

    @NotNull
    public class_2596<class_2602> method_18002(@NotNull class_3231 entity) {
        return new class_2604((class_1297)this, this.field_7099.method_10146(), this.method_59940());
    }

    public void method_31471(@NotNull class_2604 packet) {
        super.method_31471(packet);
        this.method_6892(class_2350.method_10143((int)packet.method_11166()));
    }

    public void method_5749(class_2487 tagCompound) {
        CanvasType canvasType;
        Picture picture;
        this.field_51589 = new class_2338(tagCompound.method_10550("TileX"), tagCompound.method_10550("TileY"), tagCompound.method_10550("TileZ"));
        class_2487 canvasNBT = tagCompound;
        if (tagCompound.method_10545("canvas")) {
            canvasNBT = tagCompound.method_10562("canvas");
        }
        this.canvasSigned = canvasNBT.method_10545("author") && canvasNBT.method_10545("title");
        String canvasId = canvasNBT.method_10558("name");
        this.setCanvasID(canvasId);
        int version = canvasNBT.method_10550("v");
        this.setVersion(version);
        if (this.canvasSigned) {
            this.canvasAuthor = canvasNBT.method_10558("author");
            this.canvasTitle = canvasNBT.method_10558("title");
            this.canvasGeneration = canvasNBT.method_10550("generation");
        }
        if ((picture = PICTURES.get(canvasId)) == null || picture.version < version) {
            PICTURES.put(canvasId, new Picture(version, canvasNBT.method_10561("pixels")));
        }
        if ((canvasType = CanvasType.fromByte(tagCompound.method_10571("ctype"))) == null) {
            Mod.LOGGER.error("EntityCanvas invalid ctype in readAdditionalSaveData");
            this.method_5768();
            return;
        }
        this.setCanvasType(canvasType);
        if (tagCompound.method_10545("Facing") && !tagCompound.method_10545("RealFace")) {
            byte facing = tagCompound.method_10571("Facing");
            class_2350 horizontal = class_2350.method_10139((int)facing);
            this.method_6892(horizontal);
        } else {
            this.method_6892(class_2350.method_10143((int)tagCompound.method_10571("RealFace")));
        }
        this.setRotation(tagCompound.method_10571("Rotation"));
    }

    public void method_5652(class_2487 tagCompound) {
        class_2338 blockpos = this.method_59940();
        tagCompound.method_10569("TileX", blockpos.method_10263());
        tagCompound.method_10569("TileY", blockpos.method_10264());
        tagCompound.method_10569("TileZ", blockpos.method_10260());
        tagCompound.method_10582("name", this.getCanvasID());
        tagCompound.method_10569("v", this.getVersion());
        if (this.canvasSigned) {
            tagCompound.method_10582("author", this.canvasAuthor);
            tagCompound.method_10582("title", this.canvasTitle);
            tagCompound.method_10569("generation", this.canvasGeneration);
        }
        tagCompound.method_10567("ctype", this.getCanvasTypeKey());
        tagCompound.method_10567("RealFace", (byte)this.field_7099.method_10146());
        tagCompound.method_10567("Rotation", (byte)this.getRotation());
        Picture picture = PICTURES.get(this.getCanvasID());
        if (picture != null) {
            tagCompound.method_10539("pixels", picture.pixels);
        }
    }

    @NotNull
    public class_1269 method_5688(@NotNull class_1657 player, @NotNull class_1268 hand) {
        CanvasType canvasType = this.getCanvasType();
        if (canvasType == CanvasType.SMALL || canvasType == CanvasType.LARGE) {
            if (!this.method_37908().field_9236) {
                this.setRotation(this.getRotation() + 1);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static class Picture {
        public final int version;
        public final int[] pixels;

        public Picture(int version, int[] pixels) {
            this.version = version;
            this.pixels = pixels;
        }
    }
}

