/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.general;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3694;
import net.minecraft.class_3695;
import net.minecraft.class_3965;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.JadeAddons;
import snownee.jade.addon.JadeAddonsBase;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IBoxElement;
import snownee.jade.util.JsonConfig;

public class TargetModifierLoader
extends class_4309
implements JadeRayTraceCallback,
JadeTooltipCollectedCallback {
    protected final ListMultimap<Object, class_2960> tagsToRemove = ArrayListMultimap.create();
    protected final Map<Object, class_2248> replacementBlocks = Maps.newHashMap();

    public TargetModifierLoader() {
        super(JsonConfig.GSON, "jade/target_modifier");
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profilerFiller) {
        this.tagsToRemove.clear();
        this.replacementBlocks.clear();
        for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
            class_2960 id = entry.getKey();
            try {
                JsonObject jsonObject = entry.getValue().getAsJsonObject();
                String type = class_3518.method_15265((JsonObject)jsonObject, (String)"type");
                List<?> targets = TargetModifierLoader.parseTargets(class_3518.method_15296((JsonObject)jsonObject, (String)"target"));
                if ("remove_elements".equals(type)) {
                    JsonElement tagElement = class_3518.method_52226((JsonObject)jsonObject, (String)"tag");
                    List<class_2960> tags = tagElement.isJsonArray() ? tagElement.getAsJsonArray().asList().stream().map(JsonElement::getAsString).map(class_2960::method_60654).toList() : List.of(class_2960.method_60654((String)tagElement.getAsString()));
                    for (Object target : targets) {
                        this.tagsToRemove.putAll(target, tags);
                    }
                    continue;
                }
                if ("replace".equals(type)) {
                    JsonObject with = class_3518.method_15296((JsonObject)jsonObject, (String)"with");
                    class_2248 block = TargetModifierLoader.parseBlocks(with).getFirst();
                    for (Object target : targets) {
                        this.replacementBlocks.put(target, block);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Unknown type: " + type);
            }
            catch (Exception e) {
                if (!IWailaConfig.get().getGeneral().isDebug()) continue;
                JadeAddons.LOGGER.error("Failed to load target modifier {}", (Object)id, (Object)e);
            }
        }
    }

    private static List<?> parseTargets(JsonObject jsonObject) {
        if (jsonObject.has("block") && jsonObject.has("entity")) {
            throw new IllegalArgumentException("Cannot have both block and entity");
        }
        if (jsonObject.has("block")) {
            return TargetModifierLoader.parseBlocks(jsonObject);
        }
        if (jsonObject.has("entity")) {
            return TargetModifierLoader.parseEntities(jsonObject);
        }
        throw new IllegalArgumentException("Must have either block or entity");
    }

    private static List<? extends class_1299<?>> parseEntities(JsonObject jsonObject) {
        String entityId = class_3518.method_15265((JsonObject)jsonObject, (String)"entity");
        if (entityId.startsWith("#")) {
            List<class_1299> list = Streams.stream((Iterable)class_7923.field_41177.method_40286(class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60654((String)entityId.substring(1))))).map(class_6880::comp_349).toList();
            Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)("No entity type found for tag: " + entityId));
            return list;
        }
        List list = class_7923.field_41177.method_17966(class_2960.method_60654((String)entityId)).map(List::of).orElse(List.of());
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)("No entity type found for id: " + entityId));
        return list;
    }

    private static List<class_2248> parseBlocks(JsonObject jsonObject) {
        String blockId = class_3518.method_15265((JsonObject)jsonObject, (String)"block");
        if (blockId.startsWith("#")) {
            List<class_2248> blocks = Streams.stream((Iterable)class_7923.field_41175.method_40286(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)blockId.substring(1))))).map(class_6880::comp_349).toList();
            Preconditions.checkArgument((!blocks.isEmpty() ? 1 : 0) != 0, (Object)("No block found for tag: " + blockId));
            return blocks;
        }
        List<class_2248> list = class_7923.field_41175.method_17966(class_2960.method_60654((String)blockId)).map(List::of).orElse(List.of());
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)("No block found for id: " + blockId));
        return list;
    }

    public void reload() {
        class_310 mc = class_310.method_1551();
        Map map = this.method_20731(mc.method_1478(), (class_3695)class_3694.field_16280);
        this.apply(map, mc.method_1478(), (class_3695)class_3694.field_16280);
    }

    @Nullable
    public Accessor<?> onRayTrace(class_239 hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        Object identifier = TargetModifierLoader.getTargetIdentifier(accessor);
        if (identifier == null) {
            return accessor;
        }
        class_2248 replacement = this.replacementBlocks.get(identifier);
        if (replacement == null) {
            return accessor;
        }
        if (replacement == class_2246.field_10124) {
            return null;
        }
        if (accessor == null || accessor.getPlayer().method_7337()) {
            return accessor;
        }
        if (JadeAddonsBase.client.maybeLowVisionUser() || !IWailaConfig.get().getGeneral().getBuiltinCamouflage()) {
            return accessor;
        }
        if (accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            return JadeAddonsBase.client.blockAccessor().from(blockAccessor).blockState(replacement.method_9564()).build();
        }
        if (accessor instanceof EntityAccessor) {
            class_3965 blockHitResult = new class_3965(hitResult.method_17784(), accessor.getPlayer().method_5735().method_10153(), class_2338.method_49638((class_2374)hitResult.method_17784()), false);
            return JadeAddonsBase.client.blockAccessor().hit(blockHitResult).player(accessor.getPlayer()).blockState(replacement.method_9564()).build();
        }
        return accessor;
    }

    public void onTooltipCollected(IBoxElement rootElement, Accessor<?> accessor) {
        Object identifier = TargetModifierLoader.getTargetIdentifier(accessor);
        if (identifier == null) {
            return;
        }
        for (class_2960 tag : this.tagsToRemove.get(identifier)) {
            rootElement.getTooltip().remove(tag);
        }
    }

    @Nullable
    public static Object getTargetIdentifier(@Nullable Accessor<?> accessor) {
        if (accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            return blockAccessor.getBlock();
        }
        if (accessor instanceof EntityAccessor) {
            EntityAccessor entityAccessor = (EntityAccessor)accessor;
            return entityAccessor.getEntity().method_5864();
        }
        return null;
    }
}

