/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client;

import fuzs.puzzleslib.api.client.core.v1.ClientAbstractions;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.event.v1.AddResourcePackReloadListenersCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.AddToastCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenMouseEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenOpeningCallback;
import fuzs.puzzleslib.api.client.gui.v2.screen.ScreenSkipper;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.config.ConfigTranslationsManager;
import fuzs.puzzleslib.impl.core.EventHandlerProvider;
import net.minecraft.class_1157;
import net.minecraft.class_1761;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_370;
import net.minecraft.class_4071;
import net.minecraft.class_425;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_481;
import net.minecraft.class_5244;
import net.minecraft.class_525;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_8100;

public class PuzzlesLibClient
implements ClientModConstructor {
    @Override
    public void onConstructMod() {
        PuzzlesLibClient.registerEventHandlers();
        PuzzlesLibClient.setupDevelopmentEnvironment();
    }

    private static void registerEventHandlers() {
        AddResourcePackReloadListenersCallback.EVENT.register(ConfigTranslationsManager::onAddResourcePackReloadListeners);
    }

    private static void setupDevelopmentEnvironment() {
        if (!PuzzlesLib.isDevelopmentEnvironmentWithoutDataGeneration()) {
            return;
        }
        if (ModLoaderEnvironment.INSTANCE.getModLoader().isForgeLike()) {
            PuzzlesLibClient.setupGameOptions();
        }
        ScreenOpeningCallback.EVENT.register((oldScreen, newScreen) -> {
            Object patt0$temp = newScreen.get();
            if (patt0$temp instanceof class_442) {
                class_442 screen = (class_442)patt0$temp;
                screen.field_18222 = false;
            } else {
                Object patt1$temp = newScreen.get();
                if (patt1$temp instanceof class_525) {
                    class_525 screen = (class_525)patt1$temp;
                    screen.method_48657().method_48704(class_8100.class_4539.field_20626);
                    screen.method_48657().method_48713(true);
                }
            }
            return EventResult.PASS;
        });
        ScreenEvents.beforeInit(class_442.class).register((minecraft, screen, screenWidth, screenHeight, widgets) -> {
            class_4071 patt0$temp = minecraft.method_18506();
            if (patt0$temp instanceof class_425) {
                class_425 loadingOverlay = (class_425)patt0$temp;
                if (loadingOverlay.field_17771 != 0L) {
                    loadingOverlay.field_17771 = 0L;
                }
            }
        });
        AddToastCallback.EVENT.register((toastManager, toast) -> {
            class_370 systemToast;
            if (toast instanceof class_370 && (systemToast = (class_370)toast).method_1989() == class_370.class_9037.field_47589) {
                return EventResult.INTERRUPT;
            }
            if (toastManager.method_45076() == 0) {
                return EventResult.INTERRUPT;
            }
            return EventResult.PASS;
        });
        ScreenSkipper.create().setTitleComponent("selectWorld.backupQuestion.experimental").setButtonComponent("selectWorld.backupJoinSkipButton").build();
        ScreenSkipper.create().setTitleComponent("selectWorld.warning.experimental.title").setButtonComponent(class_5244.field_24336).build();
        ScreenSkipper.create().setTitleComponent("controls.title").setButtonComponent("controls.keybinds").setLastTitleComponent("options.title").build();
        ScreenMouseEvents.beforeMouseClick(class_437.class).register((screen, mouseX, mouseY, button) -> {
            for (class_364 guiEventListener : screen.method_25396()) {
                if (!(guiEventListener instanceof class_342) || !guiEventListener.method_25402(mouseX, mouseY, button)) continue;
                screen.method_25395(guiEventListener);
                if (button == 0) {
                    screen.method_25398(true);
                }
                return EventResult.INTERRUPT;
            }
            return EventResult.PASS;
        });
        ScreenMouseEvents.beforeMouseRelease(class_437.class).register((screen, mouseX, mouseY, button) -> {
            screen.method_25398(false);
            return screen.method_19355(mouseX, mouseY).filter(class_342.class::isInstance).filter(guiEventListener -> guiEventListener.method_25406(mouseX, mouseY, button)).isPresent() ? EventResult.INTERRUPT : EventResult.PASS;
        });
        ScreenMouseEvents.beforeMouseDrag(class_437.class).register((screen, mouseX, mouseY, button, dragX, dragY) -> screen.method_25399() instanceof class_342 && screen.method_25397() && button == 0 && screen.method_25399().method_25403(mouseX, mouseY, button, dragX, dragY) ? EventResult.INTERRUPT : EventResult.PASS);
    }

    private static void setupGameOptions() {
        class_310 minecraft = class_310.method_1551();
        boolean running = minecraft.field_1698;
        minecraft.field_1698 = false;
        PuzzlesLibClient.initializeGameOptions(minecraft.field_1690);
        minecraft.field_1698 = running;
    }

    public static void initializeGameOptions(class_315 options) {
        if (options.method_37294().exists()) {
            return;
        }
        options.method_42503().method_41748((Object)16);
        options.method_42524().method_41748((Object)60);
        options.method_53530().method_41748((Object)false);
        options.field_1827 = true;
        options.field_1875 = class_1157.field_5653;
        options.field_26844 = true;
        options.field_28777 = true;
        options.method_47395().method_41748((Object)true);
        options.method_42435().method_41748((Object)false);
        options.method_42440().method_41748((Object)false);
        options.method_42443().method_41748((Object)true);
        options.method_42474().method_41748((Object)8);
        options.field_41785 = false;
        options.field_21840 = true;
        options.method_48974().method_41748((Object)0.0);
    }

    @Override
    public void onClientSetup() {
        EventHandlerProvider.tryRegister(ClientAbstractions.INSTANCE);
        if (PuzzlesLib.isDevelopmentEnvironmentWithoutDataGeneration()) {
            class_481.field_2896 = (class_1761)class_7923.field_44687.method_31140(class_7706.field_40200);
        }
    }
}

