/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.position;

import fi.dy.masa.malilib.util.StringUtils;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public enum BlockRotation {
    NONE(0, class_2470.field_11467, "none"),
    CW_90(1, class_2470.field_11463, "rotate_90"),
    CW_180(2, class_2470.field_11464, "rotate_180"),
    CCW_90(3, class_2470.field_11465, "rotate_270");

    public static final BlockRotation[] VALUES;
    private final int index;
    private final String name;
    private final String translationKey;
    private final class_2470 vanillaRotation;

    private BlockRotation(int index, class_2470 vanillaRotation, String name) {
        this.index = index;
        this.vanillaRotation = vanillaRotation;
        this.name = name;
        this.translationKey = "malilib.label.block_rotation." + name;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return StringUtils.translate(this.translationKey, new Object[0]);
    }

    public BlockRotation add(BlockRotation rotation) {
        int index = this.index + rotation.index & 3;
        return VALUES[index];
    }

    public class_2350 rotate(class_2350 direction) {
        if (direction.method_10166() != class_2350.class_2351.field_11052) {
            switch (this.ordinal()) {
                case 1: {
                    return direction.method_10170();
                }
                case 2: {
                    return direction.method_10153();
                }
                case 3: {
                    return direction.method_10160();
                }
            }
        }
        return direction;
    }

    public BlockRotation getReverseRotation() {
        switch (this.ordinal()) {
            case 3: {
                return CW_90;
            }
            case 1: {
                return CCW_90;
            }
            case 2: {
                return CW_180;
            }
        }
        return this;
    }

    public BlockRotation cycle(boolean reverse) {
        int index = this.index + (reverse ? -1 : 1) & 3;
        return VALUES[index];
    }

    public class_2470 getVanillaRotation() {
        return this.vanillaRotation;
    }

    public static BlockRotation byName(String name) {
        for (BlockRotation rot : VALUES) {
            if (!rot.name.equalsIgnoreCase(name)) continue;
            return rot;
        }
        return NONE;
    }

    static {
        VALUES = BlockRotation.values();
    }
}

