/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.fabric;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.mehvahdjukaar.moonlight.api.block.IFlammable;
import net.mehvahdjukaar.moonlight.api.misc.fake_level.FakeLevelManager;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.FabricConfigHolder;
import net.mehvahdjukaar.moonlight.api.platform.fabric.RegHelperImpl;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.resources.recipe.fabric.BlockTypeSwapIngredientImpl;
import net.mehvahdjukaar.moonlight.api.resources.recipe.fabric.ResourceConditionsBridge;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.fluid.SoftFluidInternal;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundSendLoginPacket;
import net.mehvahdjukaar.moonlight.fabric.DataMapBridge;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2682;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class MoonlightFabric
implements ModInitializer,
DedicatedServerModInitializer {
    private static boolean isInit = true;
    private static MinecraftServer currentServer;
    public static final Queue<Runnable> COMMON_SETUP_WORK;
    public static final Queue<Runnable> PRE_SETUP_WORK;
    public static final Queue<Runnable> AFTER_SETUP_WORK;

    public void onInitialize() {
        Moonlight.commonInit();
        ServerPlayConnectionEvents.JOIN.register((l, s, m) -> NetworkHelper.sendToClientPlayer(l.field_14140, new ClientBoundSendLoginPacket()));
        ServerLifecycleEvents.SERVER_STARTING.register(s -> {
            currentServer = s;
            Moonlight.beforeServerStart((class_5455)s.method_30611());
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(s -> {
            currentServer = null;
            FakeLevelManager.invalidateAll();
        });
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(SoftFluidInternal::onDataSyncToPlayer);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(DataMapBridge::onDataSyncToPlayer);
        ServerPlayerEvents.COPY_FROM.register(Moonlight::onPlayerCloned);
        ResourceConditionsBridge.init();
        DataMapBridge.init();
        BlockTypeSwapIngredientImpl.register();
    }

    static void commonSetup() {
        MoonlightFabric.registerFlammableBlocks();
        RegHelperImpl.lateRegisterEntries();
        FabricConfigHolder.loadAllConfigs();
        isInit = false;
        PRE_SETUP_WORK.forEach(Runnable::run);
        COMMON_SETUP_WORK.forEach(Runnable::run);
        AFTER_SETUP_WORK.forEach(Runnable::run);
        PRE_SETUP_WORK.clear();
        COMMON_SETUP_WORK.clear();
        AFTER_SETUP_WORK.clear();
    }

    private static void registerFlammableBlocks() {
        class_2682 level = class_2682.field_12294;
        FlammableBlockRegistry reg = FlammableBlockRegistry.getDefaultInstance();
        for (class_2248 b : class_7923.field_41175) {
            if (!(b instanceof IFlammable)) continue;
            IFlammable f = (IFlammable)b;
            int flammability = f.getFlammability(b.method_9564(), (class_1922)level, class_2338.field_10980, class_2350.field_11036);
            int spreadSpeed = f.getFireSpreadSpeed(b.method_9564(), (class_1922)level, class_2338.field_10980, class_2350.field_11036);
            reg.add(b, flammability, spreadSpeed);
        }
    }

    public void onInitializeServer() {
        MoonlightFabric.commonSetup();
    }

    public static MinecraftServer getCurrentServer() {
        return currentServer;
    }

    public static boolean isInitializing() {
        return isInit;
    }

    static {
        COMMON_SETUP_WORK = new ConcurrentLinkedQueue<Runnable>();
        PRE_SETUP_WORK = new ConcurrentLinkedQueue<Runnable>();
        AFTER_SETUP_WORK = new ConcurrentLinkedQueue<Runnable>();
    }
}

