/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading.properties.optifine_properties;

import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.StringArrayOrRegexProperty;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFUtils2;

public class BlocksProperty
extends StringArrayOrRegexProperty {
    private static final Function<Map.Entry<class_2769<?>, Comparable<?>>, String> PROPERTY_MAP_PRINTER = new Function<Map.Entry<class_2769<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<class_2769<?>, Comparable<?>> entry) {
            if (entry == null) {
                return "<NULL>";
            }
            class_2769<?> property = entry.getKey();
            String var10000 = property.method_11899();
            return var10000 + "=" + this.nameValue(property, entry.getValue());
        }

        private <T extends Comparable<T>> String nameValue(class_2769<T> property, Comparable<?> value) {
            return property.method_11901(value);
        }
    };
    protected final Function<class_2680, Boolean> blockStateMatcher;
    protected final boolean botherWithDeepStateCheck;

    protected BlocksProperty(Properties properties, int propertyNum, String[] ids) throws RandomProperty.RandomPropertyException {
        super(BlocksProperty.readPropertiesOrThrow(properties, propertyNum, ids).replaceAll("(?<=(^| ))minecraft:", ""));
        if (this.usesRegex) {
            this.blockStateMatcher = blockState -> {
                if (this.MATCHER.testString(this.getFromStateBlockNameOnly((class_2680)blockState))) {
                    return true;
                }
                return this.MATCHER.testString(this.getFromStateBlockNameWithStateData((class_2680)blockState));
            };
            this.botherWithDeepStateCheck = false;
        } else {
            this.blockStateMatcher = this::testBlocks;
            boolean hasStateNeeds = false;
            for (String s : this.ARRAY) {
                if (!s.contains(":")) continue;
                hasStateNeeds = true;
                break;
            }
            this.botherWithDeepStateCheck = hasStateNeeds;
        }
    }

    public static BlocksProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new BlocksProperty(properties, propertyNum, new String[]{"blocks", "block"});
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    protected String getFromStateBlockNameOnly(class_2680 state) {
        String block = class_7923.field_41175.method_10221((Object)state.method_26204()).toString().replaceFirst("minecraft:", "");
        if (this.doPrint) {
            ETFUtils2.logMessage("Blocks property print (no blockstate data): [" + block + "]");
        }
        return block;
    }

    private String getFromStateBlockNameWithStateData(class_2680 state) {
        Object block = this.getFromStateBlockNameOnly(state);
        if (!state.method_11656().isEmpty()) {
            block = (String)block + ":" + state.method_11656().entrySet().stream().map(PROPERTY_MAP_PRINTER).collect(Collectors.joining(":"));
        }
        if (this.doPrint) {
            ETFUtils2.logMessage("Blocks property print (with blockstate data): [" + (String)block + "]");
        }
        return block;
    }

    protected boolean testBlocks(class_2680 blockState) {
        if (this.MATCHER.testString(this.getFromStateBlockNameOnly(blockState))) {
            return true;
        }
        if (this.botherWithDeepStateCheck) {
            String fullBlockState = this.getFromStateBlockNameWithStateData(blockState);
            for (String string : this.ARRAY) {
                if (!string.contains(":")) continue;
                boolean matchesAllStateDataNeeded = true;
                for (String split : string.split(":")) {
                    if (fullBlockState.contains(split)) continue;
                    matchesAllStateDataNeeded = false;
                    break;
                }
                if (!matchesAllStateDataNeeded) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean shouldForceLowerCaseCheck() {
        return true;
    }

    @Nullable
    protected class_2680[] getTestingBlocks(ETFEntity entity) {
        if (entity.etf$getUuid().getLeastSignificantBits() == 0x303900003039L) {
            return new class_2680[]{class_2246.field_10260.method_9564()};
        }
        if (entity instanceof class_2586) {
            class_2586 blockEntity = (class_2586)entity;
            if (blockEntity.method_10997() == null) {
                return new class_2680[]{blockEntity.method_11010()};
            }
            return new class_2680[]{blockEntity.method_11010(), blockEntity.method_10997().method_8320(blockEntity.method_11016().method_10074())};
        }
        if (entity.etf$getWorld() == null || entity.etf$getBlockPos() == null) {
            return null;
        }
        class_1937 world = entity.etf$getWorld();
        class_2338 pos = entity.etf$getBlockPos();
        return new class_2680[]{world.method_8320(pos), world.method_8320(pos.method_10074())};
    }

    @Override
    public boolean testEntityInternal(ETFEntity entity) {
        Object[] entityBlocks = this.getTestingBlocks(entity);
        if (entityBlocks == null) {
            if (this.doPrint) {
                ETFUtils2.logMessage("Blocks property print result: [false], because null");
            }
            return false;
        }
        if (this.doPrint) {
            ETFUtils2.logMessage("Blocks property print, found blocks: [" + Arrays.toString(entityBlocks) + "]");
        }
        for (Object entityBlock : entityBlocks) {
            if (!this.blockStateMatcher.apply((class_2680)entityBlock).booleanValue()) continue;
            if (this.doPrint) {
                ETFUtils2.logMessage("Blocks property print result: [true]");
            }
            return true;
        }
        if (this.doPrint) {
            ETFUtils2.logMessage("Blocks property print result: [false]");
        }
        return false;
    }

    @Override
    @Nullable
    public String getValueFromEntity(ETFEntity etfEntity) {
        return null;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"blocks", "block"};
    }
}

