/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.trimmable.tools.resource;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.trimmable.tools.TrimmableTools;
import dev.worldgen.trimmable.tools.config.ConfigHandler;
import dev.worldgen.trimmable.tools.config.TrimData;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5253;
import net.minecraft.class_7368;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import net.minecraft.class_7948;
import net.minecraft.class_7951;
import net.minecraft.class_7952;
import net.minecraft.class_7958;
import net.minecraft.class_8684;
import org.jetbrains.annotations.NotNull;

public record TrimPalettedPermutations(List<class_2960> textures, class_2960 paletteKey, Map<String, class_2960> permutations) implements class_7948
{
    public static final MapCodec<TrimPalettedPermutations> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("palette_key").forGetter(TrimPalettedPermutations::paletteKey)).apply((Applicative)instance, TrimPalettedPermutations::create));

    public static TrimPalettedPermutations create(class_2960 paletteKey) {
        ArrayList<class_2960> textures = new ArrayList<class_2960>();
        for (class_2960 toolType : ConfigHandler.config().toolTypes().keySet()) {
            for (class_2960 pattern : TrimData.PATTERNS) {
                textures.add(toolType.method_45138("trims/items/").method_48331("/" + pattern.method_12832()));
            }
        }
        HashMap<String, class_2960> permutations = new HashMap<String, class_2960>();
        for (class_2960 id : TrimData.MATERIALS) {
            String key = id.method_12832();
            class_2960 entry = id.method_45138("trims/color_palettes/");
            permutations.put(key, entry);
            if (!ConfigHandler.hasDarkerVariant(key)) continue;
            permutations.put(key + "_darker", entry.method_48331("_darker"));
        }
        return new TrimPalettedPermutations(textures, paletteKey, permutations);
    }

    public void method_47673(@NotNull class_3300 manager, @NotNull class_7948.class_7949 output) {
        Supplier supplier = Suppliers.memoize(() -> TrimPalettedPermutations.loadPaletteEntryFromImage(manager, this.paletteKey));
        HashMap map = new HashMap();
        this.permutations.forEach((arg_0, arg_1) -> TrimPalettedPermutations.lambda$run$3(map, (java.util.function.Supplier)supplier, manager, arg_0, arg_1));
        for (class_2960 textureId : this.textures) {
            class_2960 textureFileId = field_42075.method_45112(textureId);
            Optional optional = manager.method_14486(textureFileId);
            if (optional.isEmpty()) {
                TrimmableTools.LOGGER.warn("Unable to find texture {}", (Object)textureFileId);
                continue;
            }
            class_7958 lazyloadedimage = new class_7958(textureFileId, (class_3298)optional.get(), map.size());
            for (Map.Entry entry : map.entrySet()) {
                class_2960 palettedId = textureId.method_48331("_" + (String)entry.getKey());
                output.method_47670(palettedId, (class_7948.class_7950)new PalettedSpriteSupplier(lazyloadedimage, (java.util.function.Supplier)entry.getValue(), palettedId));
            }
        }
    }

    private static IntUnaryOperator createPaletteMapping(int[] p_266839_, int[] p_266776_) {
        if (p_266776_.length != p_266839_.length) {
            TrimmableTools.LOGGER.warn("Palette mapping has different sizes: {} and {}", (Object)p_266839_.length, (Object)p_266776_.length);
            throw new IllegalArgumentException();
        }
        Int2IntOpenHashMap int2intmap = new Int2IntOpenHashMap(p_266776_.length);
        for (int i = 0; i < p_266839_.length; ++i) {
            int j = p_266839_[i];
            if (class_5253.class_8045.method_48342((int)j) == 0) continue;
            int2intmap.put(class_5253.class_8045.method_48348((int)j), p_266776_[i]);
        }
        return arg_0 -> TrimPalettedPermutations.lambda$createPaletteMapping$4((Int2IntMap)int2intmap, arg_0);
    }

    public static int[] loadPaletteEntryFromImage(class_3300 manager, class_2960 palette) {
        Optional optional = manager.method_14486(field_42075.method_45112(palette));
        if (optional.isEmpty()) {
            TrimmableTools.LOGGER.error("Failed to load palette image {}", (Object)palette);
            throw new IllegalArgumentException();
        }
        try {
            int[] pixels;
            try (InputStream inputstream = ((class_3298)optional.get()).method_14482();
                 class_1011 nativeimage = class_1011.method_4309((InputStream)inputstream);){
                pixels = nativeimage.method_48463();
            }
            return pixels;
        }
        catch (Exception var12) {
            TrimmableTools.LOGGER.error("Couldn't load texture {}", (Object)palette, (Object)var12);
            throw new IllegalArgumentException();
        }
    }

    @NotNull
    public class_7951 method_47672() {
        return class_7952.field_42076;
    }

    private static /* synthetic */ int lambda$createPaletteMapping$4(Int2IntMap int2intmap, int p_267899_) {
        int k = class_5253.class_8045.method_48342((int)p_267899_);
        if (k == 0) {
            return p_267899_;
        }
        int l = class_5253.class_8045.method_48348((int)p_267899_);
        int i1 = int2intmap.getOrDefault(l, class_5253.class_8045.method_48548((int)l));
        int j1 = class_5253.class_8045.method_48342((int)i1);
        return class_5253.class_8045.method_48343((int)(k * j1 / 255), (int)i1);
    }

    private static /* synthetic */ void lambda$run$3(Map map, java.util.function.Supplier supplier, class_3300 manager, String p_267108_, class_2960 p_266969_) {
        map.put(p_267108_, Suppliers.memoize(() -> TrimPalettedPermutations.lambda$run$2((java.util.function.Supplier)supplier, manager, p_266969_)));
    }

    private static /* synthetic */ IntUnaryOperator lambda$run$2(java.util.function.Supplier supplier, class_3300 manager, class_2960 p_266969_) {
        return TrimPalettedPermutations.createPaletteMapping((int[])supplier.get(), TrimPalettedPermutations.loadPaletteEntryFromImage(manager, p_266969_));
    }

    record PalettedSpriteSupplier(class_7958 baseImage, java.util.function.Supplier<IntUnaryOperator> palette, class_2960 permutationLocation) implements class_7948.class_7950
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public class_7764 apply(class_8684 p_295023_) {
            try {
                class_1011 nativeimage = this.baseImage.method_47697().method_48462(this.palette.get());
                class_7764 class_77642 = new class_7764(this.permutationLocation, new class_7771(nativeimage.method_4307(), nativeimage.method_4323()), nativeimage, class_7368.field_38688);
                return class_77642;
            }
            catch (IOException | IllegalArgumentException var8) {
                TrimmableTools.LOGGER.error("Unable to apply palette to {}", (Object)this.permutationLocation, (Object)var8);
            }
            finally {
                this.baseImage.method_47698();
            }
            return null;
        }

        public void method_47676() {
            this.baseImage.method_47698();
        }
    }
}

