/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories;

import blue.endless.jankson.JsonElement;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.events.AllowEntityModificationCallback;
import io.wispforest.accessories.compat.config.AccessoriesConfig;
import io.wispforest.accessories.criteria.AccessoryChangedCriterion;
import io.wispforest.accessories.menu.AccessoriesMenuVariant;
import io.wispforest.accessories.menu.ArmorSlotTypes;
import io.wispforest.accessories.mixin.CriteriaTriggersAccessor;
import io.wispforest.accessories.mixin.owo.ConfigWrapperAccessor;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.client.ScreenVariantPing;
import io.wispforest.accessories.utils.EndecUtils;
import io.wispforest.endec.format.jankson.JanksonDeserializer;
import io.wispforest.endec.format.jankson.JanksonSerializer;
import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_6025;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class Accessories {
    public static final String MODID = "accessories";
    private static final AccessoriesConfig CONFIG = AccessoriesConfig.createAndLoad(builder -> builder.registerDeserializer(JsonElement.class, Vector2i.class, (jsonElement, m) -> (Vector2i)EndecUtils.VECTOR_2_I_ENDEC.decodeFully(JanksonDeserializer::of, jsonElement)).registerSerializer(Vector2i.class, (vector2i, m) -> (JsonElement)EndecUtils.VECTOR_2_I_ENDEC.encodeFully(JanksonSerializer::of, vector2i)));
    public static AccessoryChangedCriterion ACCESSORY_EQUIPPED;
    public static AccessoryChangedCriterion ACCESSORY_UNEQUIPPED;

    public static class_2960 of(String path) {
        return class_2960.method_60655((String)MODID, (String)path);
    }

    public static String translationKey(String path) {
        return "accessories." + path;
    }

    public static class_2561 translation(String path) {
        return class_2561.method_43471((String)Accessories.translationKey(path));
    }

    public static AccessoriesConfig config() {
        return CONFIG;
    }

    public static void askPlayerForVariant(class_3222 player) {
        Accessories.askPlayerForVariant(player, null);
    }

    public static void askPlayerForVariant(class_3222 player, @Nullable class_1309 targetEntity) {
        AccessoriesNetworking.sendToPlayer(player, ScreenVariantPing.of(targetEntity));
    }

    public static boolean attemptOpenScreenPlayer(class_3222 player, AccessoriesMenuVariant variant) {
        class_239 result = class_1675.method_49998((class_1297)player, e -> e instanceof class_1309, (double)player.method_55755());
        if (!(result instanceof class_3966)) {
            return false;
        }
        class_3966 entityHitResult = (class_3966)result;
        Accessories.openAccessoriesMenu((class_1657)player, variant, (class_1309)entityHitResult.method_17782());
        return true;
    }

    public static void openAccessoriesMenu(class_1657 player, AccessoriesMenuVariant variant, @Nullable class_1309 targetEntity) {
        Accessories.openAccessoriesMenu(player, variant, targetEntity, null);
    }

    public static void openAccessoriesMenu(class_1657 player, AccessoriesMenuVariant variant, @Nullable class_1309 targetEntity, @Nullable class_1799 carriedStack) {
        TriState result;
        if (targetEntity != null && !(result = ((AllowEntityModificationCallback)AllowEntityModificationCallback.EVENT.invoker()).allowModifications(targetEntity, player, null)).orElse(false)) {
            return;
        }
        AccessoriesInternals.openAccessoriesMenu(player, variant, targetEntity, carriedStack);
    }

    public static void init() {
        AllowEntityModificationCallback.EVENT.register((target, player, reference) -> {
            class_6025 ownableEntity;
            boolean isOwnersPet;
            class_1299 type = target.method_5864();
            if (type.method_20210(AccessoriesTags.MODIFIABLE_ENTITY_BLACKLIST)) {
                return TriState.FALSE;
            }
            boolean bl = isOwnersPet = target instanceof class_6025 && (ownableEntity = (class_6025)target).method_35057() != null && ownableEntity.method_35057().equals((Object)player);
            if (isOwnersPet || type.method_20210(AccessoriesTags.MODIFIABLE_ENTITY_WHITELIST)) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        });
        ArmorSlotTypes.INSTANCE.init();
    }

    public static void registerCriteria() {
        ACCESSORY_EQUIPPED = CriteriaTriggersAccessor.accessories$callRegister("accessories:equip_accessory", new AccessoryChangedCriterion());
        ACCESSORY_UNEQUIPPED = CriteriaTriggersAccessor.accessories$callRegister("accessories:unequip_accessory", new AccessoryChangedCriterion());
    }

    static {
        ReflectiveEndecBuilder builder2 = ((ConfigWrapperAccessor)((Object)CONFIG)).accessories$builder();
        builder2.register(EndecUtils.VECTOR_2_I_ENDEC, Vector2i.class);
    }
}

