/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.config;

import com.github.nyuppo.MoreMobVariants;
import com.github.nyuppo.config.SheepHornSettings;
import com.github.nyuppo.config.VariantBlacklist;
import com.github.nyuppo.config.VariantSettings;
import com.github.nyuppo.config.Variants;
import com.github.nyuppo.variant.BreedingResultModifier;
import com.github.nyuppo.variant.CustomEyesModifier;
import com.github.nyuppo.variant.CustomVariantNameModifier;
import com.github.nyuppo.variant.CustomWoolModifier;
import com.github.nyuppo.variant.DiscardableModifier;
import com.github.nyuppo.variant.MobVariant;
import com.github.nyuppo.variant.MoonPhaseModifier;
import com.github.nyuppo.variant.NametagOverrideModifier;
import com.github.nyuppo.variant.ShearedWoolColorModifier;
import com.github.nyuppo.variant.ShinyModifier;
import com.github.nyuppo.variant.SpawnableBiomesModifier;
import com.github.nyuppo.variant.VariantModifier;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class ConfigDataLoader
implements SimpleSynchronousResourceReloadListener {
    private final class_2960 SETTINGS_ID = class_2960.method_60655((String)"moremobvariants", (String)"settings/settings.json");
    private final class_2960 SHEEP_HORN_SETTINGS_ID = class_2960.method_60655((String)"moremobvariants", (String)"settings/sheep_horn_settings.json");

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"moremobvariants", (String)"moremobvariants");
    }

    public void method_14491(class_3300 manager) {
        Optional sheepHornSettings;
        MoreMobVariants.LOGGER.info("Reloading config...");
        Variants.clearAllVariants();
        for (class_2960 id : manager.method_14488("variants", path -> path.method_12832().endsWith(".json")).keySet()) {
            String path2 = id.method_12832().substring("variants/".length(), id.method_12832().length() - ".json".length());
            String[] split = path2.split("/");
            if (manager.method_14486(id).isPresent()) {
                try (InputStream stream = ((class_3298)manager.method_14486(id).get()).method_14482();){
                    this.applyVariant(new InputStreamReader(stream, StandardCharsets.UTF_8), id.method_12836(), split[0], split[1]);
                }
                catch (Exception e) {
                    MoreMobVariants.LOGGER.error("Error occured while loading " + split[0] + " variant '" + split[1] + "' (" + id.method_43903() + ")", (Throwable)e);
                }
                continue;
            }
            MoreMobVariants.LOGGER.error(id.method_43903() + " was not present.");
        }
        Variants.validateEmptyVariants();
        VariantBlacklist.clearAllBlacklists();
        for (class_2960 id : manager.method_14488("blacklist", path -> path.method_12832().endsWith(".json")).keySet()) {
            String mob = id.method_12832().substring("blacklist/".length(), id.method_12832().length() - ".json".length());
            if (manager.method_14486(id).isPresent()) {
                try (InputStream stream = ((class_3298)manager.method_14486(id).get()).method_14482();){
                    this.applyBlacklist(new InputStreamReader(stream, StandardCharsets.UTF_8), mob);
                }
                catch (Exception e) {
                    MoreMobVariants.LOGGER.error("Error occured while loading blacklist config " + id.method_43903(), (Throwable)e);
                    VariantBlacklist.clearBlacklist(Variants.getMob(mob));
                }
                continue;
            }
            MoreMobVariants.LOGGER.error(id.method_43903() + " was not present.");
        }
        Variants.applyBlacklists();
        Optional settings = manager.method_14486(this.SETTINGS_ID);
        if (settings.isPresent()) {
            try (InputStream stream = ((class_3298)manager.method_14486(this.SETTINGS_ID).get()).method_14482();){
                this.applySettings(new InputStreamReader(stream, StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                MoreMobVariants.LOGGER.error("Error occured while loading settings config " + this.SETTINGS_ID.method_43903(), (Throwable)e);
                VariantSettings.resetSettings();
            }
        }
        if ((sheepHornSettings = manager.method_14486(this.SHEEP_HORN_SETTINGS_ID)).isPresent()) {
            try (InputStream stream = ((class_3298)manager.method_14486(this.SHEEP_HORN_SETTINGS_ID).get()).method_14482();){
                this.applySheepHornSettings(new InputStreamReader(stream, StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                MoreMobVariants.LOGGER.error("Error occured while loading sheep horn settings config " + this.SHEEP_HORN_SETTINGS_ID.method_43903(), (Throwable)e);
                SheepHornSettings.resetSettings();
            }
        }
    }

    private void applyVariant(Reader reader, String namespace, String mobId, String variantId) {
        JsonElement element = JsonParser.parseReader((Reader)reader);
        int weight = 0;
        ArrayList<VariantModifier> modifiers = new ArrayList<VariantModifier>();
        if (element.getAsJsonObject().size() != 0) {
            JsonElement breeding;
            if (element.getAsJsonObject().has("weight")) {
                weight = element.getAsJsonObject().get("weight").getAsInt();
            } else if (!element.getAsJsonObject().has("nametag_override")) {
                MoreMobVariants.LOGGER.error("Variant " + namespace + ":" + mobId + "/" + variantId + " has no weight, skipping.");
                return;
            }
            if (element.getAsJsonObject().has("name")) {
                modifiers.add(new CustomVariantNameModifier(element.getAsJsonObject().get("name").getAsString()));
            }
            if (element.getAsJsonObject().has("shiny") && element.getAsJsonObject().get("shiny").getAsBoolean()) {
                modifiers.add(new ShinyModifier());
            }
            if (element.getAsJsonObject().has("discard_chance")) {
                modifiers.add(new DiscardableModifier(element.getAsJsonObject().get("discard_chance").getAsDouble()));
            }
            if (element.getAsJsonObject().has("biome_tag")) {
                String[] biomesIdentifier = element.getAsJsonObject().get("biome_tag").getAsString().split(":");
                class_6862 biomes = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)biomesIdentifier[0], (String)biomesIdentifier[1]));
                modifiers.add(new SpawnableBiomesModifier((class_6862<class_1959>)biomes));
            }
            if (element.getAsJsonObject().has("breeding") && (breeding = element.getAsJsonObject().get("breeding")).getAsJsonObject().has("parent1") && breeding.getAsJsonObject().has("parent2") && breeding.getAsJsonObject().has("breeding_chance")) {
                String[] parent1 = breeding.getAsJsonObject().get("parent1").getAsString().split(":");
                String[] parent2 = breeding.getAsJsonObject().get("parent2").getAsString().split(":");
                double breedingChance = breeding.getAsJsonObject().get("breeding_chance").getAsDouble();
                modifiers.add(new BreedingResultModifier(class_2960.method_60655((String)parent1[0], (String)parent1[1]), class_2960.method_60655((String)parent2[0], (String)parent2[1]), breedingChance));
            }
            if (element.getAsJsonObject().has("custom_wool") && element.getAsJsonObject().get("custom_wool").getAsBoolean()) {
                modifiers.add(new CustomWoolModifier());
            }
            if (element.getAsJsonObject().has("has_color_when_sheared") && element.getAsJsonObject().get("has_color_when_sheared").getAsBoolean()) {
                modifiers.add(new ShearedWoolColorModifier());
            }
            if (element.getAsJsonObject().has("custom_eyes") && element.getAsJsonObject().get("custom_eyes").getAsBoolean()) {
                modifiers.add(new CustomEyesModifier());
            }
            if (element.getAsJsonObject().has("nametag_override")) {
                modifiers.add(new NametagOverrideModifier(element.getAsJsonObject().get("nametag_override").getAsString()));
            }
            if (element.getAsJsonObject().has("minimum_moon_size")) {
                modifiers.add(new MoonPhaseModifier(element.getAsJsonObject().get("minimum_moon_size").getAsFloat()));
            }
        }
        Variants.addVariant(Variants.getMob(mobId), new MobVariant(class_2960.method_60655((String)namespace, (String)variantId), weight, modifiers));
    }

    private void applyBlacklist(Reader reader, String mob) {
        JsonElement element = JsonParser.parseReader((Reader)reader);
        if (element.getAsJsonObject().size() != 0 && element.getAsJsonObject().has("blacklist")) {
            JsonArray blacklist = element.getAsJsonObject().get("blacklist").getAsJsonArray();
            for (JsonElement entry : blacklist) {
                String[] entrySplit = entry.getAsString().split(":");
                VariantBlacklist.blacklist(Variants.getMob(mob), class_2960.method_60655((String)entrySplit[0], (String)entrySplit[1]));
            }
        }
    }

    private void applySettings(Reader reader) {
        JsonElement element = JsonParser.parseReader((Reader)reader);
        if (element.getAsJsonObject().size() != 0) {
            if (element.getAsJsonObject().has("enable_muddy_pigs")) {
                VariantSettings.setEnableMuddyPigs(element.getAsJsonObject().get("enable_muddy_pigs").getAsBoolean());
            }
            if (element.getAsJsonObject().has("muddy_pig_timeout")) {
                VariantSettings.setMuddyPigTimeout(element.getAsJsonObject().get("muddy_pig_timeout").getAsInt());
            }
            if (element.getAsJsonObject().has("child_random_variant_chance")) {
                VariantSettings.setChildRandomVariantChance(element.getAsJsonObject().get("child_random_variant_chance").getAsDouble());
            }
        }
    }

    private void applySheepHornSettings(Reader reader) {
        JsonElement element = JsonParser.parseReader((Reader)reader);
        if (element.getAsJsonObject().size() != 0) {
            if (element.getAsJsonObject().has("chance")) {
                SheepHornSettings.setHornsChance(element.getAsJsonObject().get("chance").getAsDouble());
            }
            if (element.getAsJsonObject().has("inherit_parents_chance")) {
                SheepHornSettings.setInheritChance(element.getAsJsonObject().get("inherit_parents_chance").getAsDouble());
            }
            if (element.getAsJsonObject().has("weights")) {
                JsonElement weights = element.getAsJsonObject().get("weights");
                if (weights.getAsJsonObject().has("brown")) {
                    SheepHornSettings.setWeight(SheepHornSettings.SheepHornColour.BROWN, weights.getAsJsonObject().get("brown").getAsInt());
                }
                if (weights.getAsJsonObject().has("gray")) {
                    SheepHornSettings.setWeight(SheepHornSettings.SheepHornColour.GRAY, weights.getAsJsonObject().get("gray").getAsInt());
                }
                if (weights.getAsJsonObject().has("black")) {
                    SheepHornSettings.setWeight(SheepHornSettings.SheepHornColour.BLACK, weights.getAsJsonObject().get("black").getAsInt());
                }
                if (weights.getAsJsonObject().has("beige")) {
                    SheepHornSettings.setWeight(SheepHornSettings.SheepHornColour.BEIGE, weights.getAsJsonObject().get("beige").getAsInt());
                }
            }
        }
    }
}

