/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.config.serializers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import mezz.jei.api.runtime.config.IJeiConfigListValueSerializer;
import mezz.jei.api.runtime.config.IJeiConfigValueSerializer;
import mezz.jei.common.config.file.serializers.DeserializeResult;
import net.minecraft.class_124;

public class ChatFormattingSerializer
implements IJeiConfigListValueSerializer<class_124> {
    public static final ChatFormattingSerializer INSTANCE = new ChatFormattingSerializer();
    private static final ChatFormattingValueSerializer VALUE_SERIALIZER = new ChatFormattingValueSerializer();
    private static final EnumSet<class_124> INVALID_VALUES = EnumSet.of(class_124.field_1070);
    private static final EnumSet<class_124> VALID_VALUES = EnumSet.complementOf(INVALID_VALUES);

    private ChatFormattingSerializer() {
    }

    @Override
    public String serialize(List<class_124> value) {
        return value.stream().map(VALUE_SERIALIZER::serialize).collect(Collectors.joining(" "));
    }

    @Override
    public DeserializeResult<List<class_124>> deserialize(String string) {
        if ((string = string.trim()).startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (string.isEmpty()) {
            return new DeserializeResult<List<class_124>>(List.of());
        }
        ArrayList<String> errors = new ArrayList<String>();
        String[] strings = string.split(" ");
        List result = Arrays.stream(strings).mapMulti((s, c) -> {
            IJeiConfigValueSerializer.IDeserializeResult<class_124> deserializeResult = VALUE_SERIALIZER.deserialize((String)s);
            deserializeResult.getResult().ifPresent((Consumer<class_124>)c);
            errors.addAll(deserializeResult.getErrors());
        }).toList();
        return new DeserializeResult<List<class_124>>(result, errors);
    }

    @Override
    public String getValidValuesDescription() {
        ArrayList<class_124> validColors = new ArrayList<class_124>();
        ArrayList<class_124> validFormats = new ArrayList<class_124>();
        for (class_124 chatFormatting : VALID_VALUES) {
            if (chatFormatting.method_543()) {
                validColors.add(chatFormatting);
                continue;
            }
            if (!chatFormatting.method_542()) continue;
            validFormats.add(chatFormatting);
        }
        return "A chat formatting string.\nUse these formatting colors:\n%s\nWith these formatting options:\n%s".formatted(this.serialize((List<class_124>)validColors), this.serialize((List<class_124>)validFormats));
    }

    @Override
    public boolean isValid(List<class_124> value) {
        return value.stream().allMatch(VALUE_SERIALIZER::isValid);
    }

    @Override
    public IJeiConfigValueSerializer<class_124> getListValueSerializer() {
        return VALUE_SERIALIZER;
    }

    @Override
    public Optional<Collection<List<class_124>>> getAllValidValues() {
        return Optional.empty();
    }

    private static class ChatFormattingValueSerializer
    implements IJeiConfigValueSerializer<class_124> {
        private ChatFormattingValueSerializer() {
        }

        @Override
        public String serialize(class_124 value) {
            return value.method_537();
        }

        @Override
        public IJeiConfigValueSerializer.IDeserializeResult<class_124> deserialize(String string) {
            class_124 chatFormatting = class_124.method_533((String)string);
            if (chatFormatting == null) {
                return new DeserializeResult<Object>(null, "No Chat Formatting found for name: '%s'".formatted(string));
            }
            if (INVALID_VALUES.contains(chatFormatting)) {
                return new DeserializeResult<Object>(null, "Chat Formatting '%s' is not valid".formatted(string));
            }
            return new DeserializeResult<class_124>(chatFormatting);
        }

        @Override
        public boolean isValid(class_124 value) {
            return VALID_VALUES.contains(value);
        }

        @Override
        public Optional<Collection<class_124>> getAllValidValues() {
            return Optional.of(VALID_VALUES);
        }

        @Override
        public String getValidValuesDescription() {
            String validValuesString = VALID_VALUES.stream().map(this::serialize).collect(Collectors.joining(", "));
            return "A chat formatting string.\nUse any of these formatting values:\n%s".formatted(validValuesString);
        }
    }
}

