/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.explosion;

import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.UnmodifiableIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.events.ClientEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_4770;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class CannonBallExplosion
extends class_1927 {
    private final class_2338 centerPos;
    private final float maxExplodedAmount;
    @Nullable
    private final Set<class_2248> whitelist;
    private float explosionAmountLeft;

    public CannonBallExplosion(class_1937 level, @Nullable class_1297 source, double toBlowX, double toBlowY, double toBlowZ, class_2338 centerPos, float maxExplodedAmount, float maxRadius, @Nullable Set<class_2248> whitelist) {
        super(level, source, toBlowX, toBlowY, toBlowZ, maxRadius, false, class_1927.class_4179.field_18687);
        this.centerPos = centerPos;
        this.maxExplodedAmount = maxExplodedAmount;
        this.whitelist = whitelist;
    }

    public CannonBallExplosion(class_1937 level, @Nullable class_1297 source, double toBlowX, double toBlowY, double toBlowZ, float radius, List<class_2338> toBlow) {
        super(level, source, toBlowX, toBlowY, toBlowZ, radius, false, class_1927.class_4179.field_18687, toBlow);
        this.centerPos = class_2338.method_49638((class_2374)new class_243(toBlowX, toBlowY, toBlowZ));
        this.maxExplodedAmount = 0.0f;
        this.whitelist = null;
    }

    public void method_8348() {
        class_243 center = new class_243(this.field_9195, this.field_9192, this.field_9189);
        HashSet<class_2338> visited = new HashSet<class_2338>();
        ArrayDeque<class_2338> toVisit = new ArrayDeque<class_2338>();
        AtomicReference<Float> explosionBudget = new AtomicReference<Float>(Float.valueOf(this.maxExplodedAmount));
        toVisit.add(this.centerPos);
        while (!toVisit.isEmpty() && (double)explosionBudget.get().floatValue() > 0.25) {
            class_2338 currentPos = (class_2338)toVisit.poll();
            this.visit(currentPos, center, explosionBudget, this.method_8346(), visited, toVisit);
        }
        this.explosionAmountLeft = explosionBudget.get().floatValue();
    }

    public float getExploded() {
        return this.maxExplodedAmount - this.explosionAmountLeft;
    }

    private void visit(class_2338 pos, class_243 center, AtomicReference<Float> explosionBudget, List<class_2338> toExplode, Set<class_2338> visited, Queue<class_2338> toVisit) {
        float r = this.field_9190 + this.field_9187.field_9229.method_43057();
        if (!pos.equals((Object)this.centerPos) && center.method_1025(pos.method_46558()) > (double)(r * r)) {
            return;
        }
        if (!this.field_9187.method_24794(pos) || visited.contains(pos)) {
            return;
        }
        visited.add(pos);
        class_2680 blockState = this.field_9187.method_8320(pos);
        class_3610 fluidState = this.field_9187.method_8316(pos);
        boolean canPropagateExplosion = false;
        if (!blockState.method_26215()) {
            if (this.whitelist != null && !this.whitelist.contains(blockState.method_26204())) {
                return;
            }
            Optional optional = this.field_25400.method_29555((class_1927)this, (class_1922)this.field_9187, pos, blockState, fluidState);
            if (optional.isPresent()) {
                float resistance = (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                float newB = explosionBudget.get().floatValue() - resistance;
                if (newB > 0.0f && this.field_25400.method_29554((class_1927)this, (class_1922)this.field_9187, pos, blockState, 1.0f)) {
                    toExplode.add(pos);
                    explosionBudget.set(Float.valueOf(newB));
                    canPropagateExplosion = true;
                }
            }
        }
        if (!canPropagateExplosion) {
            return;
        }
        ArrayList<class_2338> neighborPos = new ArrayList<class_2338>();
        for (class_2350 d : class_2350.values()) {
            neighborPos.add(pos.method_10093(d));
        }
        neighborPos.sort(Comparator.comparingDouble(p -> center.method_1025(p.method_46558())));
        toVisit.addAll(neighborPos);
    }

    public void method_8350(boolean spawnParticles) {
        class_1657 player;
        class_1309 indirectSource;
        if (this.field_9187.field_9236) {
            ClientEvents.onExplosion(this);
        }
        if (spawnParticles) {
            this.field_9187.method_8406((class_2394)class_2398.field_11236, this.field_9195, this.field_9192, this.field_9189, 1.0, 0.0, 0.0);
        }
        boolean hasDrop = !((indirectSource = this.method_8347()) instanceof class_1657 && (player = (class_1657)indirectSource).method_7337());
        class_156.method_43028((List)((ObjectArrayList)this.method_8346()), (class_5819)this.field_9187.field_9229);
        LinkedHashMultiset sounds = LinkedHashMultiset.create();
        for (class_2338 blockPos : this.method_8346()) {
            class_2680 blockState = this.field_9187.method_8320(blockPos);
            if (blockState.method_26215()) continue;
            this.destroyBlockNoEffects(blockPos, this.field_9187, (class_1297)indirectSource, 512, (Multiset<class_3414>)sounds);
        }
        if (this.field_9187.field_9236 && !sounds.isEmpty()) {
            UnmodifiableIterator iter = Multisets.copyHighestCountFirst((Multiset)sounds).iterator();
            for (int i = 0; i < 3 && iter.hasNext(); ++i) {
                class_3414 sound = (class_3414)iter.next();
                this.field_9187.method_8486(this.field_9195, this.field_9192, this.field_9189, sound, class_3419.field_15245, 2.5f, 0.6f + this.field_9187.field_9229.method_43057() * 0.2f, false);
            }
        }
    }

    public boolean destroyBlockNoEffects(class_2338 pos, class_1937 level, @Nullable class_1297 entity, int recursionLeft, Multiset<class_3414> sounds) {
        class_2680 blockState = level.method_8320(pos);
        if (blockState.method_26215()) {
            return false;
        }
        class_3610 fluidState = level.method_8316(pos);
        if (level.field_9236 && !(blockState.method_26204() instanceof class_4770)) {
            sounds.add((Object)SuppPlatformStuff.getSoundType(blockState, pos, level, entity).method_10595());
            level.method_31595(pos, blockState);
        }
        class_2586 blockEntity = blockState.method_31709() ? level.method_8321(pos) : null;
        class_2248.method_9511((class_2680)blockState, (class_1937)level, (class_2338)pos, (class_2586)blockEntity, (class_1297)entity, (class_1799)class_1799.field_8037);
        boolean bl = level.method_30092(pos, fluidState.method_15759(), 3, recursionLeft);
        if (bl) {
            level.method_43276((class_6880)class_5712.field_28165, pos, class_5712.class_7397.method_43286((class_1297)entity, (class_2680)blockState));
        }
        return bl;
    }
}

