/*
 * Decompiled with CFR 0.152.
 */
package net.dragonloot.entity;

import net.dragonloot.init.EntityInit;
import net.dragonloot.init.ItemInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public class DragonTridentEntity
extends class_1665 {
    private static final class_2940<Byte> LOYALTY = class_2945.method_12791(DragonTridentEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> ENCHANTED = class_2945.method_12791(DragonTridentEntity.class, (class_2941)class_2943.field_13323);
    private class_1799 tridentStack;
    private boolean dealtDamage;
    public int returnTimer;

    public DragonTridentEntity(class_1299<? extends DragonTridentEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public DragonTridentEntity(class_1937 world, class_1309 owner, class_1799 stack) {
        super(EntityInit.DRAGON_TRIDENT_ENTITY, owner, world, stack, null);
        this.field_6011.method_12778(LOYALTY, (Object)this.getLoyalty(stack));
        this.field_6011.method_12778(ENCHANTED, (Object)stack.method_7958());
        this.tridentStack = stack;
    }

    public DragonTridentEntity(class_1937 world, double x, double y, double z, class_1799 stack) {
        super(EntityInit.DRAGON_TRIDENT_ENTITY, x, y, z, world, stack, stack);
        this.field_6011.method_12778(LOYALTY, (Object)this.getLoyalty(stack));
        this.field_6011.method_12778(ENCHANTED, (Object)stack.method_7958());
        this.tridentStack = stack;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(LOYALTY, (Object)0);
        builder.method_56912(ENCHANTED, (Object)false);
    }

    public void method_5773() {
        if (this.field_7576 > 4) {
            this.dealtDamage = true;
        }
        class_1297 entity = this.method_24921();
        if ((this.dealtDamage || this.method_7441()) && entity != null) {
            byte i = (Byte)this.field_6011.method_12789(LOYALTY);
            if (i > 0 && !this.isOwnerAlive()) {
                if (!this.method_37908().method_8608() && this.field_7572 == class_1665.class_1666.field_7593) {
                    this.method_5699(this.method_7445(), 0.1f);
                }
                this.method_31472();
            } else if (i > 0) {
                this.method_7433(true);
                class_243 vec3d = new class_243(entity.method_23317() - this.method_23317(), entity.method_23320() - this.method_23318(), entity.method_23321() - this.method_23321());
                this.method_23327(this.method_23317(), this.method_23318() + vec3d.field_1351 * 0.015 * (double)i, this.method_23321());
                if (this.method_37908().method_8608()) {
                    this.field_5971 = this.method_23318();
                }
                double d = 0.05 * (double)i;
                this.method_18799(this.method_18798().method_1021(0.95).method_1019(vec3d.method_1029().method_1021(d)));
                if (this.returnTimer == 0) {
                    this.method_5783(class_3417.field_14698, 10.0f, 1.0f);
                }
                ++this.returnTimer;
            }
        }
        super.method_5773();
    }

    private boolean isOwnerAlive() {
        class_1297 entity = this.method_24921();
        if (entity != null && entity.method_5805()) {
            return !(entity instanceof class_3222) || !entity.method_7325();
        }
        return false;
    }

    protected class_1799 method_7445() {
        if (this.tridentStack == null || this.tridentStack.method_7960()) {
            this.tridentStack = new class_1799((class_1935)ItemInit.DRAGON_TRIDENT);
        }
        return this.tridentStack.method_7972();
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isEnchanted() {
        return (Boolean)this.field_6011.method_12789(ENCHANTED);
    }

    @Nullable
    protected class_3966 method_7434(class_243 currentPosition, class_243 nextPosition) {
        return this.dealtDamage ? null : super.method_7434(currentPosition, nextPosition);
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_3218 serverWorld;
        class_1297 entity = entityHitResult.method_17782();
        float f = 8.0f;
        class_1297 entity2 = this.method_24921();
        class_1282 damageSource = this.method_48923().method_48799((class_1297)this, (class_1297)(entity2 == null ? this : entity2));
        class_1937 world = this.method_37908();
        if (world instanceof class_3218) {
            serverWorld = (class_3218)world;
            f = class_1890.method_60120((class_3218)serverWorld, (class_1799)this.method_59958(), (class_1297)entity, (class_1282)damageSource, (float)f);
        }
        this.dealtDamage = true;
        if (entity.method_5643(damageSource, f)) {
            if (entity.method_5864() == class_1299.field_6091) {
                return;
            }
            world = this.method_37908();
            if (world instanceof class_3218) {
                serverWorld = (class_3218)world;
                class_1890.method_60619((class_3218)serverWorld, (class_1297)entity, (class_1282)damageSource, (class_1799)this.method_59958());
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                this.method_59957(livingEntity, damageSource);
                this.method_7450(livingEntity);
            }
        }
        this.method_18799(this.method_18798().method_18805(-0.01, -0.1, -0.01));
        this.method_5783(class_3417.field_15213, 1.0f, 1.0f);
    }

    protected class_3414 method_7440() {
        return class_3417.field_15104;
    }

    public void method_5694(class_1657 player) {
        class_1297 entity = this.method_24921();
        if (entity == null || entity.method_5667() == player.method_5667()) {
            super.method_5694(player);
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.dealtDamage = tag.method_10577("DealtDamage");
        this.field_6011.method_12778(LOYALTY, (Object)this.getLoyalty(this.method_54759()));
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("DealtDamage", this.dealtDamage);
    }

    public void method_7446() {
        byte i = (Byte)this.field_6011.method_12789(LOYALTY);
        if (this.field_7572 != class_1665.class_1666.field_7593 || i <= 0) {
            super.method_7446();
        }
    }

    protected float method_7436() {
        return 0.99f;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_5727(double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    protected class_1799 method_57314() {
        return new class_1799((class_1935)ItemInit.DRAGON_TRIDENT);
    }

    public class_1799 method_59958() {
        if (this.tridentStack == null || this.tridentStack.method_7960()) {
            this.tridentStack = new class_1799((class_1935)ItemInit.DRAGON_TRIDENT);
        }
        return this.tridentStack.method_7972();
    }

    private byte getLoyalty(class_1799 stack) {
        class_1937 world = this.method_37908();
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            return (byte)class_3532.method_15340((int)class_1890.method_60169((class_3218)serverWorld, (class_1799)stack, (class_1297)this), (int)0, (int)127);
        }
        return 0;
    }
}

