/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful;

import com.github.thedeathlycow.scorchful.api.ServerThirstPlugin;
import com.github.thedeathlycow.scorchful.block.NetherLilyBehaviours;
import com.github.thedeathlycow.scorchful.block.SandCauldronBehaviours;
import com.github.thedeathlycow.scorchful.compat.DehydrationServerThirstPlugin;
import com.github.thedeathlycow.scorchful.compat.ScorchfulIntegrations;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.event.ScorchfulItemEvents;
import com.github.thedeathlycow.scorchful.item.DrinkItem;
import com.github.thedeathlycow.scorchful.item.FireChargeThrower;
import com.github.thedeathlycow.scorchful.item.HeatResistanceHelper;
import com.github.thedeathlycow.scorchful.item.component.DrinkLevelComponent;
import com.github.thedeathlycow.scorchful.item.enchantment.EnchantmentModifiers;
import com.github.thedeathlycow.scorchful.item.loot.TurtleScuteLootTableModifier;
import com.github.thedeathlycow.scorchful.registry.SArmorMaterials;
import com.github.thedeathlycow.scorchful.registry.SBlockEntityTypes;
import com.github.thedeathlycow.scorchful.registry.SBlocks;
import com.github.thedeathlycow.scorchful.registry.SDataComponentTypes;
import com.github.thedeathlycow.scorchful.registry.SEntityAttributes;
import com.github.thedeathlycow.scorchful.registry.SEntityTypes;
import com.github.thedeathlycow.scorchful.registry.SHeatVisions;
import com.github.thedeathlycow.scorchful.registry.SItemGroups;
import com.github.thedeathlycow.scorchful.registry.SItems;
import com.github.thedeathlycow.scorchful.registry.SParticleTypes;
import com.github.thedeathlycow.scorchful.registry.SPotions;
import com.github.thedeathlycow.scorchful.registry.SSoundEvents;
import com.github.thedeathlycow.scorchful.registry.SStats;
import com.github.thedeathlycow.scorchful.registry.SStatusEffects;
import com.github.thedeathlycow.scorchful.registry.STemperatureEffects;
import com.github.thedeathlycow.scorchful.registry.tag.SDamageTypeTags;
import com.github.thedeathlycow.scorchful.registry.tag.SItemTags;
import com.github.thedeathlycow.scorchful.server.ThirstCommand;
import com.github.thedeathlycow.scorchful.server.network.TemperatureSoundEventPacket;
import com.github.thedeathlycow.scorchful.temperature.AmbientTemperatureController;
import com.github.thedeathlycow.scorchful.temperature.AttributeController;
import com.github.thedeathlycow.scorchful.temperature.WetTickController;
import com.github.thedeathlycow.scorchful.worldgen.NetherBiomeModifications;
import com.github.thedeathlycow.thermoo.api.armor.material.ArmorMaterialEvents;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingMode;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentControllerInitializeEvent;
import com.github.thedeathlycow.thermoo.api.temperature.event.PlayerEnvironmentEvents;
import com.mojang.brigadier.CommandDispatcher;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scorchful
implements ModInitializer {
    public static final String MODID = "scorchful";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"scorchful");
    public static final int CONFIG_VERSION = 5;
    private static ConfigHolder<ScorchfulConfig> configHolder = null;

    @Contract(value="_->new")
    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MODID, (String)path);
    }

    public void onInitialize() {
        AutoConfig.register(ScorchfulConfig.class, GsonConfigSerializer::new);
        configHolder = AutoConfig.getConfigHolder(ScorchfulConfig.class);
        ScorchfulConfig.updateConfig(configHolder);
        SBlocks.registerBlocks();
        SBlockEntityTypes.registerAll();
        SArmorMaterials.initialize();
        SDataComponentTypes.initialize();
        SItems.registerItems();
        SItemGroups.registerAll();
        SEntityTypes.registerAll();
        SSoundEvents.registerAll();
        STemperatureEffects.registerAll();
        SStatusEffects.initialize();
        SEntityAttributes.initialize();
        SParticleTypes.registerAll();
        NetherBiomeModifications.placeFeaturesInBiomes();
        SStats.registerAll();
        SandCauldronBehaviours.registerAll();
        NetherLilyBehaviours.registerBehaviours();
        SHeatVisions.initialize();
        SPotions.initialize();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> ThirstCommand.register((CommandDispatcher<class_2168>)dispatcher));
        if (ScorchfulIntegrations.isDehydrationLoaded() && !ServerThirstPlugin.isCustomPluginLoaded()) {
            LOGGER.debug("Applying Dehydration thirst plugin");
            ServerThirstPlugin.registerPlugin(new DehydrationServerThirstPlugin());
        }
        UseItemCallback.EVENT.register((Object)new FireChargeThrower());
        ScorchfulItemEvents.GET_DEFAULT_STACK.register(DrinkLevelComponent::applyToNewStack);
        ScorchfulItemEvents.CONSUME_ITEM.register(DrinkItem::applyWater);
        ScorchfulItemEvents.CONSUME_ITEM.register((stack, player) -> {
            if (stack.method_31573(SItemTags.IS_COOLING_FOOD)) {
                player.thermoo$addTemperature(Scorchful.getConfig().heatingConfig.getTemperatureFromCoolingFood(), (HeatingMode)HeatingModes.ACTIVE);
            }
        });
        ArmorMaterialEvents.GET_HEAT_RESISTANCE.register(HeatResistanceHelper::getHeatResistance);
        ServerLivingEntityEvents.AFTER_DAMAGE.register((entity, source, baseDamageTaken, damageTaken, blocked) -> {
            if (!blocked && source.method_48789(SDamageTypeTags.FIREBALL)) {
                entity.thermoo$addTemperature(Scorchful.getConfig().heatingConfig.getFireballHeat(), (HeatingMode)HeatingModes.ACTIVE);
            }
        });
        this.registerThermooEventListeners();
        LootTableEvents.MODIFY.register((Object)new TurtleScuteLootTableModifier());
        EnchantmentModifiers.initialize();
        PayloadTypeRegistry.playS2C().register(TemperatureSoundEventPacket.PACKET_ID, TemperatureSoundEventPacket.PACKET_CODEC);
        LOGGER.info("Scorchful initialized!");
    }

    @NotNull
    public static ScorchfulConfig getConfig() {
        return (ScorchfulConfig)configHolder.getConfig();
    }

    private void registerThermooEventListeners() {
        PlayerEnvironmentEvents.CAN_APPLY_PASSIVE_TEMPERATURE_CHANGE.register((change, player) -> {
            if (change <= 0) {
                return TriState.DEFAULT;
            }
            ScorchfulConfig config = Scorchful.getConfig();
            int tickInterval = config.heatingConfig.getPassiveHeatingTickInterval();
            if (tickInterval > 1 && player.field_6012 % tickInterval != 0) {
                return TriState.FALSE;
            }
            if (!config.heatingConfig.doPassiveHeating()) {
                return TriState.FALSE;
            }
            return TriState.of((player.thermoo$getTemperatureScale() < config.heatingConfig.getMaxPassiveHeatingScale() ? 1 : 0) != 0);
        });
        EnvironmentControllerInitializeEvent.EVENT.register(AttributeController::new);
        EnvironmentControllerInitializeEvent.EVENT.register(AmbientTemperatureController::new);
        EnvironmentControllerInitializeEvent.EVENT.register(WetTickController::new);
    }
}

