/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.init;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.levelz.access.LevelManagerAccess;
import net.levelz.access.ServerPlayerSyncAccess;
import net.levelz.init.CriteriaInit;
import net.levelz.level.LevelManager;
import net.levelz.level.Skill;
import net.levelz.util.LevelHelper;
import net.levelz.util.PacketHelper;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_3222;
import net.minecraft.class_9015;
import org.apache.commons.lang3.StringUtils;

public class CommandInit {
    private static final SuggestionProvider<class_2168> SKILLS_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9264(LevelManager.SKILLS.values().stream().map(Skill::getKey), (SuggestionsBuilder)builder);

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"level").requires(serverCommandSource -> serverCommandSource.method_9259(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9247((String)"level").then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(commandContext -> CommandInit.executeSkillCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), "level", IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"level"), 0))))).then(class_2170.method_9247((String)"points").then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(commandContext -> CommandInit.executeSkillCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), "points", IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"level"), 0))))).then(class_2170.method_9244((String)"skillKey", (ArgumentType)StringArgumentType.string()).suggests(SKILLS_SUGGESTION_PROVIDER).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(commandContext -> CommandInit.executeSkillCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), StringArgumentType.getString((CommandContext)commandContext, (String)"skillKey"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"level"), 0))))).then(class_2170.method_9247((String)"experience").then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(commandContext -> CommandInit.executeSkillCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), "experience", IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"level"), 0)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").then(class_2170.method_9247((String)"level").then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(commandContext -> CommandInit.executeSkillCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), "level", IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"level"), 1))))).then(class_2170.method_9247((String)"points").then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(commandContext -> CommandInit.executeSkillCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), "points", IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"level"), 1))))).then(class_2170.method_9244((String)"skillKey", (ArgumentType)StringArgumentType.string()).suggests(SKILLS_SUGGESTION_PROVIDER).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(commandContext -> CommandInit.executeSkillCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), StringArgumentType.getString((CommandContext)commandContext, (String)"skillKey"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"level"), 1))))).then(class_2170.method_9247((String)"experience").then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(commandContext -> CommandInit.executeSkillCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), "experience", IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"level"), 1)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(class_2170.method_9247((String)"level").then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(commandContext -> CommandInit.executeSkillCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), "level", IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"level"), 2))))).then(class_2170.method_9247((String)"points").then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(commandContext -> CommandInit.executeSkillCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), "points", IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"level"), 2))))).then(class_2170.method_9244((String)"skillKey", (ArgumentType)StringArgumentType.string()).suggests(SKILLS_SUGGESTION_PROVIDER).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(commandContext -> CommandInit.executeSkillCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), StringArgumentType.getString((CommandContext)commandContext, (String)"skillKey"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"level"), 2))))).then(class_2170.method_9247((String)"experience").then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(commandContext -> CommandInit.executeSkillCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), "experience", IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"level"), 2)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"get").then(class_2170.method_9247((String)"level").executes(commandContext -> CommandInit.executeSkillCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), "level", 0, 3)))).then(class_2170.method_9247((String)"all").executes(commandContext -> CommandInit.executeSkillCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), "all", 0, 3)))).then(class_2170.method_9247((String)"points").executes(commandContext -> CommandInit.executeSkillCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), "points", 0, 3)))).then(class_2170.method_9244((String)"skillKey", (ArgumentType)StringArgumentType.string()).suggests(SKILLS_SUGGESTION_PROVIDER).executes(commandContext -> CommandInit.executeSkillCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), StringArgumentType.getString((CommandContext)commandContext, (String)"skillKey"), 0, 3)))).then(class_2170.method_9247((String)"experience").executes(commandContext -> CommandInit.executeSkillCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), "experience", 0, 3)))))));
    }

    private static int executeSkillCommand(class_2168 source, Collection<class_3222> targets, String skillKey, int i, int reference) {
        for (class_3222 serverPlayerEntity : targets) {
            LevelManager levelManager = ((LevelManagerAccess)serverPlayerEntity).getLevelManager();
            if (skillKey.equals("experience")) {
                if (reference == 0) {
                    ((ServerPlayerSyncAccess)serverPlayerEntity).addLevelExperience(i);
                } else if (reference == 1) {
                    int currentXP = (int)(levelManager.getLevelProgress() * (float)levelManager.getNextLevelExperience());
                    float oldProgress = levelManager.getLevelProgress();
                    levelManager.setLevelProgress(currentXP - i > 0 ? (float)(currentXP - 1) / (float)levelManager.getNextLevelExperience() : 0.0f);
                    levelManager.setTotalLevelExperience(currentXP - i > 0 ? levelManager.getTotalLevelExperience() - i : levelManager.getTotalLevelExperience() - (int)(oldProgress * (float)levelManager.getNextLevelExperience()));
                } else if (reference == 2) {
                    float oldProgress = levelManager.getLevelProgress();
                    levelManager.setLevelProgress(i >= levelManager.getNextLevelExperience() ? 1.0f : (float)i / (float)levelManager.getNextLevelExperience());
                    levelManager.setTotalLevelExperience((int)((float)levelManager.getTotalLevelExperience() - oldProgress * (float)levelManager.getNextLevelExperience() + levelManager.getLevelProgress() * (float)levelManager.getNextLevelExperience()));
                } else if (reference == 3) {
                    source.method_9226(() -> class_2561.method_43469((String)"commands.level.printProgress", (Object[])new Object[]{serverPlayerEntity.method_5476(), (int)(levelManager.getLevelProgress() * (float)levelManager.getNextLevelExperience()), levelManager.getNextLevelExperience()}), true);
                }
            } else {
                Skill skill = null;
                int playerSkillLevel = 0;
                if (skillKey.equals("points")) {
                    playerSkillLevel = levelManager.getSkillPoints();
                } else if (skillKey.equals("level")) {
                    playerSkillLevel = levelManager.getOverallLevel();
                } else {
                    for (Skill overallSkill : LevelManager.SKILLS.values()) {
                        if (!overallSkill.getKey().equals(skillKey)) continue;
                        playerSkillLevel = levelManager.getSkillLevel(overallSkill.getId());
                        skill = overallSkill;
                        break;
                    }
                    if (skill == null) {
                        source.method_9226(() -> class_2561.method_43471((String)"commands.level.failed"), false);
                        return 0;
                    }
                }
                if (reference == 0) {
                    playerSkillLevel += i;
                } else if (reference == 1) {
                    playerSkillLevel = Math.max(playerSkillLevel - i, 0);
                } else if (reference == 2) {
                    playerSkillLevel = i;
                } else if (reference == 3) {
                    if (skillKey.equals("all")) {
                        for (Skill overallSkill : LevelManager.SKILLS.values()) {
                            String finalSkill = overallSkill.getKey();
                            source.method_9226(() -> class_2561.method_43469((String)"commands.level.printLevel", (Object[])new Object[]{serverPlayerEntity.method_5476(), StringUtils.capitalize((String)finalSkill) + (finalSkill.equals("level") || finalSkill.equals("points") ? ":" : " Level:"), finalSkill.equals("level") ? levelManager.getOverallLevel() : (finalSkill.equals("points") ? levelManager.getSkillPoints() : levelManager.getSkillLevel(overallSkill.getId()))}), true);
                        }
                        continue;
                    }
                    String finalSkill = skillKey;
                    int finalPlayerSkillLevel = playerSkillLevel;
                    source.method_9226(() -> class_2561.method_43469((String)"commands.level.printLevel", (Object[])new Object[]{serverPlayerEntity.method_5476(), StringUtils.capitalize((String)finalSkill) + (finalSkill.equals("level") || finalSkill.equals("points") ? ":" : " Level:"), finalPlayerSkillLevel}), true);
                    continue;
                }
                if (skillKey.equals("points")) {
                    levelManager.setSkillPoints(playerSkillLevel);
                } else if (skillKey.equals("level")) {
                    levelManager.setOverallLevel(playerSkillLevel);
                    int level = playerSkillLevel;
                    serverPlayerEntity.method_7327().method_1162(CriteriaInit.LEVELZ, (class_9015)serverPlayerEntity, score -> score.method_55410(level));
                    serverPlayerEntity.field_13995.method_3760().method_14581((class_2596)new class_2703(class_2703.class_5893.field_29137, serverPlayerEntity));
                } else {
                    levelManager.setSkillLevel(skill.getId(), playerSkillLevel);
                    if (!skill.getAttributes().isEmpty()) {
                        LevelHelper.updateSkill(serverPlayerEntity, skill);
                    }
                }
            }
            PacketHelper.updateLevels(serverPlayerEntity);
            PacketHelper.updatePlayerSkills(serverPlayerEntity, null);
            if (reference == 3) continue;
            source.method_9226(() -> class_2561.method_43469((String)"commands.level.changed", (Object[])new Object[]{serverPlayerEntity.method_5476()}), true);
        }
        return targets.size();
    }
}

