/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.init;

import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.levelz.access.LevelManagerAccess;
import net.levelz.init.ConfigInit;
import net.levelz.init.CriteriaInit;
import net.levelz.level.LevelManager;
import net.levelz.level.Skill;
import net.levelz.mixin.entity.EntityAccessor;
import net.levelz.util.LevelHelper;
import net.levelz.util.PacketHelper;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_9014;
import net.minecraft.class_9015;

public class EventInit {
    public static void init() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            for (Skill skill : LevelManager.SKILLS.values()) {
                LevelHelper.updateSkill(handler.method_32311(), skill);
            }
            PacketHelper.updateSkills(handler.method_32311());
            PacketHelper.updatePlayerSkills(handler.method_32311(), null);
            PacketHelper.updateRestrictions(handler.method_32311());
        });
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> {
            PacketHelper.updatePlayerSkills(player, null);
            PacketHelper.updateLevels(player);
        });
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            PacketHelper.updatePlayerSkills(newPlayer, oldPlayer);
            PacketHelper.updateLevels(newPlayer);
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            if (ConfigInit.CONFIG.hardMode) {
                newPlayer.method_5682().method_3760().method_14581((class_2596)new class_2703(class_2703.class_5893.field_29137, newPlayer));
                newPlayer.method_7327().method_1162(CriteriaInit.LEVELZ, (class_9015)newPlayer, class_9014::method_55415);
            } else {
                PacketHelper.updatePlayerSkills(newPlayer, oldPlayer);
                if (ConfigInit.CONFIG.resetCurrentXp) {
                    LevelManager levelManager = ((LevelManagerAccess)newPlayer).getLevelManager();
                    levelManager.setLevelProgress(0.0f);
                    levelManager.setTotalLevelExperience(0);
                }
                PacketHelper.updateLevels(newPlayer);
                for (Skill skill : LevelManager.SKILLS.values()) {
                    LevelHelper.updateSkill(newPlayer, skill);
                }
            }
        });
        UseItemCallback.EVENT.register((player, world, hand) -> {
            LevelManager levelManager;
            if (!(player.method_7337() || player.method_7325() || (levelManager = ((LevelManagerAccess)player).getLevelManager()).hasRequiredItemLevel(player.method_5998(hand).method_7909()))) {
                player.method_7353((class_2561)class_2561.method_43471((String)"restriction.levelz.locked.tooltip").method_27692(class_124.field_1061), true);
                return class_1271.method_22431((Object)player.method_5998(hand));
            }
            return class_1271.method_22430((Object)class_1799.field_8037);
        });
        UseBlockCallback.EVENT.register((player, world, hand, result) -> {
            LevelManager levelManager;
            class_2338 blockPos;
            if (!player.method_7337() && !player.method_7325() && world.method_8505(player, blockPos = result.method_17777()) && !(levelManager = ((LevelManagerAccess)player).getLevelManager()).hasRequiredBlockLevel(world.method_8320(blockPos).method_26204())) {
                player.method_7353((class_2561)class_2561.method_43471((String)"restriction.levelz.locked.tooltip").method_27692(class_124.field_1061), true);
                return class_1269.method_29236((boolean)false);
            }
            return class_1269.field_5811;
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, entityHitResult) -> {
            LevelManager levelManager;
            if (!(player.method_7337() || player.method_7325() || entity.method_42148() && ((EntityAccessor)entity).callCanAddPassenger((class_1297)player) || (levelManager = ((LevelManagerAccess)player).getLevelManager()).hasRequiredEntityLevel(entity.method_5864()))) {
                player.method_7353((class_2561)class_2561.method_43471((String)"restriction.levelz.locked.tooltip").method_27692(class_124.field_1061), true);
                return class_1269.method_29236((boolean)false);
            }
            return class_1269.field_5811;
        });
    }
}

