/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.mixin.block;

import java.util.List;
import net.levelz.access.LevelManagerAccess;
import net.levelz.entity.LevelExperienceOrbEntity;
import net.levelz.init.ConfigInit;
import net.levelz.init.EntityInit;
import net.levelz.level.LevelManager;
import net.levelz.util.BonusHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_2248.class})
public class BlockMixin {
    @Unique
    @Nullable
    private class_3222 serverPlayerEntity = null;

    @Inject(method={"dropStacks(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/entity/BlockEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/item/ItemStack;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/Block;getDroppedStacks(Lnet/minecraft/block/BlockState;Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/entity/BlockEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/item/ItemStack;)Ljava/util/List;")}, cancellable=true)
    private static void dropStacksMixin(class_2680 state, class_1937 world, class_2338 pos, @Nullable class_2586 blockEntity, class_1297 entity, class_1799 stack, CallbackInfo info) {
        if (entity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)entity;
            if (playerEntity.method_7337()) {
                return;
            }
            if (!EntityInit.isRedstoneBitsLoaded || !entity.getClass().getName().contains("RedstoneBitsFakePlayer")) {
                LevelManager levelManager = ((LevelManagerAccess)playerEntity).getLevelManager();
                if (!levelManager.hasRequiredMiningLevel(state.method_26204())) {
                    info.cancel();
                } else if (!levelManager.hasRequiredItemLevel(stack.method_7909())) {
                    info.cancel();
                }
            }
        }
    }

    @Inject(method={"getDroppedStacks(Lnet/minecraft/block/BlockState;Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/entity/BlockEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/item/ItemStack;)Ljava/util/List;"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;getDroppedStacks(Lnet/minecraft/loot/context/LootContextParameterSet$Builder;)Ljava/util/List;")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private static void getDroppedStacksMixin(class_2680 state, class_3218 world, class_2338 pos, @Nullable class_2586 blockEntity, @Nullable class_1297 entity, class_1799 stack, CallbackInfoReturnable<List<class_1799>> info, class_8567.class_8568 builder) {
        if (entity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)entity;
            BonusHelper.miningDropChanceBonus(playerEntity, state, pos, builder);
        }
    }

    @Inject(method={"dropExperience"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/ExperienceOrbEntity;spawn(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/Vec3d;I)V")})
    protected void dropExperienceMixin(class_3218 world, class_2338 pos, int size, CallbackInfo info) {
        if (ConfigInit.CONFIG.oreXPMultiplier > 0.0f) {
            LevelExperienceOrbEntity.spawn(world, class_243.method_24953((class_2382)pos), (int)((float)size * ConfigInit.CONFIG.oreXPMultiplier * (ConfigInit.CONFIG.dropXPbasedOnLvl && this.serverPlayerEntity != null ? 1.0f + ConfigInit.CONFIG.basedOnMultiplier * (float)((LevelManagerAccess)this.serverPlayerEntity).getLevelManager().getOverallLevel() : 1.0f)));
        }
    }

    @Inject(method={"onBreak"}, at={@At(value="HEAD")})
    private void onBreakMixin(class_1937 world, class_2338 pos, class_2680 state, class_1657 player, CallbackInfoReturnable<class_2680> info) {
        if (!world.method_8608()) {
            this.serverPlayerEntity = (class_3222)player;
        }
    }
}

