/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import com.google.common.base.Predicates;
import com.tom.storagemod.inventory.IInventoryAccess;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.TransferApiImpl;
import net.minecraft.class_1799;

public class InventorySlot
implements Storage<ItemVariant> {
    private StorageView<ItemVariant> view;
    private Storage<ItemVariant> parent;
    private IInventoryAccess.IChangeNotifier ch;

    public InventorySlot(Storage<ItemVariant> parent, StorageView<ItemVariant> h, IInventoryAccess.IChangeNotifier notif) {
        this.parent = parent;
        this.ch = notif;
        this.view = h;
    }

    public class_1799 getStack() {
        return this.view == null ? class_1799.field_8037 : ((ItemVariant)this.view.getResource()).toStack((int)this.view.getAmount());
    }

    public class_1799 insert(class_1799 stack) {
        try (Transaction tr = Transaction.openOuter();){
            long ins = this.insert(ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)tr);
            if (ins == 0L) {
                class_1799 class_17992 = stack;
                return class_17992;
            }
            tr.commit();
            this.notifyChange();
            if (ins < (long)stack.method_7947()) {
                class_1799 class_17993 = stack.method_46651((int)((long)stack.method_7947() - ins));
                return class_17993;
            }
            class_1799 class_17994 = class_1799.field_8037;
            return class_17994;
        }
    }

    public class_1799 extract(int i) {
        if (this.view == null) {
            return class_1799.field_8037;
        }
        try (Transaction tr = Transaction.openOuter();){
            ItemVariant r = (ItemVariant)this.view.getResource();
            long ex = this.view.extract((Object)r, (long)i, (TransactionContext)tr);
            if (ex > 0L) {
                tr.commit();
                this.notifyChange();
                class_1799 class_17992 = r.toStack((int)ex);
                return class_17992;
            }
        }
        return class_1799.field_8037;
    }

    public boolean transferTo(int i, InventorySlot to) {
        try (Transaction tr = Transaction.openOuter();){
            long t = StorageUtil.move((Storage)this, (Storage)to, (Predicate)Predicates.alwaysTrue(), (long)i, (TransactionContext)tr);
            if (t > 0L) {
                this.notifyChange();
                to.notifyChange();
                tr.commit();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public StorageView<ItemVariant> getView() {
        return this.view;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StorageView<ItemVariant> storageView = this.view;
        if (storageView instanceof Storage) {
            Storage slot = (Storage)storageView;
            return slot.insert((Object)resource, maxAmount, transaction);
        }
        return StorageUtil.tryInsertStacking(this.parent, (Object)resource, (long)maxAmount, (TransactionContext)transaction);
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        return this.view == null ? 0L : this.view.extract((Object)resource, maxAmount, transaction);
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        if (this.view == null) {
            return Collections.emptyIterator();
        }
        return TransferApiImpl.singletonIterator(this.view);
    }

    private void notifyChange() {
        this.ch.onSlotChanged(this);
    }
}

