/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.widget;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TSliderWidget;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.enumerations.Direction2D;
import java.util.Objects;

@Virtual
public class TScrollBarWidget
extends TSliderWidget {
    protected final TPanelElement target;
    protected boolean isValueDirty = false;
    protected boolean isKnobSizeDirty = false;

    public TScrollBarWidget(int x, int y, int width, int height, TPanelElement target) {
        this(x, y, width, height, target, true);
    }

    public TScrollBarWidget(int x, int y, int width, int height, TPanelElement target, boolean autoSetScrollFlags) {
        super(x, y, width, height, null, 0.0);
        this.target = Objects.requireNonNull(target);
        boolean b = height >= width;
        this.setSliderDirection(b ? Direction2D.DOWN : Direction2D.RIGHT);
        if (autoSetScrollFlags) {
            int sf = this.target.getScrollFlags();
            this.target.setScrollFlags(b ? sf | 4 : sf | 2);
        }
        this.refreshKnobSize();
        this.refreshValue();
        TPanelElement.TPanelElementEvent_Scrolled onTargetScrollH = (element, scrollDelta) -> {
            if (this.getSliderDirection().isHorizontal()) {
                this.isValueDirty = true;
            }
        };
        TPanelElement.TPanelElementEvent_Scrolled onTargetScrollV = (element, scrollDelta) -> {
            if (this.getSliderDirection().isVertical()) {
                this.isValueDirty = true;
            }
        };
        TElement.TElementEvent_ChildAR onTargetChildAR = (element, child, repositioned) -> {
            this.isKnobSizeDirty = true;
            this.isValueDirty = true;
        };
        this.target.eScrolledHorizontally.register(onTargetScrollH);
        this.target.eScrolledVertically.register(onTargetScrollV);
        this.target.eChildAdded.register(onTargetChildAR);
        this.target.eChildRemoved.register(onTargetChildAR);
    }

    public final TPanelElement getTarget() {
        return this.target;
    }

    @Override
    @Virtual
    public void tick() {
        super.tick();
        if (this.isKnobSizeDirty) {
            this.refreshKnobSize();
        }
        if (this.isValueDirty) {
            this.refreshValue();
        }
    }

    public void refreshValue() {
        if (this.isDragging()) {
            return;
        }
        switch (this.getSliderDirection()) {
            case RIGHT: {
                this.setValue(this.getTarget().getHorizontalScrollAmount(), false);
                break;
            }
            case DOWN: {
                this.setValue(this.getTarget().getVerticalScrollAmount(), false);
                break;
            }
            case UP: {
                this.setValue(1.0 - this.getTarget().getVerticalScrollAmount(), false);
                break;
            }
            case LEFT: {
                this.setValue(1.0 - this.getTarget().getHorizontalScrollAmount(), false);
                break;
            }
        }
    }

    public void refreshKnobSize() {
        if (this.getSliderDirection().isHorizontal()) {
            this.setKnobSize((int)(this.getTarget().getHorizontalScrollKnobSize01() * (double)(this.getWidth() / 2)));
        } else {
            this.setKnobSize((int)(this.getTarget().getVerticalScrollKnobSize01() * (double)(this.getHeight() / 2)));
        }
    }

    @Override
    @Virtual
    public void setValue(double value, boolean applyValue) {
        super.setValue(value, applyValue);
        if (applyValue) {
            this.applyValueToScroll();
        }
    }

    protected final void applyValueToScroll() {
        double val = this.getValue();
        switch (this.getSliderDirection()) {
            case RIGHT: {
                this.target.setHorizontalScrollAmount(val);
                break;
            }
            case DOWN: {
                this.target.setVerticalScrollAmount(val);
                break;
            }
            case UP: {
                this.target.setVerticalScrollAmount(1.0 - val);
                break;
            }
            case LEFT: {
                this.target.setHorizontalScrollAmount(1.0 - val);
                break;
            }
        }
    }

    @Override
    @Virtual
    public boolean input(TInputContext inputContext) {
        if (super.input(inputContext)) {
            return true;
        }
        switch (inputContext.getInputType()) {
            case MOUSE_SCROLL: {
                boolean h = this.getSliderDirection().isHorizontal();
                int amount = (int)(h ? inputContext.getScrollAmount().x : inputContext.getScrollAmount().y);
                if (h) {
                    return this.target.inputHorizontalScroll(this.target.getScrollSensitivity() * amount);
                }
                return this.target.inputVerticalScroll(this.target.getScrollSensitivity() * amount);
            }
        }
        return false;
    }
}

