/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.event;

import io.github.thecsdev.tcdcommons.api.event.TEvent;
import java.util.List;
import java.util.Objects;

final class TEventImpl<T>
implements TEvent<T> {
    private final List<T> listeners;
    private final T invoker;

    public TEventImpl(List<T> listeners, T invoker) {
        this.listeners = Objects.requireNonNull(listeners);
        this.invoker = Objects.requireNonNull(invoker);
    }

    @Override
    public boolean register(T listener) {
        if (listener == null || this.isRegistered(listener)) {
            return false;
        }
        return this.listeners.add(listener);
    }

    @Override
    public boolean unregister(T listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public boolean isRegistered(T listener) {
        return this.listeners.contains(listener);
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    @Override
    public T invoker() {
        return this.invoker;
    }
}

