/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipe.handler.type.vanilla;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.impl.recipe.handler.helper.SmithingRecipeConflictChecker;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessSmithingTrimRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_5455;
import net.minecraft.class_8059;
import net.minecraft.class_8062;
import net.minecraft.class_8786;

@IRecipeHandler.For(value=class_8062.class)
public final class SmithingTrimRecipeHandler
implements IRecipeHandler<class_8062> {
    @Override
    public String dumpToCommandString(IRecipeManager<? super class_8062> manager, class_5455 registryAccess, class_8786<class_8062> holder) {
        class_8062 recipe = (class_8062)holder.comp_1933();
        return String.format("smithing.addTrimRecipe(%s, %s, %s, %s);", StringUtil.quoteAndEscape(holder.comp_1932()), IIngredient.fromIngredient(((AccessSmithingTrimRecipe)recipe).crafttweaker$getTemplate()).getCommandString(), IIngredient.fromIngredient(((AccessSmithingTrimRecipe)recipe).crafttweaker$getBase()).getCommandString(), IIngredient.fromIngredient(((AccessSmithingTrimRecipe)recipe).crafttweaker$getAddition()).getCommandString());
    }

    @Override
    public <U extends class_1860<?>> boolean doesConflict(IRecipeManager<? super class_8062> manager, class_8062 firstRecipe, U secondRecipe) {
        if (!(secondRecipe instanceof class_8059)) {
            return false;
        }
        return SmithingRecipeConflictChecker.doesConflict(manager, (class_8059)firstRecipe, (class_8059)GenericUtil.uncheck(secondRecipe));
    }

    @Override
    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super class_8062> manager, class_5455 registryAccess, class_8062 recipe) {
        AccessSmithingTrimRecipe access = (AccessSmithingTrimRecipe)recipe;
        IIngredient template = IIngredient.fromIngredient(access.crafttweaker$getTemplate());
        IIngredient base = IIngredient.fromIngredient(access.crafttweaker$getBase());
        IIngredient addition = IIngredient.fromIngredient(access.crafttweaker$getAddition());
        IDecomposedRecipe decomposed = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Input.INGREDIENTS, List.of(template, base, addition)).build();
        return Optional.of(decomposed);
    }

    @Override
    public Optional<class_8062> recompose(IRecipeManager<? super class_8062> manager, class_5455 registryAccess, IDecomposedRecipe recipe) {
        List<IIngredient> ingredients = recipe.getOrThrow(BuiltinRecipeComponents.Input.INGREDIENTS);
        if (ingredients.size() != 3) {
            throw new IllegalArgumentException("Invalid inputs: expected three ingredients for recipe, but got " + ingredients.size() + ": " + String.valueOf(ingredients));
        }
        if (ingredients.stream().anyMatch(IIngredient::isEmpty)) {
            throw new IllegalArgumentException("Invalid inputs: empty ingredients");
        }
        class_1856 template = ingredients.get(0).asVanillaIngredient();
        class_1856 base = ingredients.get(1).asVanillaIngredient();
        class_1856 addition = ingredients.get(2).asVanillaIngredient();
        return Optional.of(AccessSmithingTrimRecipe.crafttweaker$createSmithingTrimRecipe(template, base, addition));
    }
}

