/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.item.BaseItem;
import com.supermartijn642.simplemagnets.MagnetItem;
import com.supermartijn642.simplemagnets.SMConfig;
import com.supermartijn642.simplemagnets.gui.MagnetContainer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9331;

public class AdvancedMagnet
extends MagnetItem {
    public static final class_9331<Settings> SETTINGS = class_9331.method_57873().method_57881(RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("collectItems").forGetter(Settings::collectItems), (App)class_5699.field_33442.fieldOf("itemRange").forGetter(Settings::itemRange), (App)Codec.BOOL.fieldOf("collectXp").forGetter(Settings::collectXp), (App)class_5699.field_33442.fieldOf("xpRange").forGetter(Settings::xpRange), (App)Codec.BOOL.fieldOf("whitelist").forGetter(Settings::isWhitelist), (App)Codec.BOOL.fieldOf("filterDurability").forGetter(Settings::isFilterDurability), (App)class_5699.method_57155((Codec)class_1799.field_49747).listOf(9, 9).fieldOf("itemFilter").forGetter(s -> s.itemFilter.stream().map(Optional::ofNullable).toList())).apply((Applicative)instance, (a, b, c, d, e, f, filter) -> new Settings((boolean)a, (int)b, (boolean)c, (int)d, (boolean)e, (boolean)f, filter.stream().map(o -> o.orElse(null)).toList())))).method_57882((class_9139)new class_9139<class_9129, Settings>(){

        public void encode(class_9129 buffer, Settings settings) {
            buffer.method_52964(settings.collectItems);
            buffer.method_53002(settings.itemRange);
            buffer.method_52964(settings.collectXp);
            buffer.method_53002(settings.xpRange);
            buffer.method_52964(settings.isWhitelist);
            buffer.method_52964(settings.isFilterDurability);
            for (class_1799 stack : settings.itemFilter) {
                buffer.method_52964(stack != null);
                if (stack == null) continue;
                class_1799.field_48349.encode((Object)buffer, (Object)stack);
            }
        }

        public Settings decode(class_9129 buffer) {
            boolean collectItems = buffer.readBoolean();
            int itemRange = buffer.readInt();
            boolean collectXp = buffer.readBoolean();
            int xpRange = buffer.readInt();
            boolean isWhitelist = buffer.readBoolean();
            boolean isFilterDurability = buffer.readBoolean();
            List<class_1799> itemFilter = Arrays.asList(new class_1799[9]);
            for (int i = 0; i < itemFilter.size(); ++i) {
                if (!buffer.readBoolean()) continue;
                itemFilter.set(i, (class_1799)class_1799.field_48349.decode((Object)buffer));
            }
            return new Settings(collectItems, itemRange, collectXp, xpRange, isWhitelist, isFilterDurability, itemFilter);
        }
    }).method_57880();

    @Override
    public BaseItem.ItemUseResult interact(class_1799 stack, class_1657 player, class_1268 hand, class_1937 level) {
        int slot;
        if (!player.method_5715()) {
            return super.interact(stack, player, hand, level);
        }
        int n = slot = hand == class_1268.field_5808 ? player.method_31548().field_7545 : 40;
        if (!level.field_9236) {
            CommonUtils.openContainer((BaseContainer)new MagnetContainer(player, slot));
        }
        return BaseItem.ItemUseResult.success((class_1799)stack);
    }

    @Override
    protected boolean canPickupItems(class_1799 magnet) {
        return !magnet.method_57826(SETTINGS) || ((Settings)magnet.method_57824(SETTINGS)).collectItems();
    }

    @Override
    protected boolean canPickupStack(class_1799 magnet, class_1799 stack) {
        if (!magnet.method_57826(SETTINGS)) {
            return true;
        }
        Settings settings = (Settings)magnet.method_57824(SETTINGS);
        for (int slot = 0; slot < 9; ++slot) {
            class_1799 filterStack;
            if (settings.itemFilter.get(slot) == null || !class_1799.method_7984((class_1799)stack, (class_1799)(filterStack = settings.itemFilter.get(slot))) || settings.isFilterDurability && !class_1799.method_31577((class_1799)stack, (class_1799)filterStack)) continue;
            return settings.isWhitelist;
        }
        return !settings.isWhitelist;
    }

    @Override
    protected boolean canPickupXp(class_1799 magnet) {
        return !magnet.method_57826(SETTINGS) || ((Settings)magnet.method_57824(SETTINGS)).collectXp();
    }

    @Override
    protected int getRangeItems(class_1799 magnet) {
        return magnet.method_57826(SETTINGS) ? ((Settings)magnet.method_57824(SETTINGS)).itemRange() : SMConfig.advancedMagnetRange.get().intValue();
    }

    @Override
    protected int getRangeXp(class_1799 magnet) {
        return magnet.method_57826(SETTINGS) ? ((Settings)magnet.method_57824(SETTINGS)).xpRange() : SMConfig.advancedMagnetRange.get().intValue();
    }

    @Override
    protected class_2561 getTooltip() {
        return TextComponents.translation((String)"simplemagnets.advancedmagnet.info", (Object[])new Object[]{TextComponents.number((int)SMConfig.advancedMagnetMaxRange.get()).color(class_124.field_1065).get()}).color(class_124.field_1080).get();
    }

    public record Settings(boolean collectItems, int itemRange, boolean collectXp, int xpRange, boolean isWhitelist, boolean isFilterDurability, List<class_1799> itemFilter) {
        public static Settings defaultSettings() {
            return new Settings(true, SMConfig.advancedMagnetRange.get(), true, SMConfig.advancedMagnetRange.get(), false, false, Collections.unmodifiableList(Arrays.asList(new class_1799[9])));
        }

        public Settings collectItems(boolean value) {
            if (this.collectItems == value) {
                return this;
            }
            return new Settings(value, this.itemRange, this.collectXp, this.xpRange, this.isWhitelist, this.isFilterDurability, this.itemFilter);
        }

        public Settings itemRange(int value) {
            if (this.itemRange == value) {
                return this;
            }
            return new Settings(this.collectItems, value, this.collectXp, this.xpRange, this.isWhitelist, this.isFilterDurability, this.itemFilter);
        }

        public Settings collectXp(boolean value) {
            if (this.collectXp == value) {
                return this;
            }
            return new Settings(this.collectItems, this.itemRange, value, this.xpRange, this.isWhitelist, this.isFilterDurability, this.itemFilter);
        }

        public Settings xpRange(int value) {
            if (this.xpRange == value) {
                return this;
            }
            return new Settings(this.collectItems, this.itemRange, this.collectXp, value, this.isWhitelist, this.isFilterDurability, this.itemFilter);
        }

        public Settings whitelist(boolean value) {
            if (this.isWhitelist == value) {
                return this;
            }
            return new Settings(this.collectItems, this.itemRange, this.collectXp, this.xpRange, value, this.isFilterDurability, this.itemFilter);
        }

        public Settings filterDurability(boolean value) {
            if (this.isFilterDurability == value) {
                return this;
            }
            return new Settings(this.collectItems, this.itemRange, this.collectXp, this.xpRange, this.isWhitelist, value, this.itemFilter);
        }

        public Settings itemFilter(int index, class_1799 stack) {
            if (this.itemFilter.get(index) == null ? stack == null : stack != null && class_1799.method_31577((class_1799)this.itemFilter.get(index), (class_1799)stack)) {
                return this;
            }
            class_1799[] filter = Arrays.copyOf((class_1799[])this.itemFilter.toArray(class_1799[]::new), this.itemFilter.size());
            filter[index] = stack;
            return new Settings(this.collectItems, this.itemRange, this.collectXp, this.xpRange, this.isWhitelist, this.isFilterDurability, Collections.unmodifiableList(Arrays.asList(filter)));
        }
    }
}

