/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.entity;

import me.chrr.camerapture.Camerapture;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1530;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public abstract class ResizableDecorationEntity
extends class_1297 {
    public static final double THICKNESS = 0.0625;
    private static final class_2940<Integer> FRAME_WIDTH = class_2945.method_12791(ResizableDecorationEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> FRAME_HEIGHT = class_2945.method_12791(ResizableDecorationEntity.class, (class_2941)class_2943.field_13327);
    private class_2350 facing = class_2350.field_11035;
    private class_2338 attachmentPos;
    private int obstructionCheckCounter = 0;

    public ResizableDecorationEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(FRAME_WIDTH, (Object)1);
        builder.method_56912(FRAME_HEIGHT, (Object)1);
    }

    public void method_5674(class_2940<?> data) {
        if (data.equals(FRAME_WIDTH) || data.equals(FRAME_HEIGHT)) {
            this.updateBoundingBox();
        }
    }

    public void resetObstructionCheckCounter() {
        this.obstructionCheckCounter = 0;
    }

    public void method_5773() {
        if (this.method_37908() instanceof class_3218 && Camerapture.CONFIG_MANAGER.getConfig().server.checkFramePosition && this.obstructionCheckCounter++ == 100) {
            this.obstructionCheckCounter = 0;
            if (!this.canStayAttached() && !this.method_31481()) {
                this.method_31472();
                this.onBreak(null);
            }
        }
    }

    public class_2338 getAttachmentPos() {
        return this.attachmentPos;
    }

    public void setAttachmentPos(class_2338 attachmentPos) {
        this.attachmentPos = attachmentPos;
        this.updateBoundingBox();
    }

    public class_2350 method_58149() {
        return this.facing;
    }

    public void setFacing(class_2350 facing) {
        this.facing = facing;
        this.method_36456(this.facing.method_10161() * 90);
        this.field_5982 = this.method_36454();
        this.updateBoundingBox();
    }

    public int getFrameWidth() {
        return (Integer)this.method_5841().method_12789(FRAME_WIDTH);
    }

    public void setFrameWidth(int width) {
        this.method_5841().method_12778(FRAME_WIDTH, (Object)width);
        this.updateBoundingBox();
    }

    public int getFrameHeight() {
        return (Integer)this.method_5841().method_12789(FRAME_HEIGHT);
    }

    public void setFrameHeight(int height) {
        this.method_5841().method_12778(FRAME_HEIGHT, (Object)height);
        this.updateBoundingBox();
    }

    protected void updateBoundingBox() {
        if (this.facing == null) {
            return;
        }
        class_243 center = this.attachmentPos.method_46558();
        center = center.method_1020(new class_243((double)this.facing.method_10148(), 0.0, (double)this.facing.method_10165()).method_1021(0.46875));
        this.method_23327(center.field_1352, center.field_1351, center.field_1350);
        class_2350 parallel = this.facing.method_10160();
        if (this.facing.method_10166() == class_2350.class_2351.field_11051) {
            class_243 p1 = center.method_1023((double)parallel.method_10148() * 0.5, 0.5, 0.03125);
            class_243 p2 = p1.method_1031((double)(parallel.method_10148() * this.getFrameWidth()), (double)this.getFrameHeight(), 0.0625);
            this.method_5857(new class_238(p1, p2));
        } else {
            class_243 p1 = center.method_1023(0.03125, 0.5, (double)parallel.method_10165() * 0.5);
            class_243 p2 = p1.method_1031(0.0625, (double)this.getFrameHeight(), (double)(parallel.method_10165() * this.getFrameWidth()));
            this.method_5857(new class_238(p1, p2));
        }
        this.resetObstructionCheckCounter();
    }

    public class_2350 method_5735() {
        return this.method_58149();
    }

    public boolean method_5863() {
        return true;
    }

    public boolean canStayAttached() {
        if (!Camerapture.CONFIG_MANAGER.getConfig().server.checkFramePosition) {
            return true;
        }
        if (!this.method_37908().method_17892((class_1297)this)) {
            return false;
        }
        class_2338 blockPos = this.attachmentPos.method_10093(this.facing.method_10153());
        class_2350 direction = this.facing.method_10160();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int x = 0; x < this.getFrameWidth(); ++x) {
            for (int y = 0; y < this.getFrameHeight(); ++y) {
                mutable.method_10101((class_2382)blockPos).method_10104(direction, x).method_10104(class_2350.field_11036, y);
                class_2680 blockState = this.method_37908().method_8320((class_2338)mutable);
                if (blockState.method_51367() || class_2312.method_9999((class_2680)blockState)) continue;
                return false;
            }
        }
        return this.method_37908().method_8333((class_1297)this, this.method_5829(), entity -> entity instanceof class_1530 || entity instanceof ResizableDecorationEntity).isEmpty();
    }

    public boolean method_5698(class_1297 attacker) {
        if (attacker instanceof class_1657) {
            class_1657 playerEntity = (class_1657)attacker;
            return !this.method_37908().method_8505(playerEntity, this.method_24515()) || this.method_5643(this.method_48923().method_48802(playerEntity), 0.0f);
        }
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (!this.method_31481() && !this.method_37908().field_9236) {
            this.method_5768();
            this.method_5785();
            this.onBreak(source.method_5529());
        }
        return true;
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        if (this.method_37908() instanceof class_3218 && !this.method_31481() && movement.method_1027() > 0.0) {
            this.method_5768();
            this.onBreak(null);
        }
    }

    public void method_5762(double deltaX, double deltaY, double deltaZ) {
        if (this.method_37908() instanceof class_3218 && !this.method_31481() && deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ > 0.0) {
            this.method_5768();
            this.onBreak(null);
        }
    }

    public void method_5814(double x, double y, double z) {
        this.attachmentPos = class_2338.method_49637((double)x, (double)y, (double)z);
        this.updateBoundingBox();
        this.field_6007 = true;
    }

    public float method_5832(class_2470 rotation) {
        switch (rotation) {
            case field_11464: {
                this.setFacing(this.method_58149().method_10153());
                break;
            }
            case field_11465: {
                this.setFacing(this.method_58149().method_10160());
                break;
            }
            case field_11463: {
                this.setFacing(this.method_58149().method_10170());
            }
        }
        return switch (rotation) {
            case class_2470.field_11464 -> this.method_36454() + 180.0f;
            case class_2470.field_11465 -> this.method_36454() + 90.0f;
            case class_2470.field_11463 -> this.method_36454() + 270.0f;
            default -> this.method_36454();
        };
    }

    public class_1542 method_5699(class_1799 stack, float yOffset) {
        class_243 center = this.method_5829().method_1005();
        class_1542 itemEntity = new class_1542(this.method_37908(), center.field_1352 + (double)((float)this.method_58149().method_10148() * 0.15f), center.field_1351 + (double)yOffset, center.field_1350 + (double)((float)this.method_58149().method_10165() * 0.15f), stack);
        itemEntity.method_6988();
        this.method_37908().method_8649((class_1297)itemEntity);
        return itemEntity;
    }

    protected boolean method_5638() {
        return false;
    }

    public void method_5652(class_2487 nbt) {
        nbt.method_10569("TileX", this.attachmentPos.method_10263());
        nbt.method_10569("TileY", this.attachmentPos.method_10264());
        nbt.method_10569("TileZ", this.attachmentPos.method_10260());
        nbt.method_10567("Facing", (byte)this.method_58149().method_10146());
        nbt.method_10569("Width", this.getFrameWidth());
        nbt.method_10569("Height", this.getFrameHeight());
    }

    public void method_5749(class_2487 nbt) {
        class_2338 blockPos = new class_2338(nbt.method_10550("TileX"), nbt.method_10550("TileY"), nbt.method_10550("TileZ"));
        if (!blockPos.method_19771((class_2382)this.method_24515(), 16.0)) {
            Camerapture.LOGGER.error("hanging entity at invalid position: {}", (Object)blockPos);
        } else {
            this.attachmentPos = blockPos;
        }
        this.setFacing(class_2350.method_10143((int)nbt.method_10571("Facing")));
        this.setFrameWidth(nbt.method_10550("Width"));
        this.setFrameHeight(nbt.method_10550("Height"));
        this.updateBoundingBox();
    }

    public float method_5763(class_2415 mirror) {
        return this.method_5832(mirror.method_10345(this.method_58149()));
    }

    public void method_5800(class_3218 world, class_1538 lightning) {
    }

    public void method_18382() {
    }

    public abstract void onPlace();

    public abstract void onBreak(@Nullable class_1297 var1);
}

