/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.gui;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.gui.InGameScreen;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.picture.RemotePicture;
import me.chrr.camerapture.util.PictureDrawingUtil;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class PictureScreen
extends InGameScreen {
    public static final int MAX_BAR_WIDTH = 360;
    public static final int BORDER_THICKNESS = 24;
    private List<class_1799> pictures;
    private int index = 0;
    private RemotePicture picture;
    private class_2561 pageNumber;
    private class_2561 customName;
    private boolean ctrlHeld = false;

    public PictureScreen(List<class_1799> pictures) {
        super((class_2561)class_2561.method_43471((String)"item.camerapture.picture"));
        this.pictures = pictures;
        this.forceRefresh();
    }

    protected void method_25426() {
        super.method_25426();
        if (!this.isSinglePicture()) {
            int barWidth = Math.min(360, this.field_22789 - 48);
            int barX = this.field_22789 / 2 - barWidth / 2;
            int barY = this.field_22790 - 24 - 20;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u2190"), button -> this.changeIndexBy(-1)).method_46434(barX, barY, 20, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u2192"), button -> this.changeIndexBy(1)).method_46434(barX + barWidth - 20, barY, 20, 20).method_46431());
        }
    }

    @Override
    public void renderScreen(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.isSinglePicture()) {
            int barY = this.field_22790 - 24 - 10;
            int pageNumberX = this.field_22789 / 2 - this.field_22793.method_27525((class_5348)this.pageNumber) / 2;
            if (this.customName != null) {
                int nameX = this.field_22789 / 2 - this.field_22793.method_27525((class_5348)this.customName) / 2;
                Objects.requireNonNull(this.field_22793);
                context.method_51439(this.field_22793, this.customName, nameX, barY - 1 - 9, 0xFFFFFF, false);
                context.method_51439(this.field_22793, this.pageNumber, pageNumberX, barY + 1, 0xFFFFFF, false);
            } else {
                Objects.requireNonNull(this.field_22793);
                context.method_51439(this.field_22793, this.pageNumber, pageNumberX, barY - 9 / 2, 0xFFFFFF, false);
            }
        }
        if (this.picture == null) {
            return;
        }
        if (this.ctrlHeld) {
            class_5250 text = class_2561.method_43471((String)"text.camerapture.save_as").method_27692(class_124.field_1080);
            int tw = this.field_22793.method_27525((class_5348)text);
            int n = this.field_22789 / 2 - tw / 2;
            Objects.requireNonNull(this.field_22793);
            context.method_51439(this.field_22793, (class_2561)text, n, 24 - 9 - 2, 0xFFFFFF, false);
        }
        int bottomOffset = this.isSinglePicture() ? 0 : 24;
        PictureDrawingUtil.drawPicture(context, this.field_22793, this.picture, 24, 24, this.field_22789 - 48, this.field_22790 - 48 - bottomOffset);
    }

    @Nullable
    public class_1011 getNativeImage() {
        if (this.field_22787 == null || this.picture == null || this.picture.getStatus() != RemotePicture.Status.SUCCESS) {
            return null;
        }
        class_1044 texture = this.field_22787.method_1531().method_4619(this.picture.getTextureIdentifier());
        if (!(texture instanceof class_1043)) {
            return null;
        }
        class_1043 backedTexture = (class_1043)texture;
        return backedTexture.method_4525();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 341) {
            this.ctrlHeld = true;
        } else if (keyCode == 83 && (modifiers & 2) != 0) {
            class_1011 image = this.getNativeImage();
            if (image != null) {
                this.saveAs(image);
                return true;
            }
        } else {
            if (keyCode == 263) {
                this.changeIndexBy(-1);
                return true;
            }
            if (keyCode == 262) {
                this.changeIndexBy(1);
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 341) {
            this.ctrlHeld = false;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.changeIndexBy((int)(-verticalAmount));
        return true;
    }

    public void changeIndexBy(int delta) {
        if (!this.pictures.isEmpty()) {
            this.index = Math.floorMod(this.index + delta, this.pictures.size());
            this.forceRefresh();
        }
    }

    public void setPictures(List<class_1799> pictures) {
        this.pictures = pictures;
        this.index = 0;
        this.method_41843();
        this.forceRefresh();
    }

    private void forceRefresh() {
        this.pageNumber = class_2561.method_43470((String)(this.index + 1 + " / " + this.pictures.size())).method_27692(class_124.field_1080);
        if (this.index >= this.pictures.size()) {
            this.picture = null;
            this.customName = null;
            return;
        }
        class_1799 stack = this.pictures.get(this.index);
        PictureItem.PictureData pictureData = PictureItem.getPictureData(stack);
        if (pictureData == null) {
            return;
        }
        this.picture = ClientPictureStore.getInstance().ensureRemotePicture(pictureData.id());
        this.customName = (class_2561)stack.method_57824(class_9334.field_49631);
    }

    private boolean isSinglePicture() {
        return this.pictures.size() == 1;
    }

    private void saveAs(class_1011 image) {
        new Thread(() -> {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer filter = stack.mallocPointer(1);
                filter.put(stack.UTF8((CharSequence)"png"));
                filter.flip();
                String path = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)"Save Picture", (CharSequence)"picture.png", (PointerBuffer)filter, (CharSequence)"*.png");
                if (path == null) {
                    return;
                }
                try {
                    image.method_4314(Path.of(path, new String[0]));
                }
                catch (IOException e) {
                    Camerapture.LOGGER.error("failed to save picture to disk", (Throwable)e);
                }
            }
        }, "Save prompter").start();
    }
}

