/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import immersive_aircraft.Main;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_aircraft.item.upgrade.VehicleUpgrade;
import immersive_aircraft.item.upgrade.VehicleUpgradeRegistry;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class UpgradeDataLoader
extends class_4309 {
    public UpgradeDataLoader() {
        super(new Gson(), "aircraft_upgrades");
    }

    @NotNull
    static VehicleUpgrade getAircraftUpgrade(JsonObject jsonObject) {
        VehicleUpgrade upgrade = new VehicleUpgrade();
        for (String key : jsonObject.keySet()) {
            VehicleStat stat = VehicleStat.STATS.get(key);
            if (stat == null) continue;
            upgrade.set(stat, jsonObject.get(key).getAsFloat());
        }
        return upgrade;
    }

    protected void apply(Map<class_2960, JsonElement> jsonMap, class_3300 manager, class_3695 profiler) {
        VehicleUpgradeRegistry.INSTANCE.reset();
        jsonMap.forEach((identifier, jsonElement) -> {
            try {
                if (class_7923.field_41178.method_10250(identifier)) {
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(identifier);
                    VehicleUpgrade upgrade = UpgradeDataLoader.getAircraftUpgrade(jsonElement.getAsJsonObject());
                    VehicleUpgradeRegistry.INSTANCE.setUpgrade(item, upgrade);
                } else {
                    Main.LOGGER.error("There is no item {} to make it an upgrade!", identifier);
                }
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                Main.LOGGER.error("Parsing error on aircraft upgrade {}: {}", identifier, (Object)exception.getMessage());
            }
        });
    }
}

