/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.compat.CompatInfo;
import net.p3pp3rf1y.sophisticatedcore.compat.ICompat;

public class CompatRegistry {
    private static final Map<String, CompatRegistry> compatRegistries = new ConcurrentHashMap<String, CompatRegistry>();
    private final Map<CompatInfo, List<Supplier<ICompat>>> compatFactories = new ConcurrentHashMap<CompatInfo, List<Supplier<ICompat>>>();
    private final Map<CompatInfo, List<ICompat>> loadedCompats = new ConcurrentHashMap<CompatInfo, List<ICompat>>();

    public static CompatRegistry getRegistry(String identifier) {
        return compatRegistries.computeIfAbsent(identifier, key -> new CompatRegistry());
    }

    protected CompatRegistry() {
    }

    public void registerCompat(CompatInfo info, Supplier<ICompat> factory) {
        this.compatFactories.computeIfAbsent(info, k -> new ArrayList()).add(factory);
    }

    public void setupCompats() {
        this.loadedCompats.values().forEach(compats -> compats.forEach(ICompat::setup));
    }

    public void initCompats() {
        this.compatFactories.forEach((compatInfo, factories) -> {
            if (compatInfo.isLoaded()) {
                factories.forEach(factory -> {
                    try {
                        this.loadedCompats.computeIfAbsent((CompatInfo)compatInfo, k -> new ArrayList()).add((ICompat)factory.get());
                    }
                    catch (Exception e) {
                        SophisticatedCore.LOGGER.error("Error instantiating compatibility ", (Throwable)e);
                    }
                });
            }
        });
        this.loadedCompats.values().forEach(compats -> compats.forEach(ICompat::init));
    }

    @Nullable
    public static VersionPredicate fromSpec(String spec) {
        try {
            return VersionPredicate.parse((String)spec);
        }
        catch (VersionParsingException e) {
            return null;
        }
    }
}

