/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.voiding;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.p3pp3rf1y.sophisticatedcore.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IOverflowResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ISlotLimitUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeItem;

public class VoidUpgradeWrapper
extends UpgradeWrapperBase<VoidUpgradeWrapper, VoidUpgradeItem>
implements IInsertResponseUpgrade,
IFilteredUpgrade,
ISlotChangeResponseUpgrade,
ITickableUpgrade,
IOverflowResponseUpgrade,
ISlotLimitUpgrade {
    private final FilterLogic filterLogic;
    private final Set<Integer> slotsToVoid = new HashSet<Integer>();
    private boolean shouldVoidOverflow;

    public VoidUpgradeWrapper(IStorageWrapper storageWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((VoidUpgradeItem)this.upgradeItem).getFilterSlotCount(), ModCoreDataComponents.FILTER_ATTRIBUTES);
        this.filterLogic.setAllowByDefault(true);
        this.setShouldVoidOverflowDefaultOrLoadFromNbt(false);
    }

    @Override
    public class_1799 onBeforeInsert(IItemHandlerSimpleInserter inventoryHandler, int slot, class_1799 stack, boolean simulate) {
        if (this.shouldVoidOverflow && inventoryHandler.getStackInSlot(slot).method_7960() && (!this.filterLogic.shouldMatchComponents() || !this.filterLogic.shouldMatchDurability() || this.filterLogic.getPrimaryMatch() != PrimaryMatch.ITEM) && this.filterLogic.matchesFilter(stack)) {
            for (int s = 0; s < inventoryHandler.getSlotCount(); ++s) {
                if (s == slot || !this.stackMatchesFilterStack(inventoryHandler.getStackInSlot(s), stack)) continue;
                return class_1799.field_8037;
            }
            return stack;
        }
        return !this.shouldVoidOverflow && this.filterLogic.matchesFilter(stack) ? class_1799.field_8037 : stack;
    }

    @Override
    public void onAfterInsert(IItemHandlerSimpleInserter inventoryHandler, int slot) {
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public void setShouldWorkdInGUI(boolean shouldWorkdInGUI) {
        this.upgrade.sophisticatedCore_set(ModCoreDataComponents.SHOULD_WORK_IN_GUI, (Object)shouldWorkdInGUI);
        this.save();
    }

    public boolean shouldWorkInGUI() {
        return (Boolean)this.upgrade.sophisticatedCore_getOrDefault(ModCoreDataComponents.SHOULD_WORK_IN_GUI, (Object)false);
    }

    public void setShouldVoidOverflow(boolean shouldVoidOverflow) {
        if (!shouldVoidOverflow && !((VoidUpgradeItem)this.upgradeItem).isVoidAnythingEnabled()) {
            return;
        }
        this.shouldVoidOverflow = shouldVoidOverflow;
        this.upgrade.sophisticatedCore_set(ModCoreDataComponents.SHOULD_VOID_OVERFLOW, (Object)shouldVoidOverflow);
        this.save();
    }

    public void setShouldVoidOverflowDefaultOrLoadFromNbt(boolean shouldVoidOverflowDefault) {
        this.shouldVoidOverflow = !((VoidUpgradeItem)this.upgradeItem).isVoidAnythingEnabled() || (Boolean)this.upgrade.sophisticatedCore_getOrDefault(ModCoreDataComponents.SHOULD_VOID_OVERFLOW, (Object)shouldVoidOverflowDefault) != false;
    }

    public boolean shouldVoidOverflow() {
        return !((VoidUpgradeItem)this.upgradeItem).isVoidAnythingEnabled() || this.shouldVoidOverflow;
    }

    @Override
    public void onSlotChange(IItemHandlerSimpleInserter inventoryHandler, int slot) {
        if (!this.shouldWorkInGUI() || this.shouldVoidOverflow()) {
            return;
        }
        class_1799 slotStack = inventoryHandler.getStackInSlot(slot);
        if (this.filterLogic.matchesFilter(slotStack)) {
            this.slotsToVoid.add(slot);
        }
    }

    @Override
    public void tick(@Nullable class_1309 entity, class_1937 level, class_2338 pos) {
        if (this.slotsToVoid.isEmpty()) {
            return;
        }
        InventoryHandler storageInventory = this.storageWrapper.getInventoryHandler();
        for (int slot : this.slotsToVoid) {
            storageInventory.extractItem(slot, storageInventory.getStackInSlot(slot).method_7947(), false);
        }
        this.slotsToVoid.clear();
    }

    @Override
    public boolean worksInGui() {
        return this.shouldWorkInGUI();
    }

    @Override
    public class_1799 onOverflow(class_1799 stack) {
        return this.filterLogic.matchesFilter(stack) ? class_1799.field_8037 : stack;
    }

    @Override
    public boolean stackMatchesFilter(class_1799 stack) {
        return this.filterLogic.matchesFilter(stack);
    }

    public boolean isVoidAnythingEnabled() {
        return ((VoidUpgradeItem)this.upgradeItem).isVoidAnythingEnabled();
    }

    @Override
    public int getSlotLimit() {
        return Integer.MAX_VALUE;
    }
}

