/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AtomicDouble;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.p3pp3rf1y.sophisticatedcore.inventory.IInventoryHandlerHelper;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IPickupResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventorySorter;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import org.apache.commons.lang3.mutable.MutableInt;

public class InventoryHelper {
    private InventoryHelper() {
    }

    public static Optional<class_1799> getItemFromEitherHand(class_1657 player, class_1792 item) {
        class_1799 mainHandItem = player.method_6047();
        if (mainHandItem.method_7909() == item) {
            return Optional.of(mainHandItem);
        }
        class_1799 offhandItem = player.method_6079();
        if (offhandItem.method_7909() == item) {
            return Optional.of(offhandItem);
        }
        return Optional.empty();
    }

    public static boolean hasItem(SlottedStorage<ItemVariant> inventory, Predicate<class_1799> matches) {
        AtomicBoolean result = new AtomicBoolean(false);
        InventoryHelper.iterate(inventory, (Integer slot, class_1799 stack) -> {
            if (!stack.method_7960() && matches.test((class_1799)stack)) {
                result.set(true);
            }
        }, result::get);
        return result.get();
    }

    public static Set<Integer> getItemSlots(SlottedStackStorage inventory, Predicate<class_1799> matches) {
        HashSet<Integer> slots = new HashSet<Integer>();
        InventoryHelper.iterate((SlottedStorage<ItemVariant>)inventory, (Integer slot, class_1799 stack) -> {
            if (!stack.method_7960() && matches.test((class_1799)stack)) {
                slots.add((Integer)slot);
            }
        });
        return slots;
    }

    public static void copyTo(SlottedStackStorage handlerA, SlottedStackStorage handlerB) {
        int slotsA = handlerA.getSlotCount();
        int slotsB = handlerB.getSlotCount();
        for (int slot = 0; slot < slotsA && slot < slotsB; ++slot) {
            class_1799 slotStack = handlerA.getStackInSlot(slot);
            if (slotStack.method_7960()) continue;
            handlerB.setStackInSlot(slot, slotStack);
        }
    }

    public static List<class_1799> insertIntoInventory(List<class_1799> stacks, Storage<ItemVariant> inventory, boolean simulate) {
        if (stacks.isEmpty()) {
            return stacks;
        }
        ArrayList<class_1799> remaining = new ArrayList<class_1799>();
        try (Transaction ctx = Transaction.openOuter();){
            for (class_1799 stack : stacks) {
                ItemVariant resource = ItemVariant.of((class_1799)stack);
                long remainingCount = (long)stack.method_7947() - inventory.insert((Object)resource, (long)stack.method_7947(), (TransactionContext)ctx);
                if (remainingCount <= 0L) continue;
                remaining.add(resource.toStack((int)remainingCount));
            }
            if (!simulate) {
                ctx.commit();
            }
        }
        return remaining;
    }

    public static ItemStackHandler cloneInventory(SlottedStackStorage inventory) {
        ItemStackHandler cloned = new ItemStackHandler(inventory.getSlotCount());
        for (int slot = 0; slot < inventory.getSlotCount(); ++slot) {
            cloned.setStackInSlot(slot, inventory.getStackInSlot(slot).method_7972());
        }
        return cloned;
    }

    public static class_1799 insertIntoInventory(class_1799 stack, SlottedStorage<ItemVariant> inventory, boolean simulate) {
        class_1799 remainingStack;
        if (inventory instanceof IItemHandlerSimpleInserter) {
            IItemHandlerSimpleInserter itemHandlerSimpleInserter = (IItemHandlerSimpleInserter)inventory;
            return itemHandlerSimpleInserter.insertItem(stack, simulate);
        }
        try (Transaction ctx = Transaction.openOuter();){
            remainingStack = stack.method_46651((int)((long)stack.method_7947() - inventory.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)ctx)));
            if (!simulate) {
                ctx.commit();
            }
        }
        return remainingStack;
    }

    public static class_1799 extractFromInventory(class_1792 item, int count, IItemHandlerSimpleInserter inventory, boolean simulate) {
        class_1799 ret = class_1799.field_8037;
        int slots = inventory.getSlotCount();
        for (int slot = 0; slot < slots && ret.method_7947() < count; ++slot) {
            class_1799 slotStack = inventory.getStackInSlot(slot);
            if (slotStack.method_7909() != item || !ret.method_7960() && !class_1799.method_31577((class_1799)ret, (class_1799)slotStack)) continue;
            int toExtract = Math.min(slotStack.method_7947(), count - ret.method_7947());
            class_1799 extractedStack = inventory.extractItem(slot, toExtract, simulate);
            if (ret.method_7960()) {
                ret = extractedStack;
                continue;
            }
            ret.method_7939(ret.method_7947() + extractedStack.method_7947());
        }
        return ret;
    }

    public static class_1799 extractFromInventory(class_1799 stack, IItemHandlerSimpleInserter inventory, boolean simulate) {
        int extractedCount = 0;
        int slots = inventory.getSlotCount();
        for (int slot = 0; slot < slots && extractedCount < stack.method_7947(); ++slot) {
            class_1799 slotStack = inventory.getStackInSlot(slot);
            if (!class_1799.method_31577((class_1799)stack, (class_1799)slotStack)) continue;
            int toExtract = Math.min(slotStack.method_7947(), stack.method_7947() - extractedCount);
            extractedCount += inventory.extractItem(slot, toExtract, simulate).method_7947();
        }
        if (extractedCount == 0) {
            return class_1799.field_8037;
        }
        class_1799 result = stack.method_7972();
        result.method_7939(extractedCount);
        return result;
    }

    public static class_1799 runPickupOnPickupResponseUpgrades(class_1937 level, UpgradeHandler upgradeHandler, class_1799 remainingStack, boolean simulate) {
        return InventoryHelper.runPickupOnPickupResponseUpgrades(level, null, upgradeHandler, remainingStack, simulate);
    }

    public static class_1799 runPickupOnPickupResponseUpgrades(class_1937 level, @Nullable class_1657 player, UpgradeHandler upgradeHandler, class_1799 remainingStack, boolean simulate) {
        List<IPickupResponseUpgrade> pickupUpgrades = upgradeHandler.getWrappersThatImplement(IPickupResponseUpgrade.class);
        for (IPickupResponseUpgrade pickupUpgrade : pickupUpgrades) {
            int countBeforePickup = remainingStack.method_7947();
            class_1792 item = remainingStack.method_7909();
            remainingStack = pickupUpgrade.pickup(level, remainingStack, simulate);
            if (!simulate && player != null && remainingStack.method_7947() != countBeforePickup) {
                InventoryHelper.playPickupSound(level, player);
                player.method_7342(class_3468.field_15392.method_14956((Object)item), countBeforePickup - remainingStack.method_7947());
            }
            if (!remainingStack.method_7960()) continue;
            return class_1799.field_8037;
        }
        return remainingStack;
    }

    private static void playPickupSound(class_1937 level, @Nonnull class_1657 player) {
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, RandHelper.getRandomMinusOneToOne(level.field_9229) * 1.4f + 2.0f);
    }

    public static void iterate(Storage<ItemVariant> handler, Consumer<class_1799> actOn) {
        InventoryHelper.iterate(handler, actOn, () -> false);
    }

    public static void iterate(Storage<ItemVariant> handler, Consumer<class_1799> actOn, BooleanSupplier shouldExit) {
        for (StorageView view : handler.nonEmptyViews()) {
            actOn.accept(view.isResourceBlank() ? class_1799.field_8037 : ((ItemVariant)view.getResource()).toStack((int)view.getAmount()));
            if (!shouldExit.getAsBoolean()) continue;
            break;
        }
    }

    public static void iterate(SlottedStorage<ItemVariant> handler, BiConsumer<Integer, class_1799> actOn) {
        InventoryHelper.iterate(handler, actOn, () -> false);
    }

    public static void iterate(SlottedStorage<ItemVariant> handler, BiConsumer<Integer, class_1799> actOn, BooleanSupplier shouldExit) {
        Function<Integer, class_1799> getStackHandler;
        if (handler instanceof SlottedStackStorage) {
            SlottedStackStorage slottedHandler = (SlottedStackStorage)handler;
            getStackHandler = arg_0 -> ((SlottedStackStorage)slottedHandler).getStackInSlot(arg_0);
        } else {
            getStackHandler = slot -> {
                SingleSlotStorage slotStorage = handler.getSlot(slot.intValue());
                return slotStorage.isResourceBlank() ? class_1799.field_8037 : ((ItemVariant)slotStorage.getResource()).toStack((int)slotStorage.getAmount());
            };
        }
        int slots = handler.getSlotCount();
        for (int slot2 = 0; slot2 < slots; ++slot2) {
            actOn.accept(slot2, getStackHandler.apply(slot2));
            if (shouldExit.getAsBoolean()) break;
        }
    }

    public static int getCountMissingInHandler(IInventoryHandlerHelper itemHandler, class_1799 filter, int expectedCount) {
        MutableInt missingCount = new MutableInt(expectedCount);
        InventoryHelper.iterate(itemHandler, (Integer slot, class_1799 stack) -> {
            if (class_1799.method_31577((class_1799)stack, (class_1799)filter)) {
                missingCount.subtract(Math.min(stack.method_7947(), missingCount.getValue()));
            }
        }, () -> missingCount.getValue() == 0);
        return missingCount.getValue();
    }

    public static <T> T iterate(SlottedStackStorage handler, BiFunction<Integer, class_1799, T> getFromSlotStack, Supplier<T> supplyDefault, Predicate<T> shouldExit) {
        T ret = supplyDefault.get();
        int slots = handler.getSlotCount();
        for (int slot = 0; slot < slots; ++slot) {
            class_1799 stack = handler.getStackInSlot(slot);
            ret = getFromSlotStack.apply(slot, stack);
            if (shouldExit.test(ret)) break;
        }
        return ret;
    }

    public static void transfer(IItemHandlerSimpleInserter handlerA, IItemHandlerSimpleInserter handlerB, Consumer<Supplier<class_1799>> onInserted) {
        int slotsA = handlerA.getSlotCount();
        block0: for (int slot = 0; slot < slotsA; ++slot) {
            class_1799 extractedStack;
            class_1799 slotStack = handlerA.getStackInSlot(slot);
            if (slotStack.method_7960()) continue;
            for (int countToTransfer = slotStack.method_7947(); countToTransfer > 0; countToTransfer -= extractedStack.method_7947()) {
                int toExtract;
                class_1799 toInsert = slotStack.method_7972();
                toInsert.method_7939(Math.min(slotStack.method_7914(), countToTransfer));
                class_1799 remainingAfterInsert = InventoryHelper.insertIntoInventory(toInsert, handlerB, true);
                if (remainingAfterInsert.method_7947() == toInsert.method_7947() || (extractedStack = handlerA.extractItem(slot, toExtract = toInsert.method_7947() - remainingAfterInsert.method_7947(), true)).method_7960()) continue block0;
                InventoryHelper.insertIntoInventory(handlerA.extractItem(slot, extractedStack.method_7947(), false), handlerB, false);
                onInserted.accept(() -> {
                    class_1799 copiedStack = slotStack.method_7972();
                    copiedStack.method_7939(extractedStack.method_7947());
                    return copiedStack;
                });
            }
        }
    }

    public static void transfer(Storage<ItemVariant> handlerA, Storage<ItemVariant> handlerB, Consumer<Supplier<class_1799>> onInserted, @Nullable TransactionContext ctx) {
        for (StorageView view : handlerA.nonEmptyViews()) {
            long inserted;
            long extracted;
            ItemVariant resource = (ItemVariant)view.getResource();
            for (long countToTransfer = view.getAmount(); countToTransfer > 0L && (inserted = StorageUtil.simulateInsert(handlerB, (Object)resource, (long)Math.min((long)resource.toStack().method_7914(), countToTransfer), (TransactionContext)ctx)) != 0L && (extracted = StorageUtil.simulateExtract(handlerA, (Object)resource, (long)inserted, (TransactionContext)ctx)) != 0L; countToTransfer -= extracted) {
                try (Transaction transferTransaction = Transaction.openNested((TransactionContext)ctx);){
                    extracted = view.extract((Object)resource, extracted, (TransactionContext)transferTransaction);
                    long accepted = handlerB.insert((Object)resource, inserted, (TransactionContext)transferTransaction);
                    TransactionCallback.onSuccess((TransactionContext)transferTransaction, () -> onInserted.accept(() -> resource.toStack((int)accepted).method_7972()));
                    transferTransaction.commit();
                    continue;
                }
            }
        }
    }

    public static boolean isEmpty(SlottedStackStorage itemHandler) {
        int slots = itemHandler.getSlotCount();
        for (int slot = 0; slot < slots; ++slot) {
            if (itemHandler.getStackInSlot(slot).method_7960()) continue;
            return false;
        }
        return true;
    }

    public static class_1799 getAndRemove(SlottedStorage<ItemVariant> itemHandler, int slotIndex) {
        if (slotIndex >= itemHandler.getSlotCount()) {
            return class_1799.field_8037;
        }
        SingleSlotStorage slot = itemHandler.getSlot(slotIndex);
        ItemVariant resource = (ItemVariant)slot.getResource();
        return resource.toStack((int)slot.extract((Object)resource, Long.MAX_VALUE, null));
    }

    public static void insertOrDropItem(class_1657 player, class_1799 stack, Storage<ItemVariant> ... inventories) {
        ItemVariant resource = ItemVariant.of((class_1799)stack);
        long toInsert = stack.method_7947();
        for (Storage<ItemVariant> inventory : inventories) {
            try (Transaction ctx = Transaction.openOuter();){
                toInsert -= inventory.insert((Object)resource, toInsert, (TransactionContext)ctx);
                ctx.commit();
            }
            if (toInsert != 0L) continue;
            return;
        }
        if (toInsert > 0L) {
            player.method_7328(resource.toStack((int)toInsert), true);
        }
    }

    public static class_1799 mergeIntoPlayerInventory(class_1657 player, class_1799 stack, int startSlot) {
        class_1799 result = stack.method_7972();
        ArrayList<Integer> emptySlots = new ArrayList<Integer>();
        for (int slot = startSlot; slot < player.method_31548().field_7547.size(); ++slot) {
            class_1799 slotStack = player.method_31548().method_5438(slot);
            if (slotStack.method_7960()) {
                emptySlots.add(slot);
            }
            if (!class_1799.method_31577((class_1799)slotStack, (class_1799)result)) continue;
            int count = Math.min(slotStack.method_7914() - slotStack.method_7947(), result.method_7947());
            slotStack.method_7933(count);
            result.method_7934(count);
            if (!result.method_7960()) continue;
            return class_1799.field_8037;
        }
        Iterator iterator = emptySlots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            class_1799 slotStack = result.method_7972();
            slotStack.method_7939(Math.min(slotStack.method_7914(), result.method_7947()));
            player.method_31548().method_5447(slot, slotStack);
            result.method_7934(slotStack.method_7947());
            if (!result.method_7960()) continue;
            return class_1799.field_8037;
        }
        return result;
    }

    static Map<ItemStackKey, Integer> getCompactedStacks(SlottedStackStorage handler) {
        return InventoryHelper.getCompactedStacks(handler, new HashSet<Integer>());
    }

    static Map<ItemStackKey, Integer> getCompactedStacks(SlottedStackStorage handler, Set<Integer> ignoreSlots) {
        HashMap<ItemStackKey, Integer> ret = new HashMap<ItemStackKey, Integer>();
        InventoryHelper.iterate((SlottedStorage<ItemVariant>)handler, (Integer slot, class_1799 stack) -> {
            if (stack.method_7960() || ignoreSlots.contains(slot)) {
                return;
            }
            ItemStackKey itemStackKey = ItemStackKey.of(stack);
            ret.put(itemStackKey, ret.computeIfAbsent(itemStackKey, fs -> 0) + stack.method_7947());
        });
        return ret;
    }

    public static List<class_1799> getCompactedStacksSortedByCount(SlottedStackStorage handler) {
        Map<ItemStackKey, Integer> compactedStacks = InventoryHelper.getCompactedStacks(handler);
        ArrayList<Map.Entry<ItemStackKey, Integer>> sortedList = new ArrayList<Map.Entry<ItemStackKey, Integer>>(compactedStacks.entrySet());
        sortedList.sort(InventorySorter.BY_COUNT);
        ArrayList<class_1799> ret = new ArrayList<class_1799>();
        sortedList.forEach(e -> {
            class_1799 stackCopy = ((ItemStackKey)e.getKey()).getStack().method_7972();
            stackCopy.method_7939(((Integer)e.getValue()).intValue());
            ret.add(stackCopy);
        });
        return ret;
    }

    public static Set<ItemStackKey> getUniqueStacks(Storage<ItemVariant> handler) {
        HashSet<ItemStackKey> uniqueStacks = new HashSet<ItemStackKey>();
        InventoryHelper.iterate(handler, (class_1799 stack) -> {
            if (stack.method_7960()) {
                return;
            }
            ItemStackKey itemStackKey = ItemStackKey.of(stack);
            uniqueStacks.add(itemStackKey);
        });
        return uniqueStacks;
    }

    public static List<Integer> getEmptySlotsRandomized(SlottedStorage<ItemVariant> inventory) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.getSlotCount(); ++i) {
            if (!inventory.getSlot(i).isResourceBlank()) continue;
            list.add(i);
        }
        Collections.shuffle(list, new Random());
        return list;
    }

    public static void shuffleItems(List<class_1799> stacks, int emptySlotsCount, class_5819 rand) {
        ArrayList list = Lists.newArrayList();
        Iterator<class_1799> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            class_1799 itemstack = iterator.next();
            if (itemstack.method_7960()) {
                iterator.remove();
                continue;
            }
            if (itemstack.method_7947() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (emptySlotsCount - stacks.size() - list.size() > 0 && !list.isEmpty()) {
            class_1799 itemstack2 = (class_1799)list.remove(class_3532.method_15395((class_5819)rand, (int)0, (int)(list.size() - 1)));
            int i = class_3532.method_15395((class_5819)rand, (int)1, (int)(itemstack2.method_7947() / 2));
            class_1799 itemstack1 = itemstack2.method_7971(i);
            if (itemstack2.method_7947() > 1 && rand.method_43056()) {
                list.add(itemstack2);
            } else {
                stacks.add(itemstack2);
            }
            if (itemstack1.method_7947() > 1 && rand.method_43056()) {
                list.add(itemstack1);
                continue;
            }
            stacks.add(itemstack1);
        }
        stacks.addAll(list);
        Collections.shuffle(stacks, new Random());
    }

    public static void dropItems(SlottedStackStorage inventoryHandler, class_1937 level, class_2338 pos) {
        InventoryHelper.dropItems(inventoryHandler, level, pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static void dropItems(SlottedStackStorage inventoryHandler, class_1937 level, double x, double y, double z) {
        InventoryHelper.iterate((SlottedStorage<ItemVariant>)inventoryHandler, (Integer slot, class_1799 stack) -> InventoryHelper.dropItem(inventoryHandler, level, x, y, z, slot, stack));
    }

    public static void dropItem(SlottedStackStorage inventoryHandler, class_1937 level, double x, double y, double z, Integer slot, class_1799 stack) {
        long extracted;
        if (stack.method_7960()) {
            return;
        }
        ItemVariant resource = ItemVariant.of((class_1799)stack);
        try (Transaction ctx = Transaction.openOuter();){
            extracted = inventoryHandler.extractSlot(slot.intValue(), resource, (long)stack.method_7914(), (TransactionContext)ctx);
            ctx.commit();
        }
        while (extracted > 0L) {
            class_1264.method_5449((class_1937)level, (double)x, (double)y, (double)z, (class_1799)resource.toStack((int)extracted));
            ctx = Transaction.openOuter();
            try {
                extracted = inventoryHandler.extractSlot(slot.intValue(), resource, (long)stack.method_7914(), (TransactionContext)ctx);
                ctx.commit();
            }
            finally {
                if (ctx == null) continue;
                ctx.close();
            }
        }
        inventoryHandler.setStackInSlot(slot.intValue(), class_1799.field_8037);
    }

    public static int getAnalogOutputSignal(ITrackedContentsItemHandler handler) {
        AtomicDouble totalFilled = new AtomicDouble(0.0);
        AtomicBoolean isEmpty = new AtomicBoolean(true);
        InventoryHelper.iterate(handler, (Integer slot, class_1799 stack) -> {
            if (!stack.method_7960()) {
                int slotLimit = handler.getInternalSlotLimit((int)slot);
                totalFilled.addAndGet((double)((float)stack.method_7947() / ((float)slotLimit / (64.0f / (float)stack.method_7914()))));
                isEmpty.set(false);
            }
        });
        double percentFilled = totalFilled.get() / (double)handler.getSlotCount();
        return class_3532.method_15357((double)(percentFilled * 14.0)) + (isEmpty.get() ? 0 : 1);
    }
}

