/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.gui;

import com.branders.spawnermod.config.ConfigValues;
import com.branders.spawnermod.networking.packet.SyncSpawnerPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1917;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class SpawnerConfigGui
extends class_437 {
    private static final Data DELAY = new Data(30, 20, 10, 5);
    private static final Data MIN_SPAWN_DELAY = new Data(300, 200, 100, 50);
    private static final Data MAX_SPAWN_DELAY = new Data(900, 800, 400, 100);
    private static final Data SPAWN_COUNT = new Data(2, 4, 6, 12);
    private static final Data MAX_NEARBY_ENTITIES = new Data(6, 6, 12, 24);
    private static final Data REQUIRED_PLAYER_RANGE = new Data(16, 32, 64, 128);
    private static final class_2561 TITLE_TEXT = class_2561.method_43471((String)"gui.spawnermod.spawner_config_screen_title");
    private static final class_2960 SPAWNER_CONFIG_TEXTURE = class_2960.method_60655((String)"spawnermod", (String)"textures/gui/spawner_config_screen.png");
    private static final class_2960 SPAWNS_ICON_TEXTURE = class_2960.method_60655((String)"spawnermod", (String)"textures/gui/spawner_config_screen_icon_spawns.png");
    private static final int SPAWNER_CONFIG_TEXTURE_WIDTH = 178;
    private static final int SPAWNER_CONFIG_TEXTURE_HEIGHT = 177;
    private class_4185 countButton;
    private class_4185 speedButton;
    private class_4185 rangeButton;
    private class_4185 disableButton;
    private int countOptionValue;
    private int speedOptionValue;
    private int rangeOptionValue;
    private short delay;
    private short minSpawnDelay;
    private short maxSpawnDelay;
    private short spawnCount;
    private short maxNearbyEntities;
    private short requiredPlayerRange;
    private boolean disabled;
    private short spawns;
    private final boolean cachedDisabled;
    private final boolean limitedSpawns;
    private boolean isCustomRange;
    private short customRange;
    private final class_2338 pos;

    public SpawnerConfigGui(class_2561 title, class_1917 logic, class_2338 pos) {
        super(title);
        this.pos = pos;
        if (ConfigValues.get("default_spawner_range_enabled") == 1) {
            this.isCustomRange = true;
            this.customRange = (short)ConfigValues.get("default_spawner_range");
        }
        class_2487 nbt = new class_2487();
        nbt = logic.method_8272(nbt);
        this.delay = nbt.method_10568("Delay");
        this.minSpawnDelay = nbt.method_10568("MinSpawnDelay");
        this.maxSpawnDelay = nbt.method_10568("MaxSpawnDelay");
        this.spawnCount = nbt.method_10568("SpawnCount");
        this.maxNearbyEntities = nbt.method_10568("MaxNearbyEntities");
        this.requiredPlayerRange = nbt.method_10568("RequiredPlayerRange");
        short spawnRange = nbt.method_10568("SpawnRange");
        if (spawnRange > 4) {
            this.disabled = true;
            this.cachedDisabled = true;
            this.requiredPlayerRange = spawnRange;
        } else {
            this.disabled = false;
            this.cachedDisabled = false;
        }
        this.countOptionValue = this.loadOptionState(this.spawnCount, SPAWN_COUNT);
        this.speedOptionValue = this.loadOptionState(this.minSpawnDelay, MIN_SPAWN_DELAY);
        this.rangeOptionValue = this.loadOptionState(this.requiredPlayerRange, REQUIRED_PLAYER_RANGE);
        if (ConfigValues.get("limited_spawns_enabled") != 0) {
            this.limitedSpawns = true;
            if (nbt.method_10545("spawns")) {
                this.spawns = nbt.method_10568("spawns");
                if (ConfigValues.get("limited_spawns_amount") - this.spawns == 0) {
                    this.disabled = true;
                }
            }
        } else {
            this.limitedSpawns = false;
        }
    }

    protected void method_25426() {
        this.countButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)("button.count." + this.getButtonText(this.countOptionValue))), button -> {
            switch (this.countOptionValue) {
                case 0: {
                    this.countOptionValue = 1;
                    this.spawnCount = SpawnerConfigGui.SPAWN_COUNT.DEFAULT;
                    this.maxNearbyEntities = SpawnerConfigGui.MAX_NEARBY_ENTITIES.DEFAULT;
                    break;
                }
                case 1: {
                    this.countOptionValue = 2;
                    this.spawnCount = SpawnerConfigGui.SPAWN_COUNT.HIGH;
                    this.maxNearbyEntities = SpawnerConfigGui.MAX_NEARBY_ENTITIES.HIGH;
                    break;
                }
                case 2: {
                    this.countOptionValue = 3;
                    this.spawnCount = SpawnerConfigGui.SPAWN_COUNT.HIGHEST;
                    this.maxNearbyEntities = SpawnerConfigGui.MAX_NEARBY_ENTITIES.HIGHEST;
                    break;
                }
                case 3: {
                    this.countOptionValue = 0;
                    this.spawnCount = SpawnerConfigGui.SPAWN_COUNT.LOW;
                    this.maxNearbyEntities = SpawnerConfigGui.MAX_NEARBY_ENTITIES.LOW;
                }
            }
            this.countButton.method_25355((class_2561)class_2561.method_43471((String)("button.count." + this.getButtonText(this.countOptionValue))));
        }).method_46434(this.field_22789 / 2 - 48, 55, 108, 20).method_46431());
        this.speedButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)("button.speed." + this.getButtonText(this.speedOptionValue))), button -> {
            switch (this.speedOptionValue) {
                case 0: {
                    this.speedOptionValue = 1;
                    this.delay = SpawnerConfigGui.DELAY.DEFAULT;
                    this.minSpawnDelay = SpawnerConfigGui.MIN_SPAWN_DELAY.DEFAULT;
                    this.maxSpawnDelay = SpawnerConfigGui.MAX_SPAWN_DELAY.DEFAULT;
                    break;
                }
                case 1: {
                    this.speedOptionValue = 2;
                    this.delay = SpawnerConfigGui.DELAY.HIGH;
                    this.minSpawnDelay = SpawnerConfigGui.MIN_SPAWN_DELAY.HIGH;
                    this.maxSpawnDelay = SpawnerConfigGui.MAX_SPAWN_DELAY.HIGH;
                    break;
                }
                case 2: {
                    this.speedOptionValue = 3;
                    this.delay = SpawnerConfigGui.DELAY.HIGHEST;
                    this.minSpawnDelay = SpawnerConfigGui.MIN_SPAWN_DELAY.HIGHEST;
                    this.maxSpawnDelay = SpawnerConfigGui.MAX_SPAWN_DELAY.HIGHEST;
                    break;
                }
                case 3: {
                    this.speedOptionValue = 0;
                    this.delay = SpawnerConfigGui.DELAY.LOW;
                    this.minSpawnDelay = SpawnerConfigGui.MIN_SPAWN_DELAY.LOW;
                    this.maxSpawnDelay = SpawnerConfigGui.MAX_SPAWN_DELAY.LOW;
                }
            }
            this.speedButton.method_25355((class_2561)class_2561.method_43471((String)("button.speed." + this.getButtonText(this.speedOptionValue))));
        }).method_46434(this.field_22789 / 2 - 48, 80, 108, 20).method_46431());
        this.rangeButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)("button.range." + this.getButtonText(this.rangeOptionValue))).method_27693(" " + this.requiredPlayerRange), button -> {
            switch (this.rangeOptionValue) {
                case 0: {
                    this.rangeOptionValue = 1;
                    this.requiredPlayerRange = SpawnerConfigGui.REQUIRED_PLAYER_RANGE.DEFAULT;
                    break;
                }
                case 1: {
                    this.rangeOptionValue = 2;
                    this.requiredPlayerRange = SpawnerConfigGui.REQUIRED_PLAYER_RANGE.HIGH;
                    break;
                }
                case 2: {
                    this.rangeOptionValue = 3;
                    this.requiredPlayerRange = SpawnerConfigGui.REQUIRED_PLAYER_RANGE.HIGHEST;
                    break;
                }
                case 3: {
                    if (this.isCustomRange) {
                        this.rangeOptionValue = 4;
                        this.requiredPlayerRange = this.customRange;
                        break;
                    }
                    this.rangeOptionValue = 0;
                    this.requiredPlayerRange = SpawnerConfigGui.REQUIRED_PLAYER_RANGE.LOW;
                    break;
                }
                case 4: {
                    this.rangeOptionValue = 0;
                    this.requiredPlayerRange = SpawnerConfigGui.REQUIRED_PLAYER_RANGE.LOW;
                }
            }
            this.rangeButton.method_25355((class_2561)class_2561.method_43471((String)("button.range." + this.getButtonText(this.rangeOptionValue))).method_27693(" " + this.requiredPlayerRange));
        }).method_46434(this.field_22789 / 2 - 48, 105, 108, 20).method_46431());
        this.disableButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)("button.toggle." + this.getButtonText(this.disabled))), button -> {
            if (this.disabled) {
                this.disabled = false;
                this.toggleButtons(true);
                switch (this.rangeOptionValue) {
                    case 0: {
                        this.requiredPlayerRange = SpawnerConfigGui.REQUIRED_PLAYER_RANGE.LOW;
                        break;
                    }
                    case 1: {
                        this.requiredPlayerRange = SpawnerConfigGui.REQUIRED_PLAYER_RANGE.DEFAULT;
                        break;
                    }
                    case 2: {
                        this.requiredPlayerRange = SpawnerConfigGui.REQUIRED_PLAYER_RANGE.HIGH;
                        break;
                    }
                    case 3: {
                        this.requiredPlayerRange = SpawnerConfigGui.REQUIRED_PLAYER_RANGE.HIGHEST;
                    }
                }
            } else {
                this.disabled = true;
                this.toggleButtons(false);
                this.requiredPlayerRange = 0;
            }
            this.disableButton.method_25355((class_2561)class_2561.method_43471((String)("button.toggle." + this.getButtonText(this.disabled))));
        }).method_46434(this.field_22789 / 2 - 48, 130, 108, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.save"), button -> {
            this.configureSpawner();
            this.method_25419();
        }).method_46434(this.field_22789 / 2 - 89, 190, 178, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.cancel"), button -> this.method_25419()).method_46434(this.field_22789 / 2 - 89, 215, 178, 20).method_46431());
        this.toggleButtons(!this.disabled);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25420(context, mouseX, mouseY, delta);
        context.method_25290(SPAWNER_CONFIG_TEXTURE, this.field_22789 / 2 - 89, 5, 0.0f, 0.0f, 178, 177, 178, 177);
        int length = TITLE_TEXT.getString().length() * 2;
        context.method_27535(this.field_22787.field_1772, TITLE_TEXT, this.field_22789 / 2 - length - 3, 33, 16767332);
        if (this.limitedSpawns) {
            context.method_25290(SPAWNS_ICON_TEXTURE, this.field_22789 / 2 - 7 + 101, 23, 0.0f, 0.0f, 14, 14, 14, 14);
            context.method_27535(this.field_22787.field_1772, (class_2561)class_2561.method_43470((String)("" + (ConfigValues.get("limited_spawns_amount") - this.spawns))), this.field_22789 / 2 + 114, 27, 0xFFFFFF);
        }
    }

    private void configureSpawner() {
        if (this.cachedDisabled && this.disabled) {
            return;
        }
        ClientPlayNetworking.send((class_8710)new SyncSpawnerPacket(this.pos, this.delay, this.spawnCount, this.requiredPlayerRange, this.maxNearbyEntities, this.minSpawnDelay, this.maxSpawnDelay));
    }

    private String getButtonText(int optionValue) {
        return switch (optionValue) {
            case 0 -> "low";
            case 1 -> "default";
            case 2 -> "high";
            case 3 -> "very_high";
            case 4 -> "custom";
            default -> "default";
        };
    }

    private String getButtonText(boolean disabled) {
        if (disabled) {
            return "disabled";
        }
        return "enabled";
    }

    private int loadOptionState(short current, Data reference) {
        if (this.isCustomRange && current == this.customRange) {
            return 4;
        }
        if (current == reference.LOW) {
            return 0;
        }
        if (current == reference.DEFAULT) {
            return 1;
        }
        if (current == reference.HIGH) {
            return 2;
        }
        if (current == reference.HIGHEST) {
            return 3;
        }
        return 0;
    }

    private void toggleButtons(boolean state) {
        if (ConfigValues.get("disable_count") != 0) {
            this.countButton.field_22763 = false;
            this.countButton.method_25355((class_2561)class_2561.method_43471((String)"button.count.disabled"));
        } else {
            this.countButton.field_22763 = state;
        }
        if (ConfigValues.get("disable_speed") != 0) {
            this.speedButton.field_22763 = false;
            this.speedButton.method_25355((class_2561)class_2561.method_43471((String)"button.speed.disabled"));
        } else {
            this.speedButton.field_22763 = state;
        }
        if (ConfigValues.get("disable_range") != 0) {
            this.rangeButton.field_22763 = false;
            this.rangeButton.method_25355((class_2561)class_2561.method_43471((String)"button.range.disabled"));
        } else {
            this.rangeButton.field_22763 = state;
        }
    }

    private static class Data {
        short LOW;
        short DEFAULT;
        short HIGH;
        short HIGHEST;

        public Data(int i, int j, int k, int l) {
            this.LOW = (short)i;
            this.DEFAULT = (short)j;
            this.HIGH = (short)k;
            this.HIGHEST = (short)l;
        }
    }
}

