/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.temperature;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.HeatingConfig;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.item.SunHatItem;
import com.github.thedeathlycow.scorchful.registry.tag.SBlockTags;
import com.github.thedeathlycow.scorchful.registry.tag.SeasonalBiomeTags;
import com.github.thedeathlycow.thermoo.api.season.ThermooSeason;
import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentController;
import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentControllerDecorator;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2802;
import net.minecraft.class_2874;
import net.minecraft.class_3215;
import net.minecraft.class_6880;

public class AmbientTemperatureController
extends EnvironmentControllerDecorator {
    public AmbientTemperatureController(EnvironmentController controller) {
        super(controller);
    }

    public int getTemperatureEffectsChange(class_1309 entity) {
        if (!entity.thermoo$isWarm()) {
            return this.controller.getTemperatureEffectsChange(entity);
        }
        int change = 0;
        HeatingConfig config = Scorchful.getConfig().heatingConfig;
        if (entity.thermoo$canOverheat() && entity.method_5809() && !entity.method_5753()) {
            int onFireChange = entity.method_6059(class_1294.field_5918) ? config.getOnFireWarmRateWithFireResistance() : config.getOnFireWarmRate();
            change += onFireChange;
        }
        if (entity.method_5771()) {
            change += config.getInLavaWarmRate();
        } else if (entity.method_5864() == class_1299.field_23214) {
            change -= config.getStriderOutOfLavaCoolRate();
        }
        if (entity.field_28628 && entity.thermoo$canFreeze()) {
            change -= config.getPowderSnowCoolRate();
        }
        return change;
    }

    public int getFloorTemperature(class_1309 entity, class_1937 world, class_2680 state, class_2338 pos) {
        int base = this.controller.getFloorTemperature(entity, world, state, pos);
        if (state.method_26164(SBlockTags.HEAVY_ICE) && entity.thermoo$isWarm()) {
            ScorchfulConfig config = Scorchful.getConfig();
            return base - config.heatingConfig.getCoolingFromIce();
        }
        return base;
    }

    public int getEnvironmentTemperatureForPlayer(class_1657 player, int localTemperature) {
        boolean hasHatShade;
        if (localTemperature < 0 || !player.thermoo$canOverheat()) {
            return this.controller.getEnvironmentTemperatureForPlayer(player, localTemperature);
        }
        ScorchfulConfig config = Scorchful.getConfig();
        class_1937 world = player.method_37908();
        int sunLight = world.method_8314(class_1944.field_9284, player.method_24515());
        class_6880 biome = world.method_23753(player.method_24515());
        ThermooSeason season = ThermooSeason.getCurrentSeason((class_1937)world).orElse(ThermooSeason.SPRING);
        boolean bl = hasHatShade = sunLight >= config.heatingConfig.getMinSkyLightLevelForHeat() && SunHatItem.isWearingSunHat((class_1309)player) && biome.method_40220(SeasonalBiomeTags.forSeason(season).scorching());
        if (hasHatShade) {
            int shading = config.heatingConfig.getSunHatShadeTemperatureChange();
            return localTemperature + shading;
        }
        return localTemperature;
    }

    public int getLocalTemperatureChange(class_1937 world, class_2338 pos) {
        class_2874 dimensionType = world.method_8597();
        if (dimensionType.comp_645()) {
            return this.getNaturalWorldTemperatureChange(world, pos);
        }
        if (world.method_8597().comp_644()) {
            return this.getNetherTemperatureChange(world, pos);
        }
        return this.controller.getLocalTemperatureChange(world, pos);
    }

    private int getNetherTemperatureChange(class_1937 world, class_2338 pos) {
        int blockLight = world.method_8314(class_1944.field_9282, pos);
        int distanceToLavaLevel = Integer.MAX_VALUE;
        class_2802 class_28022 = world.method_8398();
        if (class_28022 instanceof class_3215) {
            class_3215 serverChunkManager = (class_3215)class_28022;
            int height = pos.method_10264();
            int seaLevel = serverChunkManager.method_12129().method_16398();
            distanceToLavaLevel = Math.max(height - seaLevel, 0);
        }
        HeatingConfig config = Scorchful.getConfig().heatingConfig;
        int maxHeatFromHeight = config.getMaxHeatFromLavaOceanInNether();
        int lightPerHeat = config.getLightLevelPerHeatInNether();
        int minLight = config.getMinLightLevelForHeatInNether();
        int blockLightHeat = Math.max((blockLight - minLight + lightPerHeat) / lightPerHeat, 0);
        return Math.max(blockLightHeat, distanceToLavaLevel != 0 ? distanceToLavaLevel / -config.getBlocksAboveLavaOceanPerHeatInNether() + maxHeatFromHeight : maxHeatFromHeight);
    }

    private int getNaturalWorldTemperatureChange(class_1937 world, class_2338 pos) {
        int minLevel;
        int skylight;
        int skylightWithDarkness;
        int warmth = this.controller.getLocalTemperatureChange(world, pos);
        class_6880 biome = world.method_23753(pos);
        ScorchfulConfig config = Scorchful.getConfig();
        ThermooSeason season = config.integrationConfig.seasonsConfig.enableSeasonsIntegration() ? ThermooSeason.getCurrentSeason((class_1937)world).orElse(ThermooSeason.SPRING) : ThermooSeason.SPRING;
        SeasonalBiomeTags tags = SeasonalBiomeTags.forSeason(season);
        if (biome.method_40220(tags.warm()) && (skylightWithDarkness = (skylight = world.method_8314(class_1944.field_9284, pos)) - world.method_8594()) >= (minLevel = config.heatingConfig.getMinSkyLightLevelForHeat())) {
            warmth += config.heatingConfig.getHeatFromSun();
            if (biome.method_40220(tags.scorching())) {
                warmth += config.heatingConfig.getScorchingBiomeHeatIncrease();
            }
        }
        return warmth;
    }
}

