/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.temperature;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.config.SeasonsConfig;
import com.github.thedeathlycow.scorchful.registry.tag.SBiomeTags;
import com.github.thedeathlycow.thermoo.api.season.ThermooSeason;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingMode;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_6880;

public class Cooling {
    public static void tick(class_1309 entity) {
        if (entity.thermoo$getTemperature() > 0 && entity.thermoo$isWet()) {
            Cooling.tickWetAndWarm(entity);
        }
    }

    private static void tickWetAndWarm(class_1309 entity) {
        ScorchfulConfig config = Scorchful.getConfig();
        int temperatureChange = config.thirstConfig.getTemperatureFromWetness();
        class_1937 world = entity.method_37908();
        if (!entity.method_5869()) {
            float efficiency = Cooling.getSweatEfficiency(world, entity.method_24515(), config);
            temperatureChange = class_3532.method_15375((float)((float)temperatureChange * efficiency));
        }
        entity.thermoo$addTemperature(temperatureChange, (HeatingMode)HeatingModes.PASSIVE);
    }

    private static float getSweatEfficiency(class_1937 world, class_2338 pos, ScorchfulConfig config) {
        class_6880 biome = world.method_23753(pos);
        if (biome.method_40220(SBiomeTags.HUMID_BIOMES)) {
            return Cooling.getSeasonalSweatEfficiency(world, pos, config);
        }
        return 1.0f;
    }

    private static float getSeasonalSweatEfficiency(class_1937 world, class_2338 pos, ScorchfulConfig config) {
        ThermooSeason season;
        float baseEfficiency = config.thirstConfig.getHumidBiomeSweatEfficiency();
        SeasonsConfig seasonsConfig = config.integrationConfig.seasonsConfig;
        if (!seasonsConfig.enableSeasonsIntegration()) {
            return baseEfficiency;
        }
        ThermooSeason thermooSeason = season = (ThermooSeason)ThermooSeason.getCurrentTropicalSeason((class_1937)world, (class_2338)pos).orElse(null);
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TROPICAL_WET", "TROPICAL_DRY"}, (ThermooSeason)thermooSeason, n)) {
            case 0 -> seasonsConfig.getWetSeasonHumidBiomeSweatEfficiency();
            case 1 -> seasonsConfig.getDrySeasonHumidBiomeSweatEfficiency();
            default -> baseEfficiency;
        };
    }

    private Cooling() {
    }
}

