/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.temperature;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.components.RehydrationComponent;
import com.github.thedeathlycow.scorchful.components.ScorchfulComponents;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.registry.SEntityAttributes;
import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentController;
import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentControllerDecorator;
import com.github.thedeathlycow.thermoo.api.temperature.Soakable;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_3486;

public class WetTickController
extends EnvironmentControllerDecorator {
    public WetTickController(EnvironmentController controller) {
        super(controller);
    }

    public int getSoakChange(Soakable soakable) {
        if (!(soakable instanceof class_1309)) {
            return 0;
        }
        class_1309 entity = (class_1309)soakable;
        ScorchfulConfig config = Scorchful.getConfig();
        int soakChange = WetTickController.getWetChange(entity, config);
        soakChange = WetTickController.getDryChange(entity, config, soakChange);
        return soakChange;
    }

    private static int getWetChange(class_1309 entity, ScorchfulConfig config) {
        int soakChange = 0;
        if (entity.method_5777(class_3486.field_15517)) {
            return entity.thermoo$getMaxWetTicks();
        }
        if (entity.method_5721() || entity.method_55667().method_27852(class_2246.field_27097)) {
            soakChange += config.thirstConfig.getTouchingWaterWetnessIncrease();
        }
        return soakChange;
    }

    private static int getDryChange(class_1309 entity, ScorchfulConfig config, int wetChange) {
        if (wetChange <= 0 && entity.thermoo$isWet()) {
            wetChange = -config.thirstConfig.getDryRate();
        }
        if (entity.method_5809()) {
            wetChange -= config.thirstConfig.getOnFireDryDate();
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            WetTickController.tickRehydration(player, wetChange);
        }
        return wetChange;
    }

    private static void tickRehydration(class_1657 player, int wetChange) {
        double rehydrationEfficiency = player.method_45325(SEntityAttributes.REHYDRATION_EFFICIENCY);
        RehydrationComponent component = (RehydrationComponent)ScorchfulComponents.REHYDRATION.get((Object)player);
        component.tickRehydration(rehydrationEfficiency, wetChange);
    }
}

