/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.serialization.DynamicOps;
import net.mehvahdjukaar.supplementaries.common.items.BambooSpikesTippedItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9381;
import org.jetbrains.annotations.NotNull;

public class BambooSpikesBlockTile
extends class_2586 {
    public static final float POTION_MULTIPLIER = 0.1f;
    public static final int MAX_CHARGES = 16;
    @NotNull
    protected class_1844 potion = class_1844.field_49274;
    protected int charges = 0;
    protected long lastTicked = 0L;

    public BambooSpikesBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.BAMBOO_SPIKES_TILE.get(), pos, state);
    }

    public int getColor() {
        if (this.hasPotion()) {
            return this.potion.method_8064();
        }
        return 0xFFFFFF;
    }

    public boolean hasPotion() {
        return this.charges != 0 && this.potion != class_1844.field_49274;
    }

    public boolean isOnCooldown(class_1937 world) {
        return world.method_8510() - this.lastTicked < 20L;
    }

    public boolean consumeCharge(class_1937 world) {
        if (CommonConfigs.Functional.ONLY_ALLOW_HARMFUL.get().booleanValue()) {
            for (class_1293 e : this.potion.method_57397()) {
                if (!((class_1291)e.method_5579().comp_349()).method_5573()) continue;
                return true;
            }
        }
        this.lastTicked = world.method_8510();
        --this.charges;
        this.method_5431();
        if (this.charges <= 0) {
            this.charges = 0;
            this.potion = class_1844.field_49274;
            return true;
        }
        return false;
    }

    public boolean tryApplyPotion(class_1844 potion) {
        return this.tryApplyPotion(potion, 16);
    }

    public boolean tryApplyPotion(class_1844 newPotion, int charges) {
        if ((!this.hasPotion() || this.potion.equals((Object)newPotion) && this.charges != 16) && BambooSpikesTippedItem.isPotionValid(newPotion) && charges > 0) {
            this.potion = newPotion;
            this.charges = 16;
            this.method_5431();
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            this.charges = Math.clamp((long)charges, 0, 16);
            return true;
        }
        return false;
    }

    public boolean interactWithEntity(class_1309 le, @NotNull class_1937 world) {
        if (this.hasPotion() && !this.isOnCooldown(world)) {
            boolean used = false;
            for (class_1293 effectInstance : this.potion.method_57397()) {
                if (!le.method_6049(effectInstance) || le.method_6059(effectInstance.method_5579())) continue;
                class_1291 effect = (class_1291)effectInstance.method_5579().comp_349();
                if (effect.method_5561()) {
                    float health = 0.5f;
                    effect.method_5564(null, null, le, effectInstance.method_5578(), (double)health);
                } else {
                    le.method_6092(new class_1293(effectInstance.method_5579(), (int)((float)effectInstance.method_5584() * 0.1f), effectInstance.method_5578()));
                }
                used = true;
            }
            if (used) {
                this.makeParticle(world);
                return this.consumeCharge(world);
            }
        }
        return false;
    }

    public void makeParticle(class_1937 level) {
        int color = this.getColor();
        class_2338 pos = this.method_11016();
        level.method_8406((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)color), (double)pos.method_10263() + 0.5 + ((double)level.field_9229.method_43057() - 0.5) * 0.75, (double)pos.method_10264() + 0.5 + ((double)level.field_9229.method_43057() - 0.5) * 0.75, (double)pos.method_10260() + 0.5 + ((double)level.field_9229.method_43057() - 0.5) * 0.75, 0.0, 0.0, 0.0);
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        tag.method_10569("Charges", this.charges);
        tag.method_10544("LastTicked", this.lastTicked);
        if (this.hasPotion()) {
            class_6903 ops = registries.method_57093((DynamicOps)class_2509.field_11560);
            tag.method_10566("Potion", (class_2520)class_1844.field_49275.encodeStart((DynamicOps)ops, (Object)this.potion).getOrThrow());
        }
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.charges = tag.method_10550("Charges");
        this.lastTicked = tag.method_10537("LastTicked");
        if (tag.method_10545("Potion")) {
            class_6903 ops = registries.method_57093((DynamicOps)class_2509.field_11560);
            class_1844.field_49275.decode((DynamicOps)ops, (Object)tag.method_10580("Potion")).ifSuccess(p -> {
                this.potion = (class_1844)p.getFirst();
            });
        } else {
            this.potion = class_1844.field_49274;
        }
    }

    protected void method_57568(class_2586.class_9473 componentInput) {
        super.method_57568(componentInput);
        class_1844 potion = (class_1844)componentInput.method_58694(class_9334.field_49651);
        if (potion != null) {
            this.potion = potion;
            this.charges = class_3532.method_15340((int)((Integer)componentInput.method_58695(ModComponents.CHARGES.get(), (Object)16)), (int)0, (int)16);
        }
    }

    protected void method_57567(class_9323.class_9324 components) {
        super.method_57567(components);
        if (this.hasPotion()) {
            components.method_57840(class_9334.field_49651, (Object)this.potion);
            components.method_57840(ModComponents.CHARGES.get(), (Object)class_3532.method_15340((int)this.charges, (int)0, (int)16));
        }
    }

    public void method_57569(class_2487 tag) {
        super.method_57569(tag);
        tag.method_10551("Potion");
        tag.method_10551("Charges");
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }
}

