/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.supplementaries.common.block.blocks.WindVaneBlock;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.BreezyCompat;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.WilderWildCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_7225;

public class WindVaneBlockTile
extends class_2586 {
    private static final int WIND_CHARGED_DURATION = 40;
    private int windChargedTicks = 0;
    private float yaw = 0.0f;
    private float prevYaw = 0.0f;
    private float offset = 0.0f;

    public WindVaneBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.WIND_VANE_TILE.get(), pos, state);
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.windChargedTicks = tag.method_10550("wind_charged_ticks");
        float tp = (float)Math.PI * 2;
        this.offset = 400.0f * (class_3532.method_15374((float)(0.005f * (float)this.field_11867.method_10263() % tp)) + class_3532.method_15374((float)(0.005f * (float)this.field_11867.method_10260() % tp)) + class_3532.method_15374((float)(0.005f * (float)this.field_11867.method_10264() % tp)));
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        tag.method_10569("wind_charged_ticks", this.windChargedTicks);
    }

    public float getYaw(float partialTicks) {
        return this.yaw;
    }

    public static void tick(class_1937 pLevel, class_2338 pPos, class_2680 pState, WindVaneBlockTile tile) {
        float currentYaw;
        tile.prevYaw = currentYaw = tile.yaw;
        if (!pLevel.method_8608()) {
            if (pLevel.method_8510() % 20L == 0L) {
                WindVaneBlock.updatePower(pState, pLevel, pPos, tile.windChargedTicks != 0);
            }
        } else {
            int power = (Integer)pState.method_11654((class_2769)WindVaneBlock.WIND_STRENGTH);
            float tp = (float)Math.PI * 2;
            float t = (float)(pLevel.method_8510() % 24000L) + tile.offset;
            float b = (float)Math.max(1.0, (double)power * ClientConfigs.Blocks.WIND_VANE_POWER_SCALING.get());
            double maxAngle1 = ClientConfigs.Blocks.WIND_VANE_ANGLE_1.get();
            double maxAngle2 = ClientConfigs.Blocks.WIND_VANE_ANGLE_2.get();
            double period1 = ClientConfigs.Blocks.WIND_VANE_PERIOD_1.get();
            double period2 = ClientConfigs.Blocks.WIND_VANE_PERIOD_2.get();
            float newYaw = (float)(maxAngle1 * (double)class_3532.method_15374((float)((float)((double)tp * ((double)(t * b) / period1 % 360.0)))) + maxAngle2 * (double)class_3532.method_15374((float)((float)((double)tp * ((double)(t * b) / period2 % 360.0)))));
            float windCharged = (float)tile.windChargedTicks / 40.0f;
            float rise = 0.3f;
            float trapezoidal = WindVaneBlockTile.trapezoidal(1.0f - windCharged, rise);
            tile.yaw = (1.0f - trapezoidal) * newYaw;
            if (CompatHandler.WILDER_WILD) {
                tile.yaw += WilderWildCompat.getWindAngle(pPos, pLevel);
            } else if (CompatHandler.BREEZY) {
                tile.yaw += BreezyCompat.getWindAngle(pPos, pLevel);
            }
            float p = 1.0f - windCharged * windCharged;
            if (windCharged < rise) {
                p = 1.0f;
            }
            tile.yaw += p * 360.0f * 5.0f;
            tile.yaw = class_3532.method_15393((float)tile.yaw);
        }
        if (tile.windChargedTicks > 0) {
            --tile.windChargedTicks;
            if (tile.windChargedTicks == 0 && !pLevel.field_9236) {
                WindVaneBlock.updatePower(pState, pLevel, pPos, false);
            }
        }
    }

    private static float trapezoidal(float x, float rise) {
        float fallStart = 1.0f - rise;
        if (x < 0.0f) {
            return 0.0f;
        }
        if (x < rise) {
            float a = (x - rise) / rise;
            return 1.0f - a * a;
        }
        if (x < fallStart) {
            return 1.0f;
        }
        if ((double)x <= 1.0) {
            float normalizedX = (x - fallStart) / rise;
            return (1.0f - normalizedX) * (1.0f - normalizedX) * (3.0f - 2.0f * (1.0f - normalizedX));
        }
        return 0.0f;
    }

    public void setWindCharged() {
        this.windChargedTicks = 40;
    }
}

