/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1480;
import net.minecraft.class_1657;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5761;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BucketHelper {
    private static final BiMap<class_1792, class_1299<?>> BUCKET_TO_MOB_MAP = HashBiMap.create();

    @Nullable
    public static class_1299<?> getEntityTypeFromBucket(class_1792 bucket) {
        class_2960 res;
        Optional opt;
        class_1299 type = (class_1299)BUCKET_TO_MOB_MAP.get((Object)bucket);
        if (type != null) {
            return type;
        }
        if (bucket instanceof class_1785) {
            class_1785 bucketItem = (class_1785)bucket;
            class_1299 en = bucketItem.field_7991;
            BucketHelper.associateMobToBucketIfAbsent(en, bucket);
            return en;
        }
        String mobId = null;
        String itemName = Utils.getID((class_1792)bucket).toString();
        if (itemName.contains("_bucket")) {
            mobId = itemName.replace("_bucket", "");
        } else if (itemName.contains("bucket_of_")) {
            mobId = itemName.replace("_bucket", "");
        } else if (itemName.contains("bucket_")) {
            mobId = itemName.replace("bucket_", "");
        }
        if (mobId != null && (opt = class_7923.field_41177.method_17966(res = class_2960.method_60654((String)mobId))).isPresent()) {
            class_1299 en = (class_1299)opt.get();
            BucketHelper.associateMobToBucketIfAbsent(en, bucket);
            return en;
        }
        return null;
    }

    @NotNull
    public static class_1799 getBucketFromEntity(class_1297 entity) {
        class_1799 b;
        class_1799 bucket = class_1799.field_8037;
        if (entity instanceof class_5761) {
            class_5761 bucketable = (class_5761)entity;
            bucket = (class_1799)Preconditions.checkNotNull((Object)bucketable.method_6452(), (Object)("Bucketable modded entity " + String.valueOf(Utils.getID((class_1299)entity.method_5864())) + " returned a null bucket!"));
        } else if (entity instanceof class_1480) {
            bucket = BucketHelper.tryGettingFishBucketHackery(entity, entity.method_37908());
        } else if (CompatHandler.QUARK && !(b = QuarkCompat.getSlimeBucket(entity)).method_7960()) {
            bucket = b;
        }
        if (!bucket.method_7960()) {
            BucketHelper.associateMobToBucketIfAbsent(entity.method_5864(), bucket.method_7909());
        }
        return bucket;
    }

    private static class_1799 tryGettingFishBucketHackery(class_1297 entity, class_1937 level) {
        class_1799 bucket = class_1799.field_8037;
        class_1657 player = FakePlayerManager.getDefault((class_1937)level);
        if (player != null) {
            class_1799 filledBucket;
            player.method_6122(class_1268.field_5808, new class_1799((class_1935)class_1802.field_8705));
            class_1269 result = entity.method_5688(player, class_1268.field_5808);
            if (!result.method_23665()) {
                player.method_6122(class_1268.field_5808, new class_1799((class_1935)class_1802.field_8550));
                result = entity.method_5688(player, class_1268.field_5808);
            }
            if (result.method_23665() && !(filledBucket = player.method_5998(class_1268.field_5808)).method_7960() && !entity.method_5805()) {
                bucket = filledBucket;
            }
        }
        return bucket;
    }

    public static Collection<class_1792> getValidBuckets() {
        return BUCKET_TO_MOB_MAP.keySet();
    }

    public static boolean isFishBucket(class_1792 item) {
        return BucketHelper.getEntityTypeFromBucket(item) != null;
    }

    private static void associateMobToBucketIfAbsent(class_1299<?> entity, class_1792 item) {
        if (!BUCKET_TO_MOB_MAP.inverse().containsKey(entity)) {
            BUCKET_TO_MOB_MAP.putIfAbsent((Object)item, entity);
        }
    }

    public static boolean isModdedFish(class_1297 entity) {
        return entity instanceof class_5761;
    }
}

