/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability;

import artifacts.ability.ArtifactAbility;
import artifacts.component.SwimData;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModAbilities;
import artifacts.registry.ModKeyMappings;
import artifacts.registry.ModSoundEvents;
import artifacts.util.AbilityHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import net.minecraft.class_9139;

public record SwimInAirAbility(Value<Integer> flightDuration, Value<Integer> rechargeDuration) implements ArtifactAbility
{
    public static final MapCodec<SwimInAirAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ValueTypes.DURATION.codec().fieldOf("flight_duration").forGetter(SwimInAirAbility::flightDuration), (App)ValueTypes.DURATION.codec().fieldOf("recharge_duration").forGetter(SwimInAirAbility::rechargeDuration)).apply((Applicative)instance, SwimInAirAbility::new));
    public static final class_9139<ByteBuf, SwimInAirAbility> STREAM_CODEC = class_9139.method_56435(ValueTypes.DURATION.streamCodec(), SwimInAirAbility::flightDuration, ValueTypes.DURATION.streamCodec(), SwimInAirAbility::rechargeDuration, SwimInAirAbility::new);

    public static void onHeliumFlamingoTick(class_1657 player) {
        boolean canFly;
        SwimData swimData = PlatformServices.platformHelper.getSwimData((class_1309)player);
        if (swimData == null) {
            return;
        }
        int maxFlightTime = SwimInAirAbility.getFlightDuration((class_1309)player);
        boolean shouldSink = AbilityHelper.hasAbilityActive((ArtifactAbility.Type)ModAbilities.SINKING.comp_349(), (class_1309)player);
        boolean bl = canFly = maxFlightTime > 0;
        if (swimData.isSwimming()) {
            if (swimData.getSwimTime() > maxFlightTime || player.method_5799() && !player.method_5681() && !shouldSink || (!player.method_5799() || shouldSink) && player.method_24828()) {
                swimData.setSwimming((class_1309)player, false);
                if (!player.method_24828() && !player.method_5799()) {
                    player.method_5783((class_3414)ModSoundEvents.POP.comp_349(), 0.5f, 0.75f);
                }
            }
            if (canFly && !PlatformServices.platformHelper.isEyeInWater(player) && !player.method_31549().field_7480) {
                swimData.setSwimTime(swimData.getSwimTime() + 1);
            }
        } else if (swimData.getSwimTime() < 0) {
            int rechargeTime = SwimInAirAbility.getRechargeDuration((class_1309)player);
            swimData.setSwimTime(swimData.getSwimTime() < -rechargeTime ? -rechargeTime : swimData.getSwimTime() + 1);
        }
    }

    public static int getFlightDuration(class_1309 entity) {
        return AbilityHelper.maxInt((ArtifactAbility.Type)ModAbilities.SWIM_IN_AIR.comp_349(), entity, ability -> (Integer)ability.flightDuration().get() * 20, false);
    }

    public static int getRechargeDuration(class_1309 entity) {
        return Math.max(20, AbilityHelper.maxInt((ArtifactAbility.Type)ModAbilities.SWIM_IN_AIR.comp_349(), entity, ability -> (Integer)ability.rechargeDuration().get() * 20, false));
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.SWIM_IN_AIR.comp_349();
    }

    @Override
    public boolean isNonCosmetic() {
        return (Integer)this.flightDuration().get() > 0;
    }

    @Override
    public void addAbilityTooltip(List<class_5250> tooltip) {
        tooltip.add(this.tooltipLine("swimming", new Object[0]));
    }

    @Override
    public void addToggleKeyTooltip(List<class_5250> tooltip) {
        tooltip.add(this.tooltipLine("keymapping", ModKeyMappings.getHeliumFlamingoKey().method_16007()));
    }
}

