/*
 * Decompiled with CFR 0.152.
 */
package games.twinhead.moreslabsstairsandwalls.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_6862;

public class ModBlock {
    private final class_2248 parentBlock;
    private boolean hasSlab = true;
    private boolean hasStairs = true;
    private boolean hasWall = true;
    private ModelType modelType;
    private ModBlock associatedBlock = null;
    private final List<class_6862<class_2248>> blockTags;
    private final List<class_6862<class_1792>> itemTags;

    public ModBlock(Builder builder) {
        this.parentBlock = builder.parentBlock;
        this.hasSlab = builder.hasSlab;
        this.hasStairs = builder.hasStairs;
        this.hasWall = builder.hasWall;
        this.blockTags = builder.blockTags;
        this.itemTags = builder.itemTags;
        this.associatedBlock = builder.associatedBlock;
        this.modelType = builder.build().modelType;
    }

    public static Builder builder(class_2248 parentBlock) {
        return new Builder(parentBlock);
    }

    public static class Builder {
        private final class_2248 parentBlock;
        private boolean hasSlab = true;
        private boolean hasStairs = true;
        private boolean hasWall = true;
        private ModelType modelType = ModelType.CUBE_ALL;
        private ModBlock associatedBlock = null;
        private final List<class_6862<class_2248>> blockTags;
        private final List<class_6862<class_1792>> itemTags;
        List<class_6862<class_2248>> mineableTags = List.of(class_3481.field_33715, class_3481.field_33713, class_3481.field_33716, class_3481.field_33714);

        public Builder(class_2248 parentBlock) {
            this.parentBlock = parentBlock;
            this.blockTags = new ArrayList<class_6862<class_2248>>();
            this.itemTags = new ArrayList<class_6862<class_1792>>();
            for (class_6862<class_2248> tag : this.mineableTags) {
                if (!parentBlock.method_9564().method_26164(tag)) continue;
                this.blockTags.add(tag);
            }
        }

        public Builder modelType(ModelType modelType) {
            this.modelType = modelType;
            return this;
        }

        @SafeVarargs
        public final Builder addBlockTags(class_6862<class_2248> ... blockTags) {
            this.blockTags.addAll(List.of(blockTags));
            return this;
        }

        public Builder addBlockTag(class_6862<class_2248> blockTag) {
            this.blockTags.add(blockTag);
            return this;
        }

        @SafeVarargs
        public final Builder addItemTags(class_6862<class_1792> ... itemTags) {
            this.itemTags.addAll(List.of(itemTags));
            return this;
        }

        public Builder addItemTag(class_6862<class_1792> itemTag) {
            this.itemTags.add(itemTag);
            return this;
        }

        public Builder hasSlab(boolean hasSlab) {
            this.hasSlab = hasSlab;
            return this;
        }

        public Builder hasStairs(boolean hasStairs) {
            this.hasStairs = hasStairs;
            return this;
        }

        public Builder hasWall(boolean hasWall) {
            this.hasWall = hasWall;
            return this;
        }

        public Builder associatedBlock(ModBlock associatedBlock) {
            this.associatedBlock = associatedBlock;
            return this;
        }

        public ModBlock build() {
            return new ModBlock(this);
        }
    }

    public static enum ModelType {
        CUBE_ALL,
        CUBE_COLUMN,
        CUBE_BOTTOM_TOP,
        LOG,
        GRASS,
        LEAVES,
        GLASS,
        PATH,
        LOG_ALL,
        CUSTOM,
        GLAZED_TERRACOTTA,
        ROTATABLE,
        SLIME,
        HONEY,
        TRANSLUCENT,
        ROOTS,
        CUSTOM_SIDE_BOTTOM_TOP;

    }
}

