/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.util;

import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;

public final class TextScaleStack
extends Stack<Entry> {
    private static final long serialVersionUID = -8954458726234722058L;
    @Nullable
    private Entry lastCalculation;

    @Override
    public final Entry push(float scale) {
        return this.push(scale, BlendMethod.MULTIPLY);
    }

    public final Entry push(float scale, BlendMethod blendMethod) {
        return this.push(new Entry(scale, blendMethod));
    }

    @Override
    public final Entry push(Entry item) {
        this.lastCalculation = null;
        return super.push(item);
    }

    @Override
    public final synchronized Entry pop() {
        this.lastCalculation = null;
        return (Entry)super.pop();
    }

    public final void apply(TDrawContext pencil) {
        this.calculate().apply(pencil);
    }

    public final Entry calculate() {
        if (this.lastCalculation != null) {
            return this.lastCalculation;
        }
        float scale = 1.0f;
        for (Entry entry : this) {
            switch (entry.blendMethod.ordinal()) {
                case 3: {
                    scale *= entry.scale;
                    break;
                }
                case 1: {
                    scale += entry.scale;
                    break;
                }
                case 0: {
                    scale = entry.scale;
                    break;
                }
                case 2: {
                    scale -= entry.scale;
                    break;
                }
            }
        }
        this.lastCalculation = new Entry(scale, null);
        return this.lastCalculation;
    }

    public static enum BlendMethod {
        SET,
        ADD,
        SUBTRACT,
        MULTIPLY;

    }

    public static final class Entry {
        public final float scale;
        @Nullable
        public final BlendMethod blendMethod;

        public Entry() {
            this(1.0f);
        }

        public Entry(float scale) {
            this(scale, BlendMethod.MULTIPLY);
        }

        public Entry(float scale, BlendMethod blendMethod) {
            this.scale = Math.abs(scale);
            this.blendMethod = blendMethod;
        }

        public final void apply(TDrawContext pencil) {
            pencil.textScale = Math.abs(this.scale);
        }
    }
}

