/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.tclayer;

import com.google.common.collect.BiMap;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.compat.WrappedTrinketComponent;
import dev.emi.trinkets.compat.WrappedTrinketInventory;
import dev.emi.trinkets.compat.WrappingTrinketsUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.tclayer.TCLayer;
import io.wispforest.tclayer.compat.config.SlotIdRedirect;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1309;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OuterGroupMap
implements Map<String, Map<String, TrinketInventory>> {
    private final Map<String, Map<String, SlotType>> groupedAccessorySlots;
    private final WrappedTrinketComponent trinketComponent;
    private final AccessoriesCapability capability;
    private final Consumer<String> errorMessage;

    public OuterGroupMap(Map<String, Map<String, SlotType>> groupedAccessorySlots, WrappedTrinketComponent trinketComponent, AccessoriesCapability capability, Consumer<String> errorMessage) {
        this.groupedAccessorySlots = groupedAccessorySlots;
        this.trinketComponent = trinketComponent;
        this.capability = capability;
        this.errorMessage = errorMessage;
    }

    @Override
    public Map<String, TrinketInventory> get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String str = (String)key;
        return new InnerSlotMap(str);
    }

    @Override
    public int size() {
        return this.groupedAccessorySlots.size();
    }

    @Override
    public boolean isEmpty() {
        return this.groupedAccessorySlots.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        String str = (String)key;
        return this.groupedAccessorySlots.containsKey(WrappingTrinketsUtils.trinketsToAccessories_Group(str));
    }

    @Override
    public boolean containsValue(Object value) {
        return true;
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return this.groupedAccessorySlots.keySet().stream().map(WrappingTrinketsUtils::accessoriesToTrinkets_Group).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Collection<Map<String, TrinketInventory>> values() {
        return this.keySet().stream().map(x$0 -> new InnerSlotMap((String)x$0)).toList();
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, Map<String, TrinketInventory>>> entrySet() {
        return this.keySet().stream().map(string -> Map.entry(string, new InnerSlotMap((String)string))).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    public Map<String, TrinketInventory> put(String key, Map<String, TrinketInventory> value) {
        return null;
    }

    @Override
    public Map<String, TrinketInventory> remove(Object key) {
        return null;
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ? extends Map<String, TrinketInventory>> m) {
    }

    @Override
    public void clear() {
    }

    public class InnerSlotMap
    implements Map<String, TrinketInventory> {
        private final String currentTrinketsGroup;

        public InnerSlotMap(String currentTrinketsGroup) {
            this.currentTrinketsGroup = currentTrinketsGroup;
        }

        @Nullable
        public Map<String, SlotType> groupMap() {
            return OuterGroupMap.this.groupedAccessorySlots.get(WrappingTrinketsUtils.trinketsToAccessories_Group(this.currentTrinketsGroup));
        }

        @Override
        public int size() {
            Map<String, SlotType> groupMap = this.groupMap();
            return groupMap != null ? groupMap.size() : 0;
        }

        @Override
        public boolean isEmpty() {
            Map<String, SlotType> groupMap = this.groupMap();
            return groupMap == null || groupMap.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            if (!(key instanceof String)) {
                return false;
            }
            String trinketKey = (String)key;
            BiMap<String, String> redirects = SlotIdRedirect.getBiMap(TCLayer.CONFIG.slotIdRedirects());
            String redirect = (String)redirects.get((Object)(this.currentTrinketsGroup + "/" + trinketKey));
            if (redirect != null && SlotTypeLoader.getSlotType((class_1309)OuterGroupMap.this.capability.entity(), (String)redirect) != null) {
                return true;
            }
            Map<String, SlotType> groupMap = this.groupMap();
            String accessoryKey = WrappingTrinketsUtils.trinketsToAccessories_Slot(Optional.of(this.currentTrinketsGroup), trinketKey);
            return groupMap != null && groupMap.containsKey(accessoryKey);
        }

        @Override
        public boolean containsValue(Object value) {
            return true;
        }

        @Override
        public TrinketInventory get(Object key) {
            SlotType redirectSlot;
            if (!(key instanceof String)) {
                return null;
            }
            String trinketKey = (String)key;
            BiMap<String, String> redirects = SlotIdRedirect.getBiMap(TCLayer.CONFIG.slotIdRedirects());
            String redirect = (String)redirects.get((Object)(this.currentTrinketsGroup + "/" + trinketKey));
            if (redirect != null && (redirectSlot = SlotTypeLoader.getSlotType((class_1309)OuterGroupMap.this.capability.entity(), (String)redirect)) != null) {
                return this.create(redirectSlot);
            }
            Map<String, SlotType> groupMap = this.groupMap();
            if (groupMap == null) {
                OuterGroupMap.this.errorMessage.accept("Unable to locate the given group: [" + this.currentTrinketsGroup + "]");
                return null;
            }
            String accessoryKey = WrappingTrinketsUtils.trinketsToAccessories_Slot(Optional.of(this.currentTrinketsGroup), trinketKey);
            SlotType slotType = groupMap.get(accessoryKey);
            if (slotType == null) {
                OuterGroupMap.this.errorMessage.accept("Unable to locate the given slot type: [Trinket Group: " + this.currentTrinketsGroup + ", Trinket Slot: " + trinketKey + "] : [Accessory Group: " + WrappingTrinketsUtils.trinketsToAccessories_Group(this.currentTrinketsGroup) + ", Accessory Slot: " + accessoryKey + "]");
                return null;
            }
            return this.create(slotType);
        }

        private TrinketInventory create(SlotType type) {
            AccessoriesContainer container = (AccessoriesContainer)OuterGroupMap.this.capability.getContainers().get(type.name());
            if (container == null) {
                throw new IllegalStateException("Unable to get the required Accessories container to wrap for Trinkets API call: [Slot: " + type.name() + "]");
            }
            return new WrappedTrinketInventory(OuterGroupMap.this.trinketComponent, container, type);
        }

        @Override
        @NotNull
        public Set<String> keySet() {
            Map<String, SlotType> groupMap = this.groupMap();
            if (groupMap == null) {
                return Set.of();
            }
            return groupMap.keySet().stream().map(WrappingTrinketsUtils::accessoriesToTrinkets_Slot).collect(Collectors.toSet());
        }

        @Override
        @NotNull
        public Collection<TrinketInventory> values() {
            Map<String, SlotType> groupMap = this.groupMap();
            if (groupMap == null) {
                return Set.of();
            }
            return groupMap.values().stream().map(this::create).collect(Collectors.toSet());
        }

        @Override
        @NotNull
        public Set<Map.Entry<String, TrinketInventory>> entrySet() {
            Map<String, SlotType> groupMap = this.groupMap();
            if (groupMap == null) {
                return Set.of();
            }
            return groupMap.values().stream().map(slotType -> Map.entry(WrappingTrinketsUtils.accessoriesToTrinkets_Slot(slotType.name()), this.create((SlotType)slotType))).collect(Collectors.toSet());
        }

        @Override
        @Nullable
        public TrinketInventory put(String key, TrinketInventory value) {
            return null;
        }

        @Override
        public TrinketInventory remove(Object key) {
            return null;
        }

        @Override
        public void putAll(@NotNull Map<? extends String, ? extends TrinketInventory> m) {
        }

        @Override
        public void clear() {
        }
    }
}

