/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.impl;

import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentController;
import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentManager;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingMode;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import com.github.thedeathlycow.thermoo.api.temperature.Soakable;
import com.github.thedeathlycow.thermoo.api.temperature.TemperatureAware;
import com.github.thedeathlycow.thermoo.api.temperature.event.PlayerEnvironmentEvents;
import com.github.thedeathlycow.thermoo.impl.component.EnvironmentComponent;
import com.github.thedeathlycow.thermoo.impl.component.ThermooComponents;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public class LivingEntityEnvironmentTickImpl {
    public static void tick(class_1309 entity) {
        boolean isSyncTick;
        class_1937 world = entity.method_37908();
        if (world.method_8608() || entity.method_7325() || entity.method_29504() || entity.method_31481()) {
            return;
        }
        EnvironmentController controller = EnvironmentManager.INSTANCE.getController();
        int tempChange = controller.getHeatAtLocation(world, entity.method_5668().method_24515());
        if ((tempChange = controller.applyAwareHeat((TemperatureAware)entity, tempChange)) != 0) {
            entity.thermoo$addTemperature(tempChange, (HeatingMode)HeatingModes.PASSIVE);
        }
        if ((tempChange = controller.getTemperatureEffectsChange(entity)) != 0) {
            entity.thermoo$addTemperature(tempChange, (HeatingMode)HeatingModes.ACTIVE);
        }
        int soakChange = controller.getSoakChange((Soakable)entity);
        boolean bl = isSyncTick = entity.field_6012 % 20 == 0;
        if (soakChange != 0) {
            entity.thermoo$addWetTicks(soakChange);
        }
        if (isSyncTick || ((EnvironmentComponent)ThermooComponents.TEMPERATURE.get((Object)entity)).isDirty()) {
            ThermooComponents.TEMPERATURE.sync((Object)entity);
        }
        if (isSyncTick || ((EnvironmentComponent)ThermooComponents.WETNESS.get((Object)entity)).isDirty()) {
            ThermooComponents.WETNESS.sync((Object)entity);
        }
    }

    public static void tickPlayer(class_1657 player) {
        TriState canApplyChange;
        class_1937 world = player.method_37908();
        if (world.field_9236 || player.method_7325()) {
            return;
        }
        class_2338 pos = player.method_24515();
        EnvironmentController controller = EnvironmentManager.INSTANCE.getController();
        int temperatureChange = controller.getLocalTemperatureChange(world, pos);
        if (temperatureChange != 0 && (canApplyChange = ((PlayerEnvironmentEvents.TemperatureChangeEventCallback)PlayerEnvironmentEvents.CAN_APPLY_PASSIVE_TEMPERATURE_CHANGE.invoker()).canApplyChange(temperatureChange, player)) == TriState.TRUE) {
            temperatureChange = controller.getEnvironmentTemperatureForPlayer(player, temperatureChange);
            player.thermoo$addTemperature(temperatureChange, (HeatingMode)HeatingModes.PASSIVE);
        }
    }

    private LivingEntityEnvironmentTickImpl() {
    }
}

