/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.impl;

import com.github.thedeathlycow.thermoo.api.ThermooRegistryKeys;
import com.github.thedeathlycow.thermoo.api.temperature.effects.ConfiguredTemperatureEffect;
import com.github.thedeathlycow.thermoo.impl.Thermoo;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class TemperatureEffectLoader
implements SimpleSynchronousResourceReloadListener {
    public static final TemperatureEffectLoader INSTANCE = new TemperatureEffectLoader(Thermoo.id("temperature_effects"));
    private final Map<class_2960, ConfiguredTemperatureEffect<?>> globalEffects = new HashMap();
    private final Map<class_5321<class_1299<?>>, Set<ConfiguredTemperatureEffect<?>>> entityTypeToEffect = new IdentityHashMap();
    private final class_2960 id;

    public TemperatureEffectLoader(class_2960 id) {
        this.id = id;
    }

    public Collection<ConfiguredTemperatureEffect<?>> getEffectsForEntity(class_1309 entity) {
        class_1299 type = entity.method_5864();
        class_5321 key = type.method_40124().method_40237();
        Set<ConfiguredTemperatureEffect<?>> effects = this.entityTypeToEffect.get(key);
        if (effects == null) {
            return Collections.emptySet();
        }
        return effects;
    }

    public Collection<ConfiguredTemperatureEffect<?>> getGlobalEffects() {
        return this.globalEffects.values();
    }

    public class_2960 getFabricId() {
        return this.id;
    }

    public void method_14491(class_3300 manager) {
        HashMap registry = new HashMap();
        Map entries = manager.method_41265("thermoo/temperature_effect", eid -> eid.method_12832().endsWith(".json"));
        for (Map.Entry entry : entries.entrySet()) {
            class_2960 key = (class_2960)entry.getKey();
            for (class_3298 resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.method_43039();
                    try {
                        this.loadEffect(registry, key, reader);
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (Exception e) {
                    Thermoo.LOGGER.error("An error occurred while loading temperature effect {}: {}", entry.getKey(), (Object)e);
                }
            }
        }
        HashMap newEffects = new HashMap();
        IdentityHashMap newTypeEffects = new IdentityHashMap();
        this.partitionRegistry(registry, newEffects, newTypeEffects);
        this.globalEffects.clear();
        this.globalEffects.putAll(newEffects);
        this.entityTypeToEffect.clear();
        this.entityTypeToEffect.putAll(newTypeEffects);
        int numEffects = this.globalEffects.size();
        int numTypeEffects = this.entityTypeToEffect.values().stream().map(Set::size).reduce(0, Integer::sum);
        Thermoo.LOGGER.info("Loaded {} global temperature effect{}", (Object)numEffects, (Object)(numEffects == 1 ? "" : "s"));
        Thermoo.LOGGER.info("Loaded {} type specific temperature effect{}", (Object)numTypeEffects, (Object)(numTypeEffects == 1 ? "" : "s"));
    }

    private void loadEffect(Map<class_2960, ConfiguredTemperatureEffect<?>> registry, class_2960 id, BufferedReader reader) {
        JsonElement json = JsonParser.parseReader((Reader)reader);
        if (json.isJsonObject() && this.objectMatchesConditions(id, json.getAsJsonObject())) {
            ConfiguredTemperatureEffect<?> existingEffect;
            ConfiguredTemperatureEffect effect = (ConfiguredTemperatureEffect)((Pair)ConfiguredTemperatureEffect.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow()).getFirst();
            boolean overridden = false;
            if (registry.containsKey(id) && (existingEffect = registry.get(id)).loadingPriority() > effect.loadingPriority()) {
                overridden = true;
            }
            if (!overridden) {
                registry.put(id, effect);
            } else {
                Thermoo.LOGGER.info("Temperature Effect {} tried to load, but was overridden by a higher priority effect with the same ID.", (Object)id);
            }
        } else {
            Thermoo.LOGGER.info("Temperature Effect {} not loaded, as its resource conditions were not met.", (Object)id);
        }
    }

    private boolean objectMatchesConditions(class_2960 key, JsonObject json) {
        if (json.has("fabric:load_conditions")) {
            DataResult conditions = ResourceCondition.CONDITION_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get("fabric:load_conditions"));
            if (conditions.isSuccess()) {
                boolean matched = ((ResourceCondition)conditions.getOrThrow()).test(null);
                if (Thermoo.LOGGER.isDebugEnabled()) {
                    String verdict = matched ? "Allowed" : "Rejected";
                    Thermoo.LOGGER.debug("{} resource of type {} with id {}", new Object[]{verdict, class_7924.method_60915(ThermooRegistryKeys.TEMPERATURE_EFFECT), key});
                }
                return matched;
            }
            Thermoo.LOGGER.error("Failed to parse resource conditions for file of type {} with id {}, skipping: {}", new Object[]{class_7924.method_60915(ThermooRegistryKeys.TEMPERATURE_EFFECT), key, ((DataResult.Error)conditions.error().get()).message()});
        }
        return true;
    }

    private void partitionRegistry(Map<class_2960, ConfiguredTemperatureEffect<?>> registry, Map<class_2960, ConfiguredTemperatureEffect<?>> globalEffects, Map<class_5321<class_1299<?>>, Set<ConfiguredTemperatureEffect<?>>> typeEffects) {
        registry.forEach((key, value) -> value.entityType().ifPresentOrElse(entityType -> typeEffects.computeIfAbsent(entityType.method_40124().method_40237(), eid -> new HashSet()).add(value), () -> globalEffects.put((class_2960)key, (ConfiguredTemperatureEffect<?>)value)));
    }
}

